/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.SchemaGenerator;
import org.netbeans.modules.xml.axi.impl.AXIDocumentImpl;
import org.netbeans.modules.xml.axi.impl.AXIModelListener;
import org.netbeans.modules.xml.axi.impl.AXIModelUpdater;
import org.netbeans.modules.xml.axi.impl.OtherAXIModelListener;
import org.netbeans.modules.xml.axi.impl.SchemaModelListener;
import org.netbeans.modules.xml.axi.impl.Util;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.util.WeakListeners;

public class AXIModelImpl
extends AXIModel {
    private AXIModelListener propertyListener;
    private SchemaModelListener schemaModelListener;
    private OtherAXIModelListener axiModelListener = new OtherAXIModelListener(this);
    private WeakHashMap<AXIModel, ComponentListener> listenerMap = new WeakHashMap();
    private boolean designPatternMode = false;
    private boolean isAXIDocumentInitialized = false;
    private SchemaGenerator.Pattern schemaDesignPattern;
    private HashMap<String, NamedReferenceable> mapReferenceable = new HashMap();
    private boolean isForceSync = false;

    public AXIModelImpl(ModelSource modelSource) {
        super(modelSource);
        this.propertyListener = new AXIModelListener();
        this.addPropertyChangeListener(this.propertyListener);
        this.schemaModelListener = new SchemaModelListener(this);
        this.getSchemaModel().addPropertyChangeListener((PropertyChangeListener)this.schemaModelListener);
    }

    boolean isAXIDocumentInitialized() {
        return this.isAXIDocumentInitialized;
    }

    void initializeAXIDocument() {
        AXIDocument doc = this.getRoot();
        Schema schema = (Schema)doc.getPeer();
        if (schema == null) {
            doc.setPeer((SchemaComponent)this.getSchemaModel().getSchema());
        }
        Util.updateAXIDocument(doc);
        this.isAXIDocumentInitialized = true;
        SchemaGenerator.Pattern dp = null;
        if (dp != null) {
            this.setSchemaDesignPattern(dp);
        } else {
            this.setSchemaDesignPattern(SchemaGenerator.DEFAULT_DESIGN_PATTERN);
        }
    }

    public boolean fromSameSchemaModel(SchemaComponent schemaComponent) {
        return this.getSchemaModel() == schemaComponent.getModel();
    }

    public AXIComponent lookupFromOtherModel(SchemaComponent schemaComponent) {
        if (!schemaComponent.isInDocumentModel()) {
            return null;
        }
        AXIModelFactory factory = AXIModelFactory.getDefault();
        AXIModelImpl model = (AXIModelImpl)factory.getModel(schemaComponent.getModel());
        return model != null ? model.lookup(schemaComponent) : null;
    }

    public AXIComponent lookup(SchemaComponent schemaComponent) {
        return ((AXIDocumentImpl)this.getRoot()).findChild(schemaComponent);
    }

    protected boolean needsSync() {
        if (this.isForceSync) {
            return true;
        }
        if (!this.isAXIDocumentInitialized()) {
            return true;
        }
        if (this.designPatternMode || this.isIntransaction()) {
            return false;
        }
        if (this.axiModelListener != null) {
            return this.axiModelListener.needsSync() || this.schemaModelListener.needsSync();
        }
        return this.schemaModelListener.needsSync();
    }

    void disableAutoSync() {
        this.designPatternMode = true;
        super.getAccess().setAutoSync(false);
    }

    void enableAutoSync() {
        this.designPatternMode = false;
        super.getAccess().setAutoSync(true);
    }

    protected void syncStarted() {
        try {
            this.getSchemaModel().sync();
        }
        catch (IOException ex) {
            this.setState(Model.State.NOT_SYNCED);
        }
    }

    protected void syncCompleted() {
        this.schemaModelListener.syncCompleted();
        if (this.axiModelListener != null) {
            this.axiModelListener.syncCompleted();
        }
        this.propertyListener.clearEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        if (!this.needsSync()) {
            return;
        }
        try {
            SchemaModel schemaModel = this.getSchemaModel();
            synchronized (schemaModel) {
                super.sync();
            }
        }
        catch (IOException ex) {
            this.setState(Model.State.NOT_SYNCED);
        }
        finally {
            this.setForceSync(false);
        }
    }

    public synchronized boolean doSync() {
        AXIModelUpdater updater = new AXIModelUpdater(this);
        return updater.doSync();
    }

    @Override
    public SchemaGenerator.Pattern getSchemaDesignPattern() {
        return this.schemaDesignPattern;
    }

    @Override
    public void setSchemaDesignPattern(SchemaGenerator.Pattern schemaDesignPattern) {
        this.schemaDesignPattern = schemaDesignPattern;
    }

    public AXIModelListener getPropertyChangeListener() {
        return this.propertyListener;
    }

    public boolean validate() {
        Model.State state = this.getSchemaModel().getState();
        return state == Model.State.VALID;
    }

    @Override
    public List<AXIModel> getReferencedModels() {
        List<AXIModel> models = Collections.emptyList();
        Schema schema = this.getSchemaModel().getSchema();
        if (schema == null) {
            return models;
        }
        Collection refs = schema.getSchemaReferences();
        if (refs == null || refs.size() == 0) {
            return models;
        }
        models = new ArrayList<AXIModel>();
        Iterator iter = refs.iterator();
        while (iter.hasNext()) {
            try {
                SchemaModelReference ref = (SchemaModelReference)iter.next();
                Schema s = ref.resolveReferencedModel().getSchema();
                AXIModel m = AXIModelFactory.getDefault().getModel(ref.resolveReferencedModel());
                models.add(m);
            }
            catch (CatalogModelException catalogModelException) {}
        }
        return Collections.unmodifiableList(models);
    }

    void buildReferenceableCache() {
        this.listenerMap.clear();
        Schema schema = this.getSchemaModel().getSchema();
        if (schema == null) {
            return;
        }
        this.buildCache(schema);
        Collection refs = schema.getSchemaReferences();
        if (refs == null || refs.size() == 0) {
            return;
        }
        Iterator iter = refs.iterator();
        while (iter.hasNext()) {
            try {
                SchemaModelReference ref = (SchemaModelReference)iter.next();
                Schema s = ref.resolveReferencedModel().getSchema();
                this.buildCache(s);
                if (!this.getRoot().canVisitChildren()) continue;
                AXIModel m = AXIModelFactory.getDefault().getModel(ref.resolveReferencedModel());
                this.listenToReferencedModel(m);
            }
            catch (Exception ex) {}
        }
    }

    public void listenToReferencedModel(AXIModel model) {
        if (this.listenerMap.get((Object)model) == null) {
            ComponentListener listener = (ComponentListener)WeakListeners.create(ComponentListener.class, (EventListener)((Object)this.axiModelListener), (Object)((Object)model));
            model.addComponentListener(listener);
            this.listenerMap.put(model, listener);
        }
    }

    private void buildCache(Schema schema) {
        for (SchemaComponent child : schema.getChildren()) {
            if (!(child instanceof NamedReferenceable)) continue;
            NamedReferenceable ref = (NamedReferenceable)child;
            this.mapReferenceable.put(schema.getTargetNamespace() + ":" + ref.getName(), ref);
        }
    }

    public SchemaComponent getReferenceableSchemaComponent(NamedComponentReference ncr) {
        String name = ncr.getQName().getNamespaceURI() + ":" + ncr.getQName().getLocalPart();
        Class elementType = ncr.getType();
        NamedReferenceable ref = this.mapReferenceable.get(name);
        if (ref != null && elementType.isAssignableFrom(ref.getClass())) {
            return (SchemaComponent)ref;
        }
        return (SchemaComponent)ncr.get();
    }

    public String toString() {
        if (this.getRoot() == null) {
            return null;
        }
        return this.getRoot().getTargetNamespace();
    }

    public void setForceSync(boolean b) {
        this.isForceSync = b;
    }

    public AXIComponent findChild(SchemaComponent child) {
        AXIDocumentImpl doc = (AXIDocumentImpl)this.getRoot();
        return doc.findChild(child);
    }
}

