/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.run;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.docker.ui.UiUtils;
import org.netbeans.modules.docker.ui.run.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class RunContainerPropertiesVisual
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton addButton;
    private JLabel commandLabel;
    private JTextField commandTextField;
    private JButton deleteButton;
    private JCheckBox interactiveCheckBox;
    private JScrollPane jScrollPane2;
    private JCheckBox mountVolumesCheckBox;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JCheckBox privilegedCheckBox;
    private JCheckBox ttyCheckBox;
    private JLabel userLabel;
    private JTextField userTextField;
    private JTable volumesTable;

    public RunContainerPropertiesVisual() {
        this.initComponents();
        this.volumesTable.setVisible(this.mountVolumesCheckBox.isSelected());
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RunContainerPropertiesVisual.this.changeSupport.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RunContainerPropertiesVisual.this.changeSupport.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RunContainerPropertiesVisual.this.changeSupport.fireChange();
            }
        });
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public String getName() {
        return Bundle.LBL_RunContainerProperties();
    }

    public String getContainerName() {
        return UiUtils.getValue(this.nameTextField);
    }

    public void setContainerName(String name) {
        this.nameTextField.setText(name);
    }

    public String getCommand() {
        return UiUtils.getValue(this.commandTextField);
    }

    public void setCommand(String command) {
        this.commandTextField.setText(command);
    }

    public String getUser() {
        return UiUtils.getValue(this.userTextField);
    }

    public void setUser(String user) {
        this.userTextField.setText(user);
    }

    public boolean isInteractive() {
        return this.interactiveCheckBox.isSelected();
    }

    public void setInteractive(boolean interactive) {
        this.interactiveCheckBox.setSelected(interactive);
    }

    public boolean hasTty() {
        return this.ttyCheckBox.isSelected();
    }

    public void setTty(boolean tty) {
        this.ttyCheckBox.setSelected(tty);
    }

    public boolean isPrivileged() {
        return this.privilegedCheckBox.isSelected();
    }

    public void setPrivileged(boolean privileged) {
        this.privilegedCheckBox.setSelected(privileged);
    }

    public boolean areMountVolumesSelected() {
        return this.mountVolumesCheckBox.isSelected();
    }

    public void setMountVolumesSelected(boolean selected) {
        this.mountVolumesCheckBox.setSelected(selected);
    }

    public Map<String, String> getVolumesTable() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        DefaultTableModel model = (DefaultTableModel)this.volumesTable.getModel();
        if (this.volumesTable.isEditing()) {
            this.volumesTable.getCellEditor().stopCellEditing();
        }
        Iterator<Vector> iterator = model.getDataVector().iterator();
        while (iterator.hasNext()) {
            Vector o;
            Vector v = o = iterator.next();
            String target = (String)v.elementAt(0);
            String source = (String)v.elementAt(1);
            if (target == null || source == null) continue;
            result.put(target, source);
        }
        return result;
    }

    private void initComponents() {
        this.commandLabel = new JLabel();
        this.commandTextField = new JTextField();
        this.interactiveCheckBox = new JCheckBox();
        this.ttyCheckBox = new JCheckBox();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.privilegedCheckBox = new JCheckBox();
        this.mountVolumesCheckBox = new JCheckBox();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.volumesTable = new JTable();
        this.commandLabel.setLabelFor(this.commandTextField);
        Mnemonics.setLocalizedText((JLabel)this.commandLabel, (String)NbBundle.getMessage(RunContainerPropertiesVisual.class, (String)"RunContainerPropertiesVisual.commandLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.interactiveCheckBox, (String)NbBundle.getMessage(RunContainerPropertiesVisual.class, (String)"RunContainerPropertiesVisual.interactiveCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.ttyCheckBox, (String)NbBundle.getMessage(RunContainerPropertiesVisual.class, (String)"RunContainerPropertiesVisual.ttyCheckBox.text"));
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(RunContainerPropertiesVisual.class, (String)"RunContainerPropertiesVisual.nameLabel.text"));
        this.nameTextField.setColumns(15);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(RunContainerPropertiesVisual.class, (String)"RunContainerPropertiesVisual.userLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.privilegedCheckBox, (String)NbBundle.getMessage(RunContainerPropertiesVisual.class, (String)"RunContainerPropertiesVisual.privilegedCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.mountVolumesCheckBox, (String)NbBundle.getMessage(RunContainerPropertiesVisual.class, (String)"RunContainerPropertiesVisual.mountVolumesCheckBox.text"));
        this.mountVolumesCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                RunContainerPropertiesVisual.this.mountVolumesCheckBoxStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(RunContainerPropertiesVisual.class, (String)"RunContainerPropertiesVisual.addButton.text"));
        this.addButton.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage(RunContainerPropertiesVisual.class, (String)"RunContainerPropertiesVisual.deleteButton.text"));
        this.deleteButton.setEnabled(false);
        this.volumesTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Target", "Source"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.volumesTable.setEnabled(false);
        this.volumesTable.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.volumesTable);
        if (this.volumesTable.getColumnModel().getColumnCount() > 0) {
            this.volumesTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(RunContainerPropertiesVisual.class, (String)"RunContainerPropertiesVisual.volumesTable.columnModel.title0"));
            this.volumesTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(RunContainerPropertiesVisual.class, (String)"RunContainerPropertiesVisual.volumesTable.columnModel.title1"));
        }
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.interactiveCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.ttyCheckBox, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.commandLabel).addComponent(this.userLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameTextField).addComponent(this.commandTextField).addComponent(this.userTextField))).addComponent(this.privilegedCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.mountVolumesCheckBox, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 447, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton, -2, 88, -2).addComponent(this.deleteButton, -2, 88, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.commandLabel).addComponent(this.commandTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userLabel).addComponent(this.userTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.interactiveCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ttyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.privilegedCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mountVolumesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton).addContainerGap(75, Short.MAX_VALUE)).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE))));
    }

    private void mountVolumesCheckBoxStateChanged(ChangeEvent evt) {
        boolean selected = this.mountVolumesCheckBox.isSelected();
        this.volumesTable.setVisible(selected);
        this.volumesTable.setEnabled(selected);
        this.addButton.setEnabled(selected);
        this.deleteButton.setEnabled(selected);
    }
}

