/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.docker.api.DockerInstanceEntity;
import org.netbeans.modules.docker.ui.JsonFormattingWriter;
import org.netbeans.modules.docker.ui.node.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class InspectContainerAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(InspectContainerAction.class.getName());
    private final RequestProcessor requestProcessor = new RequestProcessor(InspectContainerAction.class);

    public String getName() {
        return Bundle.LBL_InspectAction();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            DockerInstanceEntity entity = (DockerInstanceEntity)node.getLookup().lookup(DockerInstanceEntity.class);
            if (entity != null) continue;
            return false;
        }
        return true;
    }

    protected void performAction(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            DockerInstanceEntity container = (DockerInstanceEntity)node.getLookup().lookup(DockerInstanceEntity.class);
            if (container == null) continue;
            this.requestProcessor.post((Runnable)new InspectRunnable(container));
        }
    }

    private static class InspectRunnable
    implements Runnable {
        private final DockerInstanceEntity container;

        public InspectRunnable(DockerInstanceEntity container) {
            this.container = container;
        }

        @Override
        public void run() {
            JsonFormattingWriter formattedJsonWriter = new JsonFormattingWriter(2);
            try {
                DockerAction facade = new DockerAction(this.container.getInstance());
                JSONObject rawDetails = facade.getRawDetails(this.container.getType(), this.container.getId());
                rawDetails.writeJSONString((Writer)formattedJsonWriter);
                InputOutput io = IOProvider.getDefault().getIO(Bundle.MSG_Inspecting(this.container.getShortId()), false);
                io.getOut().reset();
                io.getOut().println(formattedJsonWriter.toString());
                io.getOut().close();
                io.getErr().close();
                io.select();
            }
            catch (IOException | DockerException ex) {
                LOGGER.log(Level.INFO, null, ex);
                String msg = ex.getLocalizedMessage();
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)msg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
        }
    }
}

