/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.spi.actions.NbAction;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

final class MergeAction
extends NbAction
implements PropertyChangeListener {
    private NbAction[] actions;
    private Map<String, Object> knownValues = new HashMap<String, Object>();
    private Action delegateAction;
    private volatile boolean enabled;
    final boolean allowOnlyOne;
    boolean logged;

    public MergeAction(NbAction[] actions, boolean allowOnlyOne) {
        this.actions = actions;
        this.allowOnlyOne = allowOnlyOne;
        assert (actions.length > 0);
        assert (new HashSet<NbAction>(Arrays.asList(actions)).size() == actions.length) : "Duplicate actions in " + Arrays.asList(actions);
        for (int i = 0; i < actions.length; ++i) {
            Parameters.notNull((CharSequence)("Action " + i), (Object)actions[i]);
        }
        this.knownValues.put("Name", null);
        this.knownValues.put("AcceleratorKey", null);
        this.knownValues.put("LongDescription", null);
        this.knownValues.put("SmallIcon", null);
        this.knownValues.put("ShortDescription", null);
        this.knownValues.put("LongDescription", null);
        this.knownValues.put("SmallIcon", null);
        this.knownValues.put("MnemonicKey", null);
        this.knownValues.put("noIconInMenu", null);
        this.knownValues.put("enabled", null);
    }

    public MergeAction(NbAction[] actions) {
        this(actions, false);
    }

    public boolean equals(Object o) {
        return o != null && MergeAction.class == o.getClass() && Arrays.equals(((MergeAction)o).actions, this.actions);
    }

    public int hashCode() {
        return Arrays.hashCode(this.actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Action updateDelegateAction() {
        MergeAction mergeAction = this;
        synchronized (mergeAction) {
            return this.setDelegateAction(this.findEnabledAction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Action setDelegateAction(Action a) {
        assert (Thread.holdsLock(this));
        MergeAction mergeAction = this;
        synchronized (mergeAction) {
            Action old = this.delegateAction;
            if (old != a) {
                this.delegateAction = a;
                boolean nowEnabled = this.getDelegateAction().isEnabled();
                if (nowEnabled != this.enabled) {
                    this.enabled = nowEnabled;
                    this.firePropertyChange("enabled", !this.enabled, this.enabled);
                }
                if (a != null) {
                    this.sievePropertyChanges();
                }
            }
        }
        return a;
    }

    Action findEnabledAction() {
        NbAction result = null;
        int enaCount = 0;
        NbAction.ActionRunnable<Boolean> ar = new NbAction.ActionRunnable<Boolean>(){

            @Override
            public Boolean run(NbAction a) {
                return a.isEnabled();
            }
        };
        for (NbAction a : this.actions) {
            if (!this.runActive(ar, a).booleanValue()) continue;
            ++enaCount;
            if (!this.allowOnlyOne) {
                result = a;
                break;
            }
            if (result != null) continue;
            result = a;
        }
        if (this.allowOnlyOne && enaCount > 1 && result != null) {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Action getDelegateAction() {
        Object result = null;
        MergeAction mergeAction = this;
        synchronized (mergeAction) {
            result = this.delegateAction;
            if (result == null || !result.isEnabled()) {
                result = this.attached() ? this.updateDelegateAction() : this.findEnabledAction();
            }
        }
        if (result == null) {
            result = this.actions[0];
        }
        return result;
    }

    private void sievePropertyChanges() {
        HashMap<String, Object> nue = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.knownValues.entrySet()) {
            String key = entry.getKey();
            Object expected = entry.getValue();
            Object found = this.getValue(key);
            if (found == expected) continue;
            nue.put(key, found);
            this.firePropertyChange(key, expected, found);
        }
    }

    @Override
    protected synchronized void addNotify() {
        for (NbAction a : this.actions) {
            a.addPropertyChangeListener(this);
        }
        this.updateDelegateAction();
    }

    @Override
    protected synchronized void removeNotify() {
        for (NbAction a : this.actions) {
            a.removePropertyChangeListener(this);
        }
        this.setDelegateAction(null);
    }

    @Override
    protected NbAction internalCreateContextAwareInstance(Lookup actionContext) {
        NbAction[] stubs = new NbAction[this.actions.length];
        for (int i = 0; i < stubs.length; ++i) {
            stubs[i] = (NbAction)((Object)this.actions[i].createContextAwareInstance(actionContext));
        }
        MergeAction result = new MergeAction(stubs, this.allowOnlyOne);
        result.knownValues.putAll(this.knownValues);
        result.pairs.putAll(this.pairs);
        return result;
    }

    @Override
    public Object getValue(final String key) {
        Object result = super.getValue(key);
        if (result == null && this.isEnabled()) {
            Action del = this.getDelegateAction();
            result = del.getValue(key);
        }
        if (result == null) {
            NbAction a;
            NbAction.ActionRunnable<Object> ar = new NbAction.ActionRunnable<Object>(){
                final /* synthetic */ MergeAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Object run(NbAction a) {
                    return a.getValue(key);
                }
            };
            NbAction[] nbActionArray = this.actions;
            int n = nbActionArray.length;
            for (int i = 0; i < n && (result = this.runActive(ar, a = nbActionArray[i])) == null; ++i) {
            }
        }
        this.knownValues.put(key, result);
        return result;
    }

    @Override
    public void putValue(String key, Object value) {
        if (!this.logged) {
            Logger.getLogger(MergeAction.class.getName()).log(Level.INFO, "putValue (" + key + ',' + value + "called on merged action.  This is probably a mistake.");
        }
        super.putValue(key, value);
    }

    public boolean isEnabled() {
        boolean result = this.updateEnabled();
        return result;
    }

    boolean updateEnabled() {
        this.enabled = this.getDelegateAction().isEnabled();
        if (this.allowOnlyOne && this.enabled && this.findEnabledAction() == null) {
            this.enabled = false;
        }
        return this.enabled;
    }

    public void actionPerformed(ActionEvent e) {
        Action a = this.getDelegateAction();
        if (a == null) {
            throw new IllegalStateException("Not enabled or no delegate: " + this);
        }
        a.actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean old = this.enabled;
        MergeAction mergeAction = this;
        synchronized (mergeAction) {
            if (this.attached()) {
                this.updateDelegateAction();
            }
        }
        boolean nowEnabled = this.isEnabled();
        if (!"enabled".equals(evt.getPropertyName())) {
            Object last = this.knownValues.get(evt.getPropertyName());
            Object mine = this.getValue(evt.getPropertyName());
            if (mine != last) {
                this.firePropertyChange(evt.getPropertyName(), last, mine);
            }
            this.knownValues.put(evt.getPropertyName(), evt.getNewValue());
        }
        if (old != nowEnabled) {
            this.firePropertyChange("enabled", old, nowEnabled);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append('[');
        for (int i = 0; i < this.actions.length; ++i) {
            sb.append(this.actions[i]);
            if (i == this.actions.length - 1) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }
}

