/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.wizards;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.websvc.api.support.ClientCreator;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JaxWsClientCreator
implements ClientCreator {
    private Project project;
    private WizardDescriptor wiz;

    public JaxWsClientCreator(Project project, WizardDescriptor wiz) {
        this.project = project;
        this.wiz = wiz;
    }

    public void createClient() throws IOException {
        FileObject wsdlFo;
        JAXWSLightSupport jaxWsSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.project.getProjectDirectory());
        String wsdlUrl = (String)this.wiz.getProperty("wsdlDownloadUrl");
        String filePath = (String)this.wiz.getProperty("wsdlFilePath");
        if (wsdlUrl == null) {
            wsdlUrl = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(filePath))).toURL().toExternalForm();
        }
        FileObject localWsdlFolder = jaxWsSupport.getWsdlFolder(true);
        boolean hasSrcFolder = false;
        File srcFile = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "src");
        hasSrcFolder = srcFile.exists() ? true : srcFile.mkdirs();
        if (localWsdlFolder != null && (wsdlFo = this.retrieveWsdl(wsdlUrl, localWsdlFolder, hasSrcFolder)) != null) {
            boolean isJaxWsLibrary = MavenModelUtils.hasJaxWsAPI(this.project);
            final String relativePath = FileUtil.getRelativePath((FileObject)localWsdlFolder, (FileObject)wsdlFo);
            final String clientName = wsdlFo.getName();
            Preferences prefs = ProjectUtils.getPreferences((Project)this.project, MavenWebService.class, (boolean)true);
            if (prefs != null) {
                prefs.put("_C_" + WSUtils.getUniqueId(wsdlFo.getName(), jaxWsSupport.getServices()), wsdlUrl);
            }
            if (!isJaxWsLibrary) {
                try {
                    MavenModelUtils.addMetroLibrary(this.project);
                    MavenModelUtils.addJavadoc(this.project);
                }
                catch (Exception ex) {
                    Logger.getLogger(JaxWsClientCreator.class.getName()).log(Level.INFO, "Cannot add Metro libbrary to pom file", ex);
                }
            }
            final String wsdlLocation = wsdlUrl;
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){
                final /* synthetic */ JaxWsClientCreator this$0;
                {
                    this.this$0 = this$0;
                }

                public void performOperation(POMModel model) {
                    String packageName = (String)this.this$0.wiz.getProperty("wsdlPackageName");
                    Plugin plugin = WSUtils.isEJB(this.this$0.project) ? MavenModelUtils.addJaxWSPlugin(model, "2.0") : MavenModelUtils.addJaxWSPlugin(model);
                    MavenModelUtils.addWsimportExecution(plugin, clientName, relativePath, wsdlLocation, packageName);
                    if (WSUtils.isWeb(this.this$0.project)) {
                        MavenModelUtils.addWarPlugin(model, true);
                    } else {
                        MavenModelUtils.addWsdlResources(model);
                    }
                }
            };
            Utilities.performPOMModelOperations((FileObject)this.project.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(operation));
            RunConfig cfg = RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (Project)this.project, (String)"JAX-WS:wsimport", Collections.singletonList("compile"));
            RunUtils.executeMaven((RunConfig)cfg);
        }
    }

    private FileObject retrieveWsdl(final String wsdlUrl, final FileObject localWsdlFolder, final boolean hasSrcFolder) {
        final FileObject[] wsdlFo = new FileObject[1];
        Runnable runnable = new Runnable(){
            final /* synthetic */ JaxWsClientCreator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    wsdlFo[0] = WSUtils.retrieveResource(localWsdlFolder, hasSrcFolder ? new URI("src/jax-ws-catalog.xml") : new URI("jax-ws-catalog.xml"), new URI(wsdlUrl));
                }
                catch (URISyntaxException ex) {
                    String mes = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_IncorrectURI", (Object)wsdlUrl);
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                }
                catch (UnknownHostException ex) {
                    String mes = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_UnknownHost", (Object)ex.getMessage());
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                }
                catch (IOException ex) {
                    String mes = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_WsdlRetrieverFailure", (Object)wsdlUrl);
                    NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                }
            }
        };
        AtomicBoolean isCancelled = new AtomicBoolean();
        ProgressUtils.runOffEventDispatchThread((Runnable)runnable, (String)NbBundle.getMessage(JaxWsClientCreator.class, (String)"LBL_RetrieveWSDL"), (AtomicBoolean)isCancelled, (boolean)false);
        if (isCancelled.get()) {
            return null;
        }
        return wsdlFo[0];
    }
}

