/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.objectstorage.model.RenameObjectDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RenameObjectRequest
extends BmcRequest<RenameObjectDetails> {
    private String namespaceName;
    private String bucketName;
    private RenameObjectDetails renameObjectDetails;
    private String opcClientRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public RenameObjectDetails getRenameObjectDetails() {
        return this.renameObjectDetails;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    @InternalSdk
    public RenameObjectDetails getBody$() {
        return this.renameObjectDetails;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).bucketName(this.bucketName).renameObjectDetails(this.renameObjectDetails).opcClientRequestId(this.opcClientRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",bucketName=").append(String.valueOf(this.bucketName));
        sb.append(",renameObjectDetails=").append(String.valueOf((Object)this.renameObjectDetails));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RenameObjectRequest)) {
            return false;
        }
        RenameObjectRequest other = (RenameObjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.bucketName, other.bucketName) && Objects.equals((Object)this.renameObjectDetails, (Object)other.renameObjectDetails) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.renameObjectDetails == null ? 43 : this.renameObjectDetails.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RenameObjectRequest, RenameObjectDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String bucketName = null;
        private RenameObjectDetails renameObjectDetails = null;
        private String opcClientRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder renameObjectDetails(RenameObjectDetails renameObjectDetails) {
            this.renameObjectDetails = renameObjectDetails;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RenameObjectRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.bucketName(o.getBucketName());
            this.renameObjectDetails(o.getRenameObjectDetails());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RenameObjectRequest build() {
            RenameObjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RenameObjectDetails body) {
            this.renameObjectDetails(body);
            return this;
        }

        public RenameObjectRequest buildWithoutInvocationCallback() {
            RenameObjectRequest request = new RenameObjectRequest();
            request.namespaceName = this.namespaceName;
            request.bucketName = this.bucketName;
            request.renameObjectDetails = this.renameObjectDetails;
            request.opcClientRequestId = this.opcClientRequestId;
            return request;
        }
    }
}

