/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MultipartUploadPartSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="etag")
    private final String etag;
    @JsonProperty(value="md5")
    private final String md5;
    @JsonProperty(value="size")
    private final Long size;
    @JsonProperty(value="partNumber")
    private final Integer partNumber;

    @Deprecated
    @ConstructorProperties(value={"etag", "md5", "size", "partNumber"})
    public MultipartUploadPartSummary(String etag, String md5, Long size, Integer partNumber) {
        this.etag = etag;
        this.md5 = md5;
        this.size = size;
        this.partNumber = partNumber;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getEtag() {
        return this.etag;
    }

    public String getMd5() {
        return this.md5;
    }

    public Long getSize() {
        return this.size;
    }

    public Integer getPartNumber() {
        return this.partNumber;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MultipartUploadPartSummary(");
        sb.append("super=").append(super.toString());
        sb.append("etag=").append(String.valueOf(this.etag));
        sb.append(", md5=").append(String.valueOf(this.md5));
        sb.append(", size=").append(String.valueOf(this.size));
        sb.append(", partNumber=").append(String.valueOf(this.partNumber));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultipartUploadPartSummary)) {
            return false;
        }
        MultipartUploadPartSummary other = (MultipartUploadPartSummary)((Object)o);
        return Objects.equals(this.etag, other.etag) && Objects.equals(this.md5, other.md5) && Objects.equals(this.size, other.size) && Objects.equals(this.partNumber, other.partNumber) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.md5 == null ? 43 : this.md5.hashCode());
        result = result * 59 + (this.size == null ? 43 : this.size.hashCode());
        result = result * 59 + (this.partNumber == null ? 43 : this.partNumber.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="etag")
        private String etag;
        @JsonProperty(value="md5")
        private String md5;
        @JsonProperty(value="size")
        private Long size;
        @JsonProperty(value="partNumber")
        private Integer partNumber;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder etag(String etag) {
            this.etag = etag;
            this.__explicitlySet__.add("etag");
            return this;
        }

        public Builder md5(String md5) {
            this.md5 = md5;
            this.__explicitlySet__.add("md5");
            return this;
        }

        public Builder size(Long size) {
            this.size = size;
            this.__explicitlySet__.add("size");
            return this;
        }

        public Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            this.__explicitlySet__.add("partNumber");
            return this;
        }

        public MultipartUploadPartSummary build() {
            MultipartUploadPartSummary model = new MultipartUploadPartSummary(this.etag, this.md5, this.size, this.partNumber);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MultipartUploadPartSummary model) {
            if (model.wasPropertyExplicitlySet("etag")) {
                this.etag(model.getEtag());
            }
            if (model.wasPropertyExplicitlySet("md5")) {
                this.md5(model.getMd5());
            }
            if (model.wasPropertyExplicitlySet("size")) {
                this.size(model.getSize());
            }
            if (model.wasPropertyExplicitlySet("partNumber")) {
                this.partNumber(model.getPartNumber());
            }
            return this;
        }
    }
}

