/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Bucket
extends ExplicitlySetBmcModel {
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="metadata")
    private final Map<String, String> metadata;
    @JsonProperty(value="createdBy")
    private final String createdBy;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="etag")
    private final String etag;
    @JsonProperty(value="publicAccessType")
    private final PublicAccessType publicAccessType;
    @JsonProperty(value="storageTier")
    private final StorageTier storageTier;
    @JsonProperty(value="objectEventsEnabled")
    private final Boolean objectEventsEnabled;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="objectLifecyclePolicyEtag")
    private final String objectLifecyclePolicyEtag;
    @JsonProperty(value="approximateCount")
    private final Long approximateCount;
    @JsonProperty(value="approximateSize")
    private final Long approximateSize;
    @JsonProperty(value="replicationEnabled")
    private final Boolean replicationEnabled;
    @JsonProperty(value="isReadOnly")
    private final Boolean isReadOnly;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="versioning")
    private final Versioning versioning;
    @JsonProperty(value="autoTiering")
    private final AutoTiering autoTiering;

    @Deprecated
    @ConstructorProperties(value={"namespace", "name", "compartmentId", "metadata", "createdBy", "timeCreated", "etag", "publicAccessType", "storageTier", "objectEventsEnabled", "freeformTags", "definedTags", "kmsKeyId", "objectLifecyclePolicyEtag", "approximateCount", "approximateSize", "replicationEnabled", "isReadOnly", "id", "versioning", "autoTiering"})
    public Bucket(String namespace, String name, String compartmentId, Map<String, String> metadata, String createdBy, Date timeCreated, String etag, PublicAccessType publicAccessType, StorageTier storageTier, Boolean objectEventsEnabled, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String kmsKeyId, String objectLifecyclePolicyEtag, Long approximateCount, Long approximateSize, Boolean replicationEnabled, Boolean isReadOnly, String id, Versioning versioning, AutoTiering autoTiering) {
        this.namespace = namespace;
        this.name = name;
        this.compartmentId = compartmentId;
        this.metadata = metadata;
        this.createdBy = createdBy;
        this.timeCreated = timeCreated;
        this.etag = etag;
        this.publicAccessType = publicAccessType;
        this.storageTier = storageTier;
        this.objectEventsEnabled = objectEventsEnabled;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.kmsKeyId = kmsKeyId;
        this.objectLifecyclePolicyEtag = objectLifecyclePolicyEtag;
        this.approximateCount = approximateCount;
        this.approximateSize = approximateSize;
        this.replicationEnabled = replicationEnabled;
        this.isReadOnly = isReadOnly;
        this.id = id;
        this.versioning = versioning;
        this.autoTiering = autoTiering;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getEtag() {
        return this.etag;
    }

    public PublicAccessType getPublicAccessType() {
        return this.publicAccessType;
    }

    public StorageTier getStorageTier() {
        return this.storageTier;
    }

    public Boolean getObjectEventsEnabled() {
        return this.objectEventsEnabled;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public String getObjectLifecyclePolicyEtag() {
        return this.objectLifecyclePolicyEtag;
    }

    public Long getApproximateCount() {
        return this.approximateCount;
    }

    public Long getApproximateSize() {
        return this.approximateSize;
    }

    public Boolean getReplicationEnabled() {
        return this.replicationEnabled;
    }

    public Boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    public String getId() {
        return this.id;
    }

    public Versioning getVersioning() {
        return this.versioning;
    }

    public AutoTiering getAutoTiering() {
        return this.autoTiering;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Bucket(");
        sb.append("super=").append(super.toString());
        sb.append("namespace=").append(String.valueOf(this.namespace));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", metadata=").append(String.valueOf(this.metadata));
        sb.append(", createdBy=").append(String.valueOf(this.createdBy));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", etag=").append(String.valueOf(this.etag));
        sb.append(", publicAccessType=").append(String.valueOf((Object)this.publicAccessType));
        sb.append(", storageTier=").append(String.valueOf((Object)this.storageTier));
        sb.append(", objectEventsEnabled=").append(String.valueOf(this.objectEventsEnabled));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", objectLifecyclePolicyEtag=").append(String.valueOf(this.objectLifecyclePolicyEtag));
        sb.append(", approximateCount=").append(String.valueOf(this.approximateCount));
        sb.append(", approximateSize=").append(String.valueOf(this.approximateSize));
        sb.append(", replicationEnabled=").append(String.valueOf(this.replicationEnabled));
        sb.append(", isReadOnly=").append(String.valueOf(this.isReadOnly));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", versioning=").append(String.valueOf((Object)this.versioning));
        sb.append(", autoTiering=").append(String.valueOf((Object)this.autoTiering));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Bucket)) {
            return false;
        }
        Bucket other = (Bucket)((Object)o);
        return Objects.equals(this.namespace, other.namespace) && Objects.equals(this.name, other.name) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.createdBy, other.createdBy) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.publicAccessType, (Object)other.publicAccessType) && Objects.equals((Object)this.storageTier, (Object)other.storageTier) && Objects.equals(this.objectEventsEnabled, other.objectEventsEnabled) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.objectLifecyclePolicyEtag, other.objectLifecyclePolicyEtag) && Objects.equals(this.approximateCount, other.approximateCount) && Objects.equals(this.approximateSize, other.approximateSize) && Objects.equals(this.replicationEnabled, other.replicationEnabled) && Objects.equals(this.isReadOnly, other.isReadOnly) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.versioning, (Object)other.versioning) && Objects.equals((Object)this.autoTiering, (Object)other.autoTiering) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.metadata == null ? 43 : this.metadata.hashCode());
        result = result * 59 + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.publicAccessType == null ? 43 : this.publicAccessType.hashCode());
        result = result * 59 + (this.storageTier == null ? 43 : this.storageTier.hashCode());
        result = result * 59 + (this.objectEventsEnabled == null ? 43 : this.objectEventsEnabled.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.objectLifecyclePolicyEtag == null ? 43 : this.objectLifecyclePolicyEtag.hashCode());
        result = result * 59 + (this.approximateCount == null ? 43 : this.approximateCount.hashCode());
        result = result * 59 + (this.approximateSize == null ? 43 : this.approximateSize.hashCode());
        result = result * 59 + (this.replicationEnabled == null ? 43 : this.replicationEnabled.hashCode());
        result = result * 59 + (this.isReadOnly == null ? 43 : this.isReadOnly.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.versioning == null ? 43 : this.versioning.hashCode());
        result = result * 59 + (this.autoTiering == null ? 43 : this.autoTiering.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AutoTiering implements BmcEnum
    {
        Disabled("Disabled"),
        InfrequentAccess("InfrequentAccess"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AutoTiering> map;

        private AutoTiering(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AutoTiering create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AutoTiering', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AutoTiering.class);
            map = new HashMap<String, AutoTiering>();
            for (AutoTiering v : AutoTiering.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Versioning implements BmcEnum
    {
        Enabled("Enabled"),
        Suspended("Suspended"),
        Disabled("Disabled"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Versioning> map;

        private Versioning(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Versioning create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Versioning', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Versioning.class);
            map = new HashMap<String, Versioning>();
            for (Versioning v : Versioning.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum StorageTier implements BmcEnum
    {
        Standard("Standard"),
        Archive("Archive"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, StorageTier> map;

        private StorageTier(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static StorageTier create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'StorageTier', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(StorageTier.class);
            map = new HashMap<String, StorageTier>();
            for (StorageTier v : StorageTier.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PublicAccessType implements BmcEnum
    {
        NoPublicAccess("NoPublicAccess"),
        ObjectRead("ObjectRead"),
        ObjectReadWithoutList("ObjectReadWithoutList"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PublicAccessType> map;

        private PublicAccessType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PublicAccessType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PublicAccessType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PublicAccessType.class);
            map = new HashMap<String, PublicAccessType>();
            for (PublicAccessType v : PublicAccessType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="metadata")
        private Map<String, String> metadata;
        @JsonProperty(value="createdBy")
        private String createdBy;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="etag")
        private String etag;
        @JsonProperty(value="publicAccessType")
        private PublicAccessType publicAccessType;
        @JsonProperty(value="storageTier")
        private StorageTier storageTier;
        @JsonProperty(value="objectEventsEnabled")
        private Boolean objectEventsEnabled;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="objectLifecyclePolicyEtag")
        private String objectLifecyclePolicyEtag;
        @JsonProperty(value="approximateCount")
        private Long approximateCount;
        @JsonProperty(value="approximateSize")
        private Long approximateSize;
        @JsonProperty(value="replicationEnabled")
        private Boolean replicationEnabled;
        @JsonProperty(value="isReadOnly")
        private Boolean isReadOnly;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="versioning")
        private Versioning versioning;
        @JsonProperty(value="autoTiering")
        private AutoTiering autoTiering;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            this.__explicitlySet__.add("metadata");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            this.__explicitlySet__.add("etag");
            return this;
        }

        public Builder publicAccessType(PublicAccessType publicAccessType) {
            this.publicAccessType = publicAccessType;
            this.__explicitlySet__.add("publicAccessType");
            return this;
        }

        public Builder storageTier(StorageTier storageTier) {
            this.storageTier = storageTier;
            this.__explicitlySet__.add("storageTier");
            return this;
        }

        public Builder objectEventsEnabled(Boolean objectEventsEnabled) {
            this.objectEventsEnabled = objectEventsEnabled;
            this.__explicitlySet__.add("objectEventsEnabled");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder objectLifecyclePolicyEtag(String objectLifecyclePolicyEtag) {
            this.objectLifecyclePolicyEtag = objectLifecyclePolicyEtag;
            this.__explicitlySet__.add("objectLifecyclePolicyEtag");
            return this;
        }

        public Builder approximateCount(Long approximateCount) {
            this.approximateCount = approximateCount;
            this.__explicitlySet__.add("approximateCount");
            return this;
        }

        public Builder approximateSize(Long approximateSize) {
            this.approximateSize = approximateSize;
            this.__explicitlySet__.add("approximateSize");
            return this;
        }

        public Builder replicationEnabled(Boolean replicationEnabled) {
            this.replicationEnabled = replicationEnabled;
            this.__explicitlySet__.add("replicationEnabled");
            return this;
        }

        public Builder isReadOnly(Boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
            this.__explicitlySet__.add("isReadOnly");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder versioning(Versioning versioning) {
            this.versioning = versioning;
            this.__explicitlySet__.add("versioning");
            return this;
        }

        public Builder autoTiering(AutoTiering autoTiering) {
            this.autoTiering = autoTiering;
            this.__explicitlySet__.add("autoTiering");
            return this;
        }

        public Bucket build() {
            Bucket model = new Bucket(this.namespace, this.name, this.compartmentId, this.metadata, this.createdBy, this.timeCreated, this.etag, this.publicAccessType, this.storageTier, this.objectEventsEnabled, this.freeformTags, this.definedTags, this.kmsKeyId, this.objectLifecyclePolicyEtag, this.approximateCount, this.approximateSize, this.replicationEnabled, this.isReadOnly, this.id, this.versioning, this.autoTiering);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Bucket model) {
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("metadata")) {
                this.metadata(model.getMetadata());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("etag")) {
                this.etag(model.getEtag());
            }
            if (model.wasPropertyExplicitlySet("publicAccessType")) {
                this.publicAccessType(model.getPublicAccessType());
            }
            if (model.wasPropertyExplicitlySet("storageTier")) {
                this.storageTier(model.getStorageTier());
            }
            if (model.wasPropertyExplicitlySet("objectEventsEnabled")) {
                this.objectEventsEnabled(model.getObjectEventsEnabled());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("objectLifecyclePolicyEtag")) {
                this.objectLifecyclePolicyEtag(model.getObjectLifecyclePolicyEtag());
            }
            if (model.wasPropertyExplicitlySet("approximateCount")) {
                this.approximateCount(model.getApproximateCount());
            }
            if (model.wasPropertyExplicitlySet("approximateSize")) {
                this.approximateSize(model.getApproximateSize());
            }
            if (model.wasPropertyExplicitlySet("replicationEnabled")) {
                this.replicationEnabled(model.getReplicationEnabled());
            }
            if (model.wasPropertyExplicitlySet("isReadOnly")) {
                this.isReadOnly(model.getIsReadOnly());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("versioning")) {
                this.versioning(model.getVersioning());
            }
            if (model.wasPropertyExplicitlySet("autoTiering")) {
                this.autoTiering(model.getAutoTiering());
            }
            return this;
        }
    }
}

