/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring;

import com.oracle.bmc.monitoring.Monitoring;
import com.oracle.bmc.monitoring.model.AlarmStatusSummary;
import com.oracle.bmc.monitoring.model.AlarmSummary;
import com.oracle.bmc.monitoring.model.Metric;
import com.oracle.bmc.monitoring.requests.ListAlarmsRequest;
import com.oracle.bmc.monitoring.requests.ListAlarmsStatusRequest;
import com.oracle.bmc.monitoring.requests.ListMetricsRequest;
import com.oracle.bmc.monitoring.responses.ListAlarmsResponse;
import com.oracle.bmc.monitoring.responses.ListAlarmsStatusResponse;
import com.oracle.bmc.monitoring.responses.ListMetricsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class MonitoringPaginators {
    private final Monitoring client;

    public MonitoringPaginators(Monitoring client) {
        this.client = client;
    }

    public Iterable<ListAlarmsResponse> listAlarmsResponseIterator(final ListAlarmsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAlarmsRequest.Builder>(){

            @Override
            public ListAlarmsRequest.Builder get() {
                return ListAlarmsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAlarmsResponse, String>(){

            @Override
            public String apply(ListAlarmsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAlarmsRequest.Builder>, ListAlarmsRequest>(){

            @Override
            public ListAlarmsRequest apply(RequestBuilderAndToken<ListAlarmsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAlarmsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAlarmsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAlarmsRequest, ListAlarmsResponse>(){

            @Override
            public ListAlarmsResponse apply(ListAlarmsRequest request) {
                return MonitoringPaginators.this.client.listAlarms(request);
            }
        });
    }

    public Iterable<AlarmSummary> listAlarmsRecordIterator(final ListAlarmsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAlarmsRequest.Builder>(){

            @Override
            public ListAlarmsRequest.Builder get() {
                return ListAlarmsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAlarmsResponse, String>(){

            @Override
            public String apply(ListAlarmsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAlarmsRequest.Builder>, ListAlarmsRequest>(){

            @Override
            public ListAlarmsRequest apply(RequestBuilderAndToken<ListAlarmsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAlarmsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAlarmsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAlarmsRequest, ListAlarmsResponse>(){

            @Override
            public ListAlarmsResponse apply(ListAlarmsRequest request) {
                return MonitoringPaginators.this.client.listAlarms(request);
            }
        }, (Function)new Function<ListAlarmsResponse, List<AlarmSummary>>(){

            @Override
            public List<AlarmSummary> apply(ListAlarmsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAlarmsStatusResponse> listAlarmsStatusResponseIterator(final ListAlarmsStatusRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAlarmsStatusRequest.Builder>(){

            @Override
            public ListAlarmsStatusRequest.Builder get() {
                return ListAlarmsStatusRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAlarmsStatusResponse, String>(){

            @Override
            public String apply(ListAlarmsStatusResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAlarmsStatusRequest.Builder>, ListAlarmsStatusRequest>(){

            @Override
            public ListAlarmsStatusRequest apply(RequestBuilderAndToken<ListAlarmsStatusRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAlarmsStatusRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAlarmsStatusRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAlarmsStatusRequest, ListAlarmsStatusResponse>(){

            @Override
            public ListAlarmsStatusResponse apply(ListAlarmsStatusRequest request) {
                return MonitoringPaginators.this.client.listAlarmsStatus(request);
            }
        });
    }

    public Iterable<AlarmStatusSummary> listAlarmsStatusRecordIterator(final ListAlarmsStatusRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAlarmsStatusRequest.Builder>(){

            @Override
            public ListAlarmsStatusRequest.Builder get() {
                return ListAlarmsStatusRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAlarmsStatusResponse, String>(){

            @Override
            public String apply(ListAlarmsStatusResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAlarmsStatusRequest.Builder>, ListAlarmsStatusRequest>(){

            @Override
            public ListAlarmsStatusRequest apply(RequestBuilderAndToken<ListAlarmsStatusRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAlarmsStatusRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAlarmsStatusRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAlarmsStatusRequest, ListAlarmsStatusResponse>(){

            @Override
            public ListAlarmsStatusResponse apply(ListAlarmsStatusRequest request) {
                return MonitoringPaginators.this.client.listAlarmsStatus(request);
            }
        }, (Function)new Function<ListAlarmsStatusResponse, List<AlarmStatusSummary>>(){

            @Override
            public List<AlarmStatusSummary> apply(ListAlarmsStatusResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListMetricsResponse> listMetricsResponseIterator(final ListMetricsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMetricsRequest.Builder>(){

            @Override
            public ListMetricsRequest.Builder get() {
                return ListMetricsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMetricsResponse, String>(){

            @Override
            public String apply(ListMetricsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMetricsRequest.Builder>, ListMetricsRequest>(){

            @Override
            public ListMetricsRequest apply(RequestBuilderAndToken<ListMetricsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMetricsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMetricsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMetricsRequest, ListMetricsResponse>(){

            @Override
            public ListMetricsResponse apply(ListMetricsRequest request) {
                return MonitoringPaginators.this.client.listMetrics(request);
            }
        });
    }

    public Iterable<Metric> listMetricsRecordIterator(final ListMetricsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMetricsRequest.Builder>(){

            @Override
            public ListMetricsRequest.Builder get() {
                return ListMetricsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMetricsResponse, String>(){

            @Override
            public String apply(ListMetricsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMetricsRequest.Builder>, ListMetricsRequest>(){

            @Override
            public ListMetricsRequest apply(RequestBuilderAndToken<ListMetricsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListMetricsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMetricsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListMetricsRequest, ListMetricsResponse>(){

            @Override
            public ListMetricsResponse apply(ListMetricsRequest request) {
                return MonitoringPaginators.this.client.listMetrics(request);
            }
        }, (Function)new Function<ListMetricsResponse, List<Metric>>(){

            @Override
            public List<Metric> apply(ListMetricsResponse response) {
                return response.getItems();
            }
        });
    }
}

