/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Set;
import javax.swing.AbstractAction;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.core.MethodGenerator;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ProjectService;
import org.netbeans.modules.websvc.design.view.actions.AddOperationAction;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class RemoveOperationAction
extends AbstractAction {
    private Set<MethodModel> methods;
    private ProjectService service;

    public RemoveOperationAction(ProjectService service) {
        super(RemoveOperationAction.getName());
        this.putValue("ShortDescription", NbBundle.getMessage(RemoveOperationAction.class, (String)"Hint_RemoveOperation"));
        this.putValue("MnemonicKey", Integer.valueOf(NbBundle.getMessage(AddOperationAction.class, (String)"LBL_RemoveOperation_mnem_pos")));
        this.service = service;
        this.setEnabled(false);
    }

    public void setWorkingSet(Set<MethodModel> methods) {
        this.methods = methods;
        this.setEnabled(this.service.getWsdlUrl() == null && methods != null && !methods.isEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.methods.size() < 1) {
            return;
        }
        boolean singleSelection = this.methods.size() == 1;
        String methodName = singleSelection ? this.methods.iterator().next().getOperationName() : "" + this.methods.size();
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RemoveOperationAction.class, (String)(singleSelection ? "MSG_OPERATION_DELETE" : "MSG_OPERATIONS_DELETE"), (Object)methodName));
        Object retVal = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (retVal == NotifyDescriptor.YES_OPTION) {
            final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RemoveOperationAction.class, (String)(singleSelection ? "MSG_RemoveOperation" : "MSG_RemoveOperations"), (Object)methodName));
            Task task = new Task(new Runnable(){
                final /* synthetic */ RemoveOperationAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    handle.start();
                    try {
                        this.this$0.removeOperation(this.this$0.methods);
                    }
                    catch (IOException e) {
                        handle.finish();
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    finally {
                        handle.finish();
                    }
                }
            });
            RequestProcessor.getDefault().post((Runnable)task);
        }
    }

    private void removeOperation(Set<MethodModel> methods) throws IOException {
        for (MethodModel method : methods) {
            SaveCookie cookie;
            String methodName = method.getOperationName();
            FileObject implementationClass = this.getImplementationClass(method);
            MethodGenerator.deleteMethod((FileObject)implementationClass, (String)methodName);
            DataObject dobj = DataObject.find((FileObject)implementationClass);
            if (!dobj.isModified() || (cookie = (SaveCookie)dobj.getCookie(SaveCookie.class)) == null) continue;
            cookie.save();
        }
    }

    private static String getName() {
        return NbBundle.getMessage(RemoveOperationAction.class, (String)"LBL_RemoveOperation");
    }

    private FileObject getImplementationClass(MethodModel method) {
        FileObject implementationClass = null;
        FileObject classFO = method.getImplementationClass();
        String implClassName = this.service.getImplementationClass();
        if (this.service.getLocalWsdlFile() != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)classFO);
            SourceGroup[] sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            if (sgs.length > 0) {
                ClassPath classPath = null;
                for (int i = 0; i < sgs.length && ((classPath = ClassPath.getClassPath((FileObject)sgs[i].getRootFolder(), (String)"classpath/source")) == null || (implementationClass = classPath.findResource(implClassName.replace('.', '/') + ".java")) == null); ++i) {
                }
            }
        } else {
            implementationClass = classFO;
        }
        return implementationClass;
    }
}

