/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.commons.treelist;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;
import org.netbeans.modules.team.commons.treelist.LinkButton;

abstract class AbstractListUI
extends BasicListUI {
    AbstractListUI() {
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        final MouseInputListener orig = super.createMouseInputListener();
        return new MouseInputListener(){
            final /* synthetic */ AbstractListUI this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!this.this$0.redispatchComponent(e)) {
                    orig.mouseClicked(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!this.this$0.redispatchComponent(e)) {
                    if (this.this$0.showPopup(e)) {
                        return;
                    }
                    orig.mousePressed(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!this.this$0.redispatchComponent(e)) {
                    if (this.this$0.showPopup(e)) {
                        return;
                    }
                    orig.mouseReleased(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!this.this$0.redispatchComponent(e)) {
                    orig.mouseEntered(e);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!this.this$0.redispatchComponent(e)) {
                    orig.mouseExited(e);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!this.this$0.redispatchComponent(e)) {
                    orig.mouseDragged(e);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!this.this$0.redispatchComponent(e)) {
                    this.this$0.list.setCursor(Cursor.getDefaultCursor());
                    orig.mouseMoved(e);
                } else {
                    this.this$0.list.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        };
    }

    private boolean redispatchComponent(MouseEvent e) {
        Point p = e.getPoint();
        int index = this.list.locationToIndex(p);
        if (index < 0 || index >= this.list.getModel().getSize()) {
            return false;
        }
        ListCellRenderer renderer = this.list.getCellRenderer();
        if (null == renderer) {
            return false;
        }
        Component renComponent = renderer.getListCellRendererComponent(this.list, this.list.getModel().getElementAt(index), index, false, false);
        if (null == renComponent) {
            return false;
        }
        Rectangle rect = this.list.getCellBounds(index, index);
        if (null == rect) {
            return false;
        }
        renComponent.setBounds(0, 0, rect.width, rect.height);
        renComponent.doLayout();
        Point p3 = rect.getLocation();
        Point p2 = new Point(p.x - p3.x, p.y - p3.y);
        Component dispatchComponent = SwingUtilities.getDeepestComponentAt(renComponent, p2.x, p2.y);
        if (e.isPopupTrigger() && dispatchComponent instanceof LinkButton && !((LinkButton)dispatchComponent).isHandlingPopupEvents()) {
            return false;
        }
        if (dispatchComponent instanceof AbstractButton) {
            if (!((AbstractButton)dispatchComponent).isEnabled()) {
                return false;
            }
            Point p4 = SwingUtilities.convertPoint(renComponent, p2, dispatchComponent);
            MouseEvent newEvent = new MouseEvent(dispatchComponent, e.getID(), e.getWhen(), e.getModifiers(), p4.x, p4.y, e.getClickCount(), e.isPopupTrigger(), 0);
            dispatchComponent.dispatchEvent(newEvent);
            this.list.repaint(rect);
            e.consume();
            return true;
        }
        return false;
    }

    private boolean showPopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return false;
        }
        int index = this.list.locationToIndex(e.getPoint());
        Rectangle rect = this.list.getCellBounds(index, index);
        if (!rect.contains(e.getPoint())) {
            return false;
        }
        return this.showPopupAt(index, e.getPoint());
    }

    abstract boolean showPopupAt(int var1, Point var2);
}

