/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.code.DeferredCompletionFailureHandler;
import com.sun.tools.javac.util.Context;
import java.util.Arrays;
import java.util.Collection;

public class MultiTaskListener
implements TaskListener {
    public static final Context.Key<MultiTaskListener> taskListenerKey = new Context.Key();
    private static final TaskListener[] EMPTY_LISTENERS = new TaskListener[0];
    private final DeferredCompletionFailureHandler dcfh;
    TaskListener[] listeners = EMPTY_LISTENERS;
    ClientCodeWrapper ccw;

    public static MultiTaskListener instance(Context context) {
        MultiTaskListener instance = context.get(taskListenerKey);
        if (instance == null) {
            instance = new MultiTaskListener(context);
        }
        return instance;
    }

    protected MultiTaskListener(Context context) {
        context.put(taskListenerKey, this);
        this.ccw = ClientCodeWrapper.instance(context);
        this.dcfh = DeferredCompletionFailureHandler.instance(context);
    }

    public Collection<TaskListener> getTaskListeners() {
        return Arrays.asList(this.listeners);
    }

    public boolean isEmpty() {
        return this.listeners == EMPTY_LISTENERS;
    }

    public void add(TaskListener listener) {
        for (TaskListener l : this.listeners) {
            if (this.ccw.unwrap(l) != listener) continue;
            throw new IllegalStateException();
        }
        this.listeners = Arrays.copyOf(this.listeners, this.listeners.length + 1);
        this.listeners[this.listeners.length - 1] = this.ccw.wrap(listener);
    }

    public void remove(TaskListener listener) {
        for (int i = 0; i < this.listeners.length; ++i) {
            if (this.ccw.unwrap(this.listeners[i]) != listener) continue;
            if (this.listeners.length == 1) {
                this.listeners = EMPTY_LISTENERS;
                break;
            }
            TaskListener[] newListeners = new TaskListener[this.listeners.length - 1];
            System.arraycopy(this.listeners, 0, newListeners, 0, i);
            System.arraycopy(this.listeners, i + 1, newListeners, i, newListeners.length - i);
            this.listeners = newListeners;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void started(TaskEvent e) {
        DeferredCompletionFailureHandler.Handler prevDeferredHandler = this.dcfh.setHandler(this.dcfh.userCodeHandler);
        try {
            TaskListener[] ll;
            for (TaskListener l : ll = this.listeners) {
                l.started(e);
            }
        }
        finally {
            this.dcfh.setHandler(prevDeferredHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(TaskEvent e) {
        DeferredCompletionFailureHandler.Handler prevDeferredHandler = this.dcfh.setHandler(this.dcfh.userCodeHandler);
        try {
            TaskListener[] ll;
            for (TaskListener l : ll = this.listeners) {
                l.finished(e);
            }
        }
        finally {
            this.dcfh.setHandler(prevDeferredHandler);
        }
    }

    public String toString() {
        return Arrays.toString(this.listeners);
    }

    public void clear() {
        this.listeners = EMPTY_LISTENERS;
    }
}

