/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.gulp;

import java.awt.EventQueue;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.gulp.GulpBuildTool;
import org.netbeans.modules.javascript.gulp.exec.GulpExecutable;
import org.netbeans.modules.javascript.gulp.file.GulpTasks;
import org.netbeans.modules.javascript.gulp.util.GulpUtils;
import org.netbeans.modules.web.clientproject.api.build.BuildTools;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class GulpBuildToolSupport
implements BuildTools.BuildToolSupport {
    protected final Project project;
    @NullAllowed
    protected final FileObject gulpfile;
    protected final GulpTasks gulpTasks;

    public GulpBuildToolSupport(Project project, @NullAllowed FileObject gulpfile) {
        assert (project != null);
        this.project = project;
        this.gulpfile = gulpfile;
        this.gulpTasks = GulpBuildTool.forProject(project).getGulpTasks(gulpfile);
    }

    public Project getProject() {
        return this.project;
    }

    public FileObject getWorkDir() {
        if (this.gulpfile == null) {
            return this.project.getProjectDirectory();
        }
        return this.gulpfile.getParent();
    }

    public String getIdentifier() {
        return "Gulp";
    }

    public String getBuildToolExecName() {
        return GulpExecutable.GULP_NAME;
    }

    public Future<List<String>> getTasks() {
        return new TasksFuture(this.gulpTasks);
    }

    public void runTask(String ... args) {
        assert (!EventQueue.isDispatchThread());
        GulpExecutable gulp = this.getGulpExecutable();
        if (gulp != null) {
            GulpUtils.logUsageGulpBuild();
            gulp.run(args);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.gulpTasks.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.gulpTasks.removeChangeListener(listener);
    }

    @CheckForNull
    private GulpExecutable getGulpExecutable() {
        if (this.gulpfile == null) {
            return GulpExecutable.getDefault(this.project, true);
        }
        return GulpExecutable.getDefault(this.project, FileUtil.toFile((FileObject)this.gulpfile).getParentFile(), true);
    }

    private static final class TasksFuture
    implements Future<List<String>> {
        private final GulpTasks gulpTasks;

        public TasksFuture(GulpTasks gulpTasks) {
            assert (gulpTasks != null);
            this.gulpTasks = gulpTasks;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.gulpTasks.getTasks() != null;
        }

        @Override
        public List<String> get() throws InterruptedException, ExecutionException {
            try {
                return this.gulpTasks.loadTasks(null, null);
            }
            catch (TimeoutException ex) {
                assert (false);
                return null;
            }
        }

        @Override
        public List<String> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.gulpTasks.loadTasks(timeout, unit);
        }
    }
}

