/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.project.ui.JavaProjectSettings;
import org.netbeans.modules.java.project.ui.PackageDisplayUtils;
import org.netbeans.spi.java.project.support.ui.Bundle;
import org.netbeans.spi.java.project.support.ui.PackageRootNode;
import org.netbeans.spi.java.project.support.ui.PackageViewChildren;
import org.netbeans.spi.java.project.support.ui.TreeRootNode;
import org.netbeans.spi.project.ui.PathFinder;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public class PackageView {
    private static final Logger LOG = Logger.getLogger(PackageView.class.getName());

    private PackageView() {
    }

    public static Node createPackageView(SourceGroup group) {
        return new RootNode(group);
    }

    public static Node findPath(Node rootNode, Object object) {
        PathFinder pf = (PathFinder)rootNode.getLookup().lookup(PathFinder.class);
        if (pf != null) {
            return pf.findPath(rootNode, object);
        }
        return null;
    }

    public static ComboBoxModel createListView(SourceGroup group) {
        Parameters.notNull((CharSequence)"group", (Object)group);
        TreeSet<PackageItem> data = new TreeSet<PackageItem>();
        PackageView.findNonExcludedPackages(null, data, group.getRootFolder(), group, false);
        return new DefaultComboBoxModel<PackageItem>(data.toArray(new PackageItem[0]));
    }

    @NonNull
    static Action[] createRootNodeActions() {
        return new Action[]{CommonProjectActions.newFileAction(), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(ToolsAction.class)};
    }

    static void findNonExcludedPackages(PackageViewChildren children, Collection<PackageItem> target, FileObject fo, SourceGroup group, boolean showProgress) {
        if (showProgress) {
            ProgressHandle progress = ProgressHandleFactory.createHandle((String)Bundle.PackageView_find_packages_progress(FileUtil.getFileDisplayName((FileObject)fo)));
            progress.start(1000);
            PackageView.findNonExcludedPackages(children, target, fo, group, progress, 0, 1000);
            progress.finish();
        } else {
            PackageView.findNonExcludedPackages(children, target, fo, group, null, 0, 0);
        }
    }

    private static void findNonExcludedPackages(PackageViewChildren children, Collection<PackageItem> target, FileObject fo, SourceGroup group, ProgressHandle progress, int start, int end) {
        if (!fo.isValid() || fo.isVirtual()) {
            return;
        }
        if (!fo.isFolder()) {
            throw new IllegalArgumentException("Package view only accepts folders, given: " + FileUtil.getFileDisplayName((FileObject)fo));
        }
        if (progress != null) {
            String path = FileUtil.getRelativePath((FileObject)children.getRoot(), (FileObject)fo);
            if (path == null) {
                if (!fo.isValid() || !children.getRoot().isValid()) {
                    return;
                }
                throw new IllegalArgumentException(MessageFormat.format("{0} in {1}", FileUtil.getFileDisplayName((FileObject)fo), FileUtil.getFileDisplayName((FileObject)children.getRoot())));
            }
            progress.progress(path.replace('/', '.'), start);
        }
        if (!VisibilityQuery.getDefault().isVisible(fo)) {
            return;
        }
        boolean hasSubfolders = false;
        boolean hasFiles = false;
        ArrayList<FileObject> folders = new ArrayList<FileObject>();
        for (FileObject kid : fo.getChildren()) {
            if (!kid.isValid() || !VisibilityQuery.getDefault().isVisible(kid) || !group.contains(kid)) continue;
            if (kid.isFolder()) {
                folders.add(kid);
                hasSubfolders = true;
                continue;
            }
            hasFiles = true;
        }
        if (hasFiles || !hasSubfolders) {
            if (target != null) {
                target.add(new PackageItem(group, fo, !hasFiles));
            } else if (fo.isValid()) {
                children.add(fo, !hasFiles, false);
            }
        }
        if (!folders.isEmpty()) {
            int diff = (end - start) / folders.size();
            int c = 0;
            for (FileObject kid : folders) {
                PackageView.findNonExcludedPackages(children, target, kid, group, progress, start + c * diff, start + (c + 1) * diff);
                ++c;
            }
        }
    }

    public static ListCellRenderer listRenderer() {
        return new PackageListCellRenderer();
    }

    @SuppressWarnings(value={"DE_MIGHT_IGNORE"})
    private static final class RootNode
    extends FilterNode
    implements PropertyChangeListener {
        private SourceGroup sourceGroup;
        private static boolean IN_UNIT_TEST = Boolean.getBoolean("PackageView.unitTest");

        private RootNode(SourceGroup group) {
            super(RootNode.getOriginalNode(group));
            this.sourceGroup = group;
            JavaProjectSettings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, JavaProjectSettings.class));
            group.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group));
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String prop = event.getPropertyName();
            if ("packageViewType".equals(prop) || "containership".equals(prop)) {
                if (IN_UNIT_TEST) {
                    this.changeOriginal(RootNode.getOriginalNode(this.sourceGroup), true);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.changeOriginal(RootNode.getOriginalNode(sourceGroup), true);
                        }
                    });
                }
            }
        }

        private static Node getOriginalNode(SourceGroup group) {
            FileObject root = group.getRootFolder();
            if (root == null || !root.isValid()) {
                return new AbstractNode(FilterNode.Children.LEAF);
            }
            if (!VisibilityQuery.getDefault().isVisible(root)) {
                LOG.log(Level.WARNING, "Ignoring source group: {0} with non visible root: {1}", new Object[]{group, FileUtil.getFileDisplayName((FileObject)root)});
                return new AbstractNode(FilterNode.Children.LEAF);
            }
            try {
                switch (JavaProjectSettings.getPackageViewType()) {
                    case PACKAGES: {
                        return new PackageRootNode(group);
                    }
                    case TREE: {
                        return new TreeRootNode(group, false);
                    }
                    case REDUCED_TREE: {
                        return new TreeRootNode(group, true);
                    }
                }
                assert (false) : "Unknown PackageView Type";
                return new PackageRootNode(group);
            }
            catch (IllegalArgumentException iae) {
                if (iae.getCause() instanceof DataObjectNotFoundException) {
                    LOG.log(Level.WARNING, "The root: {0} does not exist.", FileUtil.getFileDisplayName((FileObject)root));
                    return new AbstractNode(FilterNode.Children.LEAF);
                }
                throw iae;
            }
        }
    }

    static final class PackageItem
    implements Comparable<PackageItem> {
        private static Map<Image, Icon> image2icon = new IdentityHashMap<Image, Icon>();
        private final boolean empty;
        private final FileObject pkg;
        private final String pkgname;
        private Icon icon;

        public PackageItem(SourceGroup group, FileObject pkg, boolean empty) {
            this.pkg = pkg;
            this.empty = empty;
            String path = FileUtil.getRelativePath((FileObject)group.getRootFolder(), (FileObject)pkg);
            assert (path != null) : "No " + pkg + " in " + group;
            this.pkgname = path.replace('/', '.');
        }

        public String toString() {
            return this.pkgname;
        }

        public String getLabel() {
            return PackageDisplayUtils.getDisplayLabel(this.pkgname);
        }

        public Icon getIcon() {
            if (this.icon == null) {
                Image image = PackageDisplayUtils.getIcon(this.pkg, this.empty);
                this.icon = image2icon.get(image);
                if (this.icon == null) {
                    this.icon = ImageUtilities.image2Icon((Image)image);
                    image2icon.put(image, this.icon);
                }
            }
            return this.icon;
        }

        @Override
        public int compareTo(PackageItem p) {
            return this.pkgname.compareTo(p.pkgname);
        }
    }

    private static final class PackageListCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public PackageListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value instanceof PackageItem) {
                PackageItem pkgitem = (PackageItem)value;
                this.setText(pkgitem.getLabel());
                this.setIcon(pkgitem.getIcon());
            } else {
                String pkgitem = (String)value;
                this.setText(pkgitem);
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

