/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.json;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript2.json.MergedResult;
import org.netbeans.modules.javascript2.json.spi.JsonOptionsQueryImplementation;
import org.netbeans.modules.javascript2.json.spi.support.JsonPreferences;
import org.openide.filesystems.FileObject;

public final class ProjectJsonOptionsQueryImpl
implements JsonOptionsQueryImplementation {
    private final Map<Project, Reference<JsonOptionsQueryImplementation.Result>> normCache = new WeakHashMap<Project, Reference<JsonOptionsQueryImplementation.Result>>();

    @Override
    @CheckForNull
    public JsonOptionsQueryImplementation.Result getOptions(@NonNull FileObject file) {
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        if (p == null) {
            return null;
        }
        JsonOptionsQueryImplementation impl = (JsonOptionsQueryImplementation)p.getLookup().lookup(JsonOptionsQueryImplementation.class);
        JsonOptionsQueryImplementation.Result overrideRes = impl == null ? null : impl.getOptions(file);
        JsonOptionsQueryImplementation.Result defaultRes = this.createDefaultResult(p);
        return overrideRes == null ? defaultRes : new MergedResult(overrideRes, defaultRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonOptionsQueryImplementation.Result createDefaultResult(@NonNull Project p) {
        Map<Project, Reference<JsonOptionsQueryImplementation.Result>> map = this.normCache;
        synchronized (map) {
            JsonOptionsQueryImplementation.Result res;
            Reference<JsonOptionsQueryImplementation.Result> ref = this.normCache.get(p);
            JsonOptionsQueryImplementation.Result result = res = ref == null ? null : ref.get();
            if (res == null) {
                res = new DefaultProjectResult(p);
                this.normCache.put(p, new WeakReference<JsonOptionsQueryImplementation.Result>(res));
            }
            return res;
        }
    }

    private static final class DefaultProjectResult
    implements JsonOptionsQueryImplementation.Result,
    PropertyChangeListener {
        private final JsonPreferences jsonPrefs;
        private final PropertyChangeSupport listeners;
        private final AtomicBoolean listens = new AtomicBoolean();

        DefaultProjectResult(@NonNull Project project) {
            this.jsonPrefs = JsonPreferences.forProject(project);
            this.listeners = new PropertyChangeSupport(this);
        }

        @Override
        @CheckForNull
        public Boolean isCommentSupported() {
            return this.jsonPrefs.isCommentSupported() ? Boolean.TRUE : null;
        }

        @Override
        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            if (!this.listens.get() && this.listens.compareAndSet(false, true)) {
                this.jsonPrefs.addPropertyChangeListener(this);
            }
            this.listeners.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            this.listeners.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.listeners.firePropertyChange("commentSupported", null, null);
        }
    }
}

