/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.json;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.javascript2.json.spi.JsonOptionsQueryImplementation;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

final class MergedResult
implements JsonOptionsQueryImplementation.Result,
PropertyChangeListener {
    private final JsonOptionsQueryImplementation.Result[] delegates;
    private final PropertyChangeSupport listeners;

    MergedResult(JsonOptionsQueryImplementation.Result ... delegates) {
        Parameters.notNull((CharSequence)"delegates", (Object)delegates);
        this.delegates = Arrays.copyOf(delegates, delegates.length);
        this.listeners = new PropertyChangeSupport(this);
        Arrays.stream(this.delegates).forEach(r -> r.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)r)));
    }

    @Override
    @CheckForNull
    public Boolean isCommentSupported() {
        for (JsonOptionsQueryImplementation.Result delegate : this.delegates) {
            Boolean res = delegate.isCommentSupported();
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Override
    public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(@NonNull PropertyChangeEvent evt) {
        this.listeners.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }
}

