/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.ChangeFirer;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.FixedModule;
import org.netbeans.IllegalModuleException;
import org.netbeans.InvalidException;
import org.netbeans.JarClassLoader;
import org.netbeans.MainImpl;
import org.netbeans.Module;
import org.netbeans.ModuleFactory;
import org.netbeans.ModuleInstaller;
import org.netbeans.NbExit;
import org.netbeans.NbInstrumentation;
import org.netbeans.NetigsoFramework;
import org.netbeans.NetigsoHandle;
import org.netbeans.NetigsoLoader;
import org.netbeans.NetigsoModule;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Stamps;
import org.netbeans.TaskFuture;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.openide.modules.Places;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TopologicalSortException;
import org.openide.util.Union2;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class ModuleManager
extends Modules {
    private static final Logger DEPLOG = Logger.getLogger(ModuleManager.class.getName() + ".deps");
    public static final String PROP_MODULES = "modules";
    public static final String PROP_ENABLED_MODULES = "enabledModules";
    public static final String PROP_CLASS_LOADER = "classLoader";
    static boolean PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES = !Boolean.getBoolean("suppress.topological.exception");
    private final Set<Module> modules = new HashSet<Module>(100);
    private final Map<String, Module> modulesByName = new HashMap<String, Module>(100);
    private final Map<ClassLoader, Collection<Reference<Module>>> bootstrapModules = new WeakHashMap<ClassLoader, Collection<Reference<Module>>>();
    private final Map<String, Collection<Module>> fragmentModules = new HashMap<String, Collection<Module>>(5);
    private final Object MODULE_PROBLEMS_LOCK = new Object();
    private final Map<Module, Set<Union2<Dependency, InvalidException>>> moduleProblemsWithoutNeeds = new HashMap<Module, Set<Union2<Dependency, InvalidException>>>(100);
    private final Map<Module, Set<Union2<Dependency, InvalidException>>> moduleProblemsWithNeeds = new HashMap<Module, Set<Union2<Dependency, InvalidException>>>(100);
    private static final Set<Union2<Dependency, InvalidException>> EMPTY_COLLECTION = Collections.emptySet();
    private final ProvidersOf providersOf = new ProvidersOf();
    private final Set<String> environmentTokens = new HashSet<String>();
    private final ModuleInstaller installer;
    private ModuleFactory moduleFactory;
    private SystemClassLoader classLoader;
    private List<File> classLoaderPatches;
    private final Object classLoaderLock = new String("ModuleManager.classLoaderLock");
    private final Events ev;
    private final ModuleDataCache mdc = new ModuleDataCache();
    private final NetigsoHandle netigso;
    private final Mutex.Privileged MUTEX_PRIVILEGED = new Mutex.Privileged();
    private final Mutex MUTEX = new Mutex(this.MUTEX_PRIVILEGED);
    private ChangeFirer firer = new ChangeFirer(this);
    private boolean readOnly = false;
    private PropertyChangeSupport changeSupport;
    private final Util.ModuleLookup lookup = new Util.ModuleLookup();
    private final Lookup completeLookup = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{this}), this.lookup});
    private final ThreadLocal<EnableContext> enableContext = new ThreadLocal();
    private Module addedBecauseOfDependent;
    private boolean eagerActivation;
    private Set<Module> reported = new HashSet<Module>();
    private Set<Module> reportedProblems = new HashSet<Module>();
    private static final Union2<Dependency, InvalidException> PROBING_IN_PROCESS = Union2.createSecond((Object)new InvalidException("PROBING_IN_PROCESS"));

    public ModuleManager(ModuleInstaller installer, Events ev) {
        this.installer = installer;
        this.ev = ev;
        this.netigso = new NetigsoHandle(this);
        String patches = System.getProperty("netbeans.systemclassloader.patches");
        if (patches != null) {
            System.err.println("System class loader patches: " + patches);
            this.classLoaderPatches = new ArrayList<File>();
            StringTokenizer tok = new StringTokenizer(patches, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                this.classLoaderPatches.add(new File(tok.nextToken()));
            }
        } else {
            this.classLoaderPatches = Collections.emptyList();
        }
        this.classLoader = new SystemClassLoader(this.classLoaderPatches, new ClassLoader[]{installer.getClass().getClassLoader()}, Collections.emptySet());
        ModuleManager.updateContextClassLoaders(this.classLoader, true);
        this.moduleFactory = (ModuleFactory)Lookup.getDefault().lookup(ModuleFactory.class);
        if (this.moduleFactory == null) {
            this.moduleFactory = new ModuleFactory();
        } else {
            this.classLoader.setSystemClassLoader(this.moduleFactory.getClasspathDelegateClassLoader(this, ModuleManager.class.getClassLoader()));
        }
        this.initializeEnvTokens();
    }

    private void initializeEnvTokens() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.environmentTokens.add("netbeans:gui.swing");
        }
    }

    public final Events getEvents() {
        return this.ev;
    }

    public final Mutex mutex() {
        return this.MUTEX;
    }

    public final Mutex.Privileged mutexPrivileged() {
        return this.MUTEX_PRIVILEGED;
    }

    public void releaseModuleManifests() {
        for (Module m : this.modules) {
            m.releaseManifest();
        }
    }

    void readOnly(boolean ro) {
        this.readOnly = ro;
    }

    void assertWritable() throws IllegalThreadStateException {
        if (this.readOnly) {
            throw new IllegalThreadStateException("You are attempting to make changes to " + String.valueOf((Object)this) + " in a property change callback. This is illegal. You may only make module system changes while holding a write mutex and not inside a change callback. See #16328.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        ModuleManager moduleManager = this;
        synchronized (moduleManager) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport((Object)this);
            }
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }

    final void firePropertyChange(String prop, Object old, Object nue) {
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("ModuleManager.propertyChange: " + prop + ": " + String.valueOf(old) + " -> " + String.valueOf(nue));
        }
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(prop, old, nue);
        }
    }

    final void fireReloadable(Module m) {
        this.firer.change(new ChangeFirer.Change((Object)m, "reloadable", null, null));
        this.firer.fire();
    }

    public Lookup getModuleLookup() {
        return this.completeLookup;
    }

    final void fireModulesCreatedDeleted(Set<Module> created, Set<Module> deleted) {
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("lookup created: " + String.valueOf(created) + " deleted: " + String.valueOf(deleted));
        }
        this.lookup.changed();
    }

    public Set<Module> getModules() {
        return new HashSet<Module>(this.modules);
    }

    final int getModuleCount() {
        return this.modules.size();
    }

    public final Set<Module> getEnabledModules() {
        HashSet<Module> s = new HashSet<Module>(this.modules);
        Iterator it = s.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (m.isEnabled()) continue;
            it.remove();
        }
        return s;
    }

    public final Module get(String codeNameBase) {
        return this.modulesByName.get(codeNameBase);
    }

    public ModuleInfo findCodeNameBase(String cnb) {
        return this.get(cnb);
    }

    public ModuleInfo ownerOf(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof Util.ModuleProvider) {
            return ((Util.ModuleProvider)((Object)cl)).getModule();
        }
        String codename = Module.findClasspathModuleCodeName(clazz);
        if (codename != null) {
            return this.get(codename.replaceFirst("/\\d+$", ""));
        }
        return null;
    }

    @Deprecated
    public Set<Module> getModuleInterdependencies(Module m, boolean reverse, boolean transitive) {
        return Util.moduleInterdependencies(m, reverse, transitive, true, this.modules, this.modulesByName, this.getProvidersOf());
    }

    public Set<Module> getModuleInterdependencies(Module m, boolean reverse, boolean transitive, boolean considerNeeds) {
        return Util.moduleInterdependencies(m, reverse, transitive, considerNeeds, this.modules, this.modulesByName, this.getProvidersOf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        Object object = this.classLoaderLock;
        synchronized (object) {
            return this.classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateClassLoader() {
        SystemClassLoader nue;
        Object object = this.classLoaderLock;
        synchronized (object) {
            this.classLoader.destroy();
        }
        HashSet<ClassLoader> foundParents = new HashSet<ClassLoader>(this.modules.size() * 4 / 3 + 2);
        ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>(this.modules.size() + 1);
        ClassLoader base = ModuleManager.class.getClassLoader();
        foundParents.add(base);
        parents.add(base);
        for (Module m : this.modules) {
            if (!m.isEnabled() || !foundParents.add(m.getClassLoader())) continue;
            parents.add(m.getClassLoader());
        }
        if (this.moduleFactory.removeBaseClassLoader()) {
            parents.remove(base);
        }
        ClassLoader[] parentCLs = parents.toArray(new ClassLoader[0]);
        try {
            nue = new SystemClassLoader(this.classLoaderPatches, parentCLs, this.modules);
        }
        catch (IllegalArgumentException iae) {
            Util.err.log(Level.WARNING, null, iae);
            nue = new SystemClassLoader(this.classLoaderPatches, new ClassLoader[]{ModuleManager.class.getClassLoader()}, Collections.emptySet());
        }
        Object object2 = this.classLoaderLock;
        synchronized (object2) {
            this.classLoader = nue;
            ModuleManager.updateContextClassLoaders(this.classLoader, false);
        }
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_CLASS_LOADER, null, null));
    }

    private static void updateContextClassLoaders(ClassLoader l, boolean force) {
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        while (g.getParent() != null) {
            g = g.getParent();
        }
        while (true) {
            int s;
            Thread[] ts;
            int x;
            if ((x = g.enumerate(ts = new Thread[s = g.activeCount() + 1], true)) < s) {
                for (int i = 0; i < x; ++i) {
                    if (force || ts[i].getContextClassLoader() instanceof SystemClassLoader) {
                        try {
                            ts[i].setContextClassLoader(l);
                        }
                        catch (SecurityException se) {
                            if (!Util.err.isLoggable(Level.FINE)) continue;
                            Util.err.fine("Cannot set context ClassLoader to the Thread: " + String.valueOf(ts[i]));
                        }
                        continue;
                    }
                    if (!Util.err.isLoggable(Level.FINE)) continue;
                    Util.err.fine("Not touching context class loader " + String.valueOf(ts[i].getContextClassLoader()) + " on thread " + ts[i].getName());
                }
                if (!Util.err.isLoggable(Level.FINE)) break;
                Util.err.fine("Set context class loader on " + x + " threads");
                break;
            }
            Util.err.fine("Race condition getting all threads, restarting...");
        }
    }

    private static void checkMissingModules(Set<Module> requested, List<Module> reallyEnabled) throws InvalidException {
        InvalidException ex = null;
        HashSet<Module> reallyEnabledSet = new HashSet<Module>(reallyEnabled);
        for (Module m : requested) {
            if (reallyEnabledSet.contains((Object)m)) continue;
            InvalidException newEx = new InvalidException(m, "Requested by OSGi bundle");
            if (ex != null) {
                newEx.initCause(ex);
            }
            ex = newEx;
        }
        if (ex != null) {
            throw ex;
        }
    }

    private static int countEnabled(List<Module> toEnable) {
        int cnt = 0;
        for (Module m : toEnable) {
            if (!m.isEnabled()) continue;
            ++cnt;
        }
        return cnt;
    }

    final Boolean isOSGi(File jar) {
        return this.mdc.isOSGi(jar.getPath());
    }

    final InputStream dataFor(File jar) {
        if (jar == null) {
            return null;
        }
        byte[] arr = this.mdc.getModuleState(jar.getPath());
        return arr == null ? null : new ByteArrayInputStream(arr);
    }

    final String cnbFor(File jar) {
        if (jar == null) {
            return null;
        }
        return this.mdc.getCnb(jar.getPath());
    }

    final String fragmentFor(File jar) {
        if (jar == null) {
            return null;
        }
        return this.mdc.getFragment(jar.getPath());
    }

    private Map<String, Set<Module>> getProvidersOf() {
        return this.providersOf.getProvidersOf();
    }

    static void registerProviders(Module m, Map<String, Set<Module>> po) {
        String[] provides = m.getProvides();
        for (int i = 0; i < provides.length; ++i) {
            Set<Module> providing = po.get(provides[i]);
            if (providing == null) {
                providing = new HashSet<Module>(16);
                po.put(provides[i], providing);
            }
            providing.add(m);
        }
    }

    final NetigsoFramework netigso() {
        return this.netigso.getDefault();
    }

    final void netigsoLoaderUp(NetigsoModule nm) throws IOException {
        this.netigso.classLoaderUp(nm);
    }

    final void netigsoLoaderDown(NetigsoModule nm) {
        this.netigso.classLoaderDown(nm);
    }

    @Deprecated
    public Module create(File jar, Object history, boolean reloadable, boolean autoload) throws IOException, DuplicateException {
        return this.create(jar, history, reloadable, autoload, false);
    }

    public Module create(File jar, Object history, boolean reloadable, boolean autoload, boolean eager) throws IOException, DuplicateException {
        this.assertWritable();
        this.ev.log("startCreateRegularModule", jar);
        Module m = this.moduleFactory.create(jar.getAbsoluteFile(), history, reloadable, autoload, eager, this, this.ev);
        this.ev.log("finishCreateRegularModule", jar);
        this.subCreate(m);
        return m;
    }

    public Module createBundle(File jar, Object history, boolean reloadable, boolean autoload, boolean eager, int startLevel) throws IOException, DuplicateException {
        this.assertWritable();
        this.ev.log("startCreateRegularModule", jar);
        Module m = this.moduleFactory.create(jar.getAbsoluteFile(), history, reloadable, autoload, eager, this, this.ev);
        if (!(m instanceof NetigsoModule)) {
            throw new InvalidException("Expecting an OSGI bundle in " + String.valueOf(jar));
        }
        NetigsoModule nm = (NetigsoModule)m;
        nm.setStartLevel(startLevel);
        this.ev.log("finishCreateRegularModule", jar);
        this.subCreate(m);
        return m;
    }

    public Module createFixed(Manifest mani, Object history, ClassLoader loader) throws InvalidException, DuplicateException {
        return this.createFixed(mani, history, loader, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Module createFixed(Manifest mani, Object history, ClassLoader loader, boolean autoload, boolean eager) throws InvalidException, DuplicateException {
        this.assertWritable();
        if (mani == null || loader == null) {
            throw new IllegalArgumentException("null manifest or loader");
        }
        this.ev.log("startCreateBootModule", history);
        Module m = this.moduleFactory.createFixed(mani, history, loader, autoload, eager, this, this.ev);
        this.ev.log("finishCreateBootModule", history);
        this.subCreate(m);
        ModuleManager moduleManager = this;
        synchronized (moduleManager) {
            ArrayList<Object> mods;
            Collection<Reference<Module>> oldMods = this.bootstrapModules.get(loader);
            if (oldMods == null) {
                mods = new ArrayList();
            } else {
                mods = new ArrayList<Reference<Module>>(oldMods);
                Iterator rit = mods.iterator();
                while (rit.hasNext()) {
                    Reference r = (Reference)rit.next();
                    if (r.get() != null) continue;
                    rit.remove();
                }
            }
            mods.add(new WeakReference<Module>(m));
            this.bootstrapModules.put(loader, mods);
        }
        return m;
    }

    void refineDependencies(Module m, Set<Dependency> dependencies) {
        this.installer.refineDependencies(m, dependencies);
    }

    Set<Dependency> loadDependencies(String cnb) {
        return this.installer.loadDependencies(cnb);
    }

    String[] refineProvides(Module m) {
        return this.installer.refineProvides(m);
    }

    public ClassLoader refineClassLoader(Module m, List<? extends ClassLoader> parents) {
        this.installer.refineClassLoader(m, parents);
        String fragmentHost = m.getFragmentHostCodeName();
        if (fragmentHost == null) {
            return null;
        }
        Module theHost = this.modulesByName.get(fragmentHost);
        if (theHost == null) {
            throw new IllegalStateException("Missing hosting module " + fragmentHost + " for fragment " + m.getCodeName());
        }
        if (!theHost.isEnabled()) {
            throw new IllegalStateException("Host module for " + m.getCodeName() + " should have been enabled: " + String.valueOf((Object)theHost));
        }
        return theHost.getClassLoader();
    }

    public Collection<Module> getAttachedFragments(Module m) {
        String cdn = m.getCodeNameBase();
        Collection<Module> frags = this.fragmentModules.get(cdn);
        return frags == null ? Collections.emptySet() : frags;
    }

    void refineModulePath(Module m, List<File> path) {
        String cnb = m.getCodeNameBase();
        Collection<Module> injectList = this.fragmentModules.get(cnb);
        if (injectList == null) {
            return;
        }
        for (Module inject : injectList) {
            if (!this.isOrWillEnable(inject)) continue;
            Util.err.log(Level.FINER, "Compat: injecting contents of fragment " + inject.getCodeNameBase() + " into " + m.getCodeNameBase());
            List<File> allJars = inject.getAllJars();
            path.addAll(allJars);
        }
    }

    @Deprecated
    public boolean shouldDelegateResource(Module m, Module parent, String pkg) {
        return this.shouldDelegateResource(m, parent, pkg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldDelegateResource(Module m, Module parent, String pkg, ClassLoader ldr) {
        Module.PackageExport[] exports;
        if (parent != null) {
            exports = parent.getPublicPackages();
        } else if (ldr != null) {
            HashSet<Module> loaderMods = null;
            ModuleManager moduleManager = this;
            synchronized (moduleManager) {
                Dependency[] refMods = this.bootstrapModules.get(ldr);
                if (refMods != null) {
                    loaderMods = new HashSet<Module>();
                    Iterator<Reference<Module>> rmit = refMods.iterator();
                    while (rmit.hasNext()) {
                        Reference<Module> refMod = rmit.next();
                        Module mm = refMod.get();
                        if (mm == null) {
                            rmit.remove();
                            continue;
                        }
                        loaderMods.add(mm);
                    }
                }
            }
            HashSet<String> cbn = new HashSet<String>();
            for (Dependency d : m.getDependenciesArray()) {
                if (d.getType() != 1) continue;
                cbn.add(d.getName());
            }
            if (loaderMods != null) {
                for (Module lm : loaderMods) {
                    if (!cbn.remove(lm.getCodeName()) || !this.shouldDelegateResource(m, lm, pkg, ldr)) continue;
                    return true;
                }
                return false;
            }
            exports = null;
        } else {
            exports = null;
        }
        if (exports != null) {
            boolean exported = false;
            if (parent.isDeclaredAsFriend(m)) {
                for (int i = 0; i < exports.length; ++i) {
                    if (!(exports[i].recursive ? pkg.startsWith(exports[i].pkg) : pkg.equals(exports[i].pkg))) continue;
                    exported = true;
                    break;
                }
            }
            if (!exported) {
                boolean impldep = false;
                Dependency[] deps = m.getDependenciesArray();
                for (int i = 0; i < deps.length; ++i) {
                    if (deps[i].getType() != 1 || deps[i].getComparison() != 2 || !deps[i].getName().equals(parent.getCodeName())) continue;
                    impldep = true;
                    break;
                }
                if (!impldep) {
                    if (Util.err.isLoggable(Level.FINE)) {
                        Util.err.fine("Refusing to load non-public package " + pkg + " for " + String.valueOf((Object)m) + " from parent module " + String.valueOf((Object)parent) + " without an impl dependency");
                    }
                    return false;
                }
            }
        }
        if (pkg.startsWith("META-INF/")) {
            return false;
        }
        return this.installer.shouldDelegateResource(m, parent, pkg);
    }

    Manifest loadManifest(File jar) throws IOException {
        return this.installer.loadManifest(jar);
    }

    private void subCreate(Module m) throws DuplicateException {
        Module old = this.get(m.getCodeNameBase());
        if (old != null) {
            if (!Boolean.getBoolean("netbeans.ignore.dupmodule")) {
                throw new DuplicateException(old, m);
            }
            Util.err.warning("Duplicate loading ignored: " + String.valueOf((Object)old) + " and " + String.valueOf((Object)m));
            return;
        }
        this.modules.add(m);
        this.modulesByName.put(m.getCodeNameBase(), m);
        this.providersOf.possibleProviderAdded(m);
        this.registerModuleFragment(m);
        this.lookup.add(m);
        this.firer.created(m);
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_MODULES, null, null));
        this.clearProblemCache();
        this.firer.fire();
    }

    private Module findHostModule(Module m, boolean assertNotEnabled) {
        String codeNameBase = m.getFragmentHostCodeName();
        if (codeNameBase == null) {
            return null;
        }
        Module host = this.modulesByName.get(codeNameBase);
        if (assertNotEnabled && host != null && host.isEnabled() && host.getClassLoader() != null) {
            throw new IllegalStateException("Host module " + String.valueOf((Object)host) + " was enabled before, will not accept fragment " + String.valueOf((Object)m));
        }
        return host;
    }

    private boolean registerModuleFragment(Module m) {
        String codeNameBase = m.getFragmentHostCodeName();
        if (codeNameBase == null) {
            return true;
        }
        Module host = this.modulesByName.get(codeNameBase);
        if (host != null && host.isEnabled()) {
            return false;
        }
        Collection<Module> frags = this.fragmentModules.get(codeNameBase);
        if (frags == null) {
            frags = new HashSet<Module>(1);
            this.fragmentModules.put(codeNameBase, frags);
        }
        frags.add(m);
        return true;
    }

    private void removeFragmentFromHost(Module m) {
        String fragHost = m.getFragmentHostCodeName();
        if (fragHost == null) {
            return;
        }
        Module hostMod = this.modulesByName.get(fragHost);
        if (hostMod != null && hostMod.isEnabled() && m.isEnabled()) {
            throw new IllegalStateException("Host module " + m.getCodeName() + " was loaded, cannot remove fragment");
        }
        Collection<Module> frags = this.fragmentModules.get(fragHost);
        if (frags != null) {
            frags.remove((Object)m);
        }
    }

    public void delete(Module m) throws IllegalArgumentException {
        this.assertWritable();
        if (m.isFixed()) {
            throw new IllegalModuleException(IllegalModuleException.Reason.DELETE_FIXED_MODULE, m);
        }
        if (m.isEnabled()) {
            throw new IllegalModuleException(IllegalModuleException.Reason.DELETE_ENABLED_MODULE, m);
        }
        this.ev.log("deleteModule", new Object[]{m});
        this.removeFragmentFromHost(m);
        this.modules.remove((Object)m);
        this.modulesByName.remove(m.getCodeNameBase());
        this.providersOf.possibleProviderRemoved(m);
        this.lookup.remove(m);
        this.firer.deleted(m);
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_MODULES, null, null));
        this.firer.change(new ChangeFirer.Change((Object)m, "valid", Boolean.TRUE, Boolean.FALSE));
        this.clearProblemCache();
        m.destroy();
        this.firer.fire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(Module m) throws IllegalArgumentException, IOException {
        this.assertWritable();
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("reload: " + String.valueOf((Object)m));
        }
        if (m.isFixed()) {
            throw new IllegalModuleException(IllegalModuleException.Reason.RELOAD_FIXED_MODULE, m);
        }
        if (m.isEnabled()) {
            throw new IllegalModuleException(IllegalModuleException.Reason.RELOAD_ENABLED_MODULE, m);
        }
        this.providersOf.possibleProviderRemoved(m);
        try {
            m.reload();
        }
        catch (IOException ioe) {
            this.delete(m);
            throw ioe;
        }
        this.providersOf.possibleProviderAdded(m);
        this.firer.change(new ChangeFirer.Change((Object)m, "manifest", null, null));
        Object object = this.MODULE_PROBLEMS_LOCK;
        synchronized (object) {
            this.moduleProblemsWithoutNeeds.remove((Object)m);
            this.moduleProblemsWithNeeds.remove((Object)m);
        }
        this.firer.change(new ChangeFirer.Change((Object)m, "problems", null, null));
        this.clearProblemCache();
        this.firer.fire();
    }

    public final void enable(Module m) throws IllegalArgumentException, InvalidException {
        this.enable(m, true);
    }

    final void enable(Module m, boolean honor) throws IllegalArgumentException, InvalidException {
        this.enable(Collections.singleton(m), honor);
    }

    public final void disable(Module m) throws IllegalArgumentException {
        this.disable(Collections.singleton(m));
    }

    public void enable(Set<Module> modules) throws IllegalArgumentException, InvalidException {
        this.enable(modules, true);
    }

    public boolean isOrWillEnable(Module m) {
        if (m.isEnabled()) {
            return true;
        }
        EnableContext ctx = this.enableContext.get();
        return ctx != null && ctx.willEnable.contains((Object)m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enable(Set<Module> modules, boolean honorAutoloadEager) throws IllegalArgumentException, InvalidException {
        HashSet<Module> testing;
        this.assertWritable();
        Util.err.log(Level.FINE, "enable: {0}", modules);
        this.ev.log("perfStart", "ModuleManager.enable");
        List<Module> toEnable = this.simulateEnable(modules, honorAutoloadEager);
        this.ev.log("perfTick", "checked the required ordering and autoloads");
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("enable: toEnable=" + String.valueOf(toEnable));
        }
        if (!(testing = new HashSet<Module>(toEnable)).containsAll(modules)) {
            HashSet<Module> bogus = new HashSet<Module>(modules);
            bogus.removeAll(testing);
            HashMap<Module, Set<Union2<Dependency, InvalidException>>> errors = new HashMap<Module, Set<Union2<Dependency, InvalidException>>>();
            for (Module b : bogus) {
                errors.put(b, this.missingDependencies(b));
            }
            throw new IllegalModuleException(IllegalModuleException.Reason.ENABLE_MISSING, errors);
        }
        for (Module m : testing) {
            Module maybeHost = this.findHostModule(m, true);
            if (modules.contains((Object)m) || m.isAutoload() || m.isEager() || maybeHost != null || testing.contains((Object)maybeHost)) continue;
            throw new IllegalModuleException(IllegalModuleException.Reason.ENABLE_TESTING, m);
        }
        Util.err.fine("enable: verified dependencies");
        this.ev.log("perfTick", "verified dependencies");
        this.ev.log("startEnableModules", toEnable);
        this.netigso.willEnable(toEnable);
        try {
            this.enableContext.set(new EnableContext(toEnable));
            this.doEnable(toEnable);
        }
        finally {
            this.enableContext.remove();
        }
    }

    private void doEnable(List<Module> toEnable) throws IllegalArgumentException, InvalidException {
        while (true) {
            LinkedList<Module> fallback = new LinkedList<Module>();
            boolean tryingClassLoaderUp = false;
            Dependency failedPackageDep = null;
            try {
                this.ev.log("perfStart", "module preparation");
                for (Module m : toEnable) {
                    if (m.isEnabled()) continue;
                    fallback.addFirst(m);
                    if (Util.err.isLoggable(Level.FINE)) {
                        Util.err.fine("enable: bringing up: " + String.valueOf((Object)m));
                    }
                    this.ev.log("perfStart", "bringing up classloader on " + m.getCodeNameBase());
                    try {
                        Set<Module> parents = this.calculateParents(m);
                        m.classLoaderUp(parents);
                    }
                    catch (IOException ioe) {
                        tryingClassLoaderUp = true;
                        InvalidException ie = new InvalidException(m, ioe.toString());
                        ie.initCause(ioe);
                        throw ie;
                    }
                    m.setEnabled(true);
                    this.ev.log("perfEnd", "bringing up classloader on " + m.getCodeNameBase());
                    if (Util.err.isLoggable(Level.FINE)) {
                        Util.err.fine("enable: checking package dependencies for " + String.valueOf((Object)m));
                    }
                    Dependency[] dependencies = m.getDependenciesArray();
                    for (int i = 0; i < dependencies.length; ++i) {
                        Dependency dep = dependencies[i];
                        if (dep.getType() != 2) continue;
                        if (!Util.checkPackageDependency(dep, m.getClassLoader())) {
                            failedPackageDep = dep;
                            String polite = (String)m.getLocalizedAttribute("OpenIDE-Module-Package-Dependency-Message");
                            throw new InvalidException(m, "Dependency failed on " + String.valueOf(dep), polite);
                        }
                        if (!Util.err.isLoggable(Level.FINE)) continue;
                        Util.err.fine("Successful check for: " + String.valueOf(dep));
                    }
                    this.ev.log("perfStart", "ModuleInstaller.prepare " + m.getCodeName());
                    this.installer.prepare(m);
                    this.ev.log("perfEnd", "ModuleInstaller.prepare " + m.getCodeName());
                }
                this.ev.log("perfEnd", "module preparation");
            }
            catch (InvalidException ie) {
                Module bad = ie.getModule();
                if (bad == null) {
                    throw new IllegalStateException("Problem with no associated module: " + String.valueOf(ie), ie);
                }
                Set<Union2<Dependency, InvalidException>> probs = this.moduleProblemsWithNeeds.get((Object)bad);
                if (probs == null) {
                    throw new IllegalStateException("Were trying to install a module that had never been checked: " + String.valueOf((Object)bad), ie);
                }
                if (!probs.isEmpty()) {
                    throw new IllegalStateException("Were trying to install a module that was known to be bad: " + String.valueOf((Object)bad) + " " + String.valueOf(probs), ie);
                }
                if (probs == EMPTY_COLLECTION) {
                    probs = new HashSet<Union2<Dependency, InvalidException>>(8);
                    this.moduleProblemsWithNeeds.put(bad, probs);
                }
                if (failedPackageDep != null) {
                    probs.add((Union2<Dependency, InvalidException>)Union2.createFirst(failedPackageDep));
                } else {
                    probs.add((Union2<Dependency, InvalidException>)Union2.createSecond((Object)ie));
                }
                this.clearProblemCache();
                this.firer.change(new ChangeFirer.Change((Object)bad, "problems", Collections.EMPTY_SET, Collections.singleton("something")));
                if (Util.err.isLoggable(Level.FINE)) {
                    Util.err.fine("enable: will roll back from: " + String.valueOf(ie));
                }
                for (Module m : fallback) {
                    if (m.isFixed()) continue;
                    m.setEnabled(false);
                    if (tryingClassLoaderUp) {
                        tryingClassLoaderUp = false;
                        continue;
                    }
                    m.classLoaderDown();
                    System.gc();
                    System.runFinalization();
                    m.cleanup();
                }
                this.firer.fire();
                throw ie;
            }
            if (this.classLoader != null) {
                Util.err.fine("enable: adding to system classloader");
                LinkedList<ClassLoader> nueclassloaders = new LinkedList<ClassLoader>();
                if (this.moduleFactory.removeBaseClassLoader()) {
                    ClassLoader base = ModuleManager.class.getClassLoader();
                    nueclassloaders.add(this.moduleFactory.getClasspathDelegateClassLoader(this, base));
                    for (Module m : toEnable) {
                        ClassLoader c1 = m.getClassLoader();
                        if (c1 == base) continue;
                        nueclassloaders.add(c1);
                    }
                } else {
                    for (Module m : toEnable) {
                        if (m.getClassLoader() == ClassLoader.getSystemClassLoader()) {
                            nueclassloaders.addFirst(m.getClassLoader());
                            continue;
                        }
                        nueclassloaders.add(m.getClassLoader());
                    }
                }
                this.classLoader.append(nueclassloaders.toArray(new ClassLoader[0]));
                this.classLoader.size += toEnable.size();
            } else {
                Util.err.fine("enable: no class loader yet, not appending");
            }
            Util.err.fine("enable: fixing classloader");
            this.installer.classLoaderUp(this.classLoader);
            Util.err.fine("enable: continuing to installation");
            Set<Module> enableMore = this.netigso.turnOn(this.classLoader, Collections.unmodifiableCollection(new ArrayList<Module>(this.modules)));
            if (enableMore.isEmpty()) break;
            Util.err.log(Level.FINE, "netigso needs additional modules: {0}", enableMore);
            List<Module> toEnableMore = this.simulateEnable(enableMore, false);
            ModuleManager.checkMissingModules(enableMore, toEnableMore);
            toEnable.addAll(toEnableMore);
            Util.err.log(Level.FINE, "Adding {0} and trying again", toEnableMore);
        }
        if (!toEnable.isEmpty() && ModuleManager.countEnabled(toEnable) == 0) {
            throw new InvalidException("No module could be enabled: " + String.valueOf(toEnable));
        }
        this.installer.load(toEnable);
        this.netigso.startFramework();
        for (Module m : toEnable) {
            try {
                String agentClass = m.dataWithCheck().getAgentClass();
                if (agentClass == null) continue;
                m.assignInstrumentation(NbInstrumentation.registerAgent(m.getClassLoader(), agentClass));
            }
            catch (InvalidException ex) {
                Util.err.log(Level.FINE, null, ex);
            }
        }
        Util.err.fine("enable: firing changes");
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_ENABLED_MODULES, null, null));
        for (Module m : toEnable) {
            this.firer.change(new ChangeFirer.Change((Object)m, "enabled", Boolean.FALSE, Boolean.TRUE));
            if (m.isFixed()) continue;
            this.firer.change(new ChangeFirer.Change((Object)m, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishEnableModules", toEnable);
        this.firer.fire();
    }

    public void disable(Set<Module> modules) throws IllegalArgumentException {
        this.assertWritable();
        Util.err.fine("disable: " + String.valueOf(modules));
        if (modules.isEmpty()) {
            return;
        }
        List<Module> toDisable = this.simulateDisable(modules);
        Util.err.fine("disable: toDisable=" + String.valueOf(toDisable));
        for (Module m : toDisable) {
            if (modules.contains((Object)m) || m.isAutoload() || m.isEager()) continue;
            throw new IllegalModuleException(IllegalModuleException.Reason.DISABLE_TOO, m);
        }
        Util.err.fine("disable: verified dependencies");
        this.ev.log("startDisableModules", toDisable);
        this.installer.unload(toDisable);
        for (Module m : toDisable) {
            this.installer.dispose(m);
            m.setEnabled(false);
            m.unregisterInstrumentation();
            if (m.getFragmentHostCodeName() == null) {
                m.classLoaderDown();
            }
            m.releaseClassLoader();
        }
        System.gc();
        System.runFinalization();
        for (Module m : toDisable) {
            m.cleanup();
        }
        Util.err.fine("disable: finished, will notify changes");
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_ENABLED_MODULES, null, null));
        this.invalidateClassLoader();
        for (Module m : toDisable) {
            this.firer.change(new ChangeFirer.Change((Object)m, "enabled", Boolean.TRUE, Boolean.FALSE));
            this.firer.change(new ChangeFirer.Change((Object)m, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishDisableModules", toDisable);
        this.firer.fire();
    }

    private final Set<Module> calculateParents(Module m) throws NumberFormatException, IOException {
        Dependency[] dependencies = m.getDependenciesArray();
        HashSet<Module> res = new HashSet<Module>(dependencies.length * 4 / 3 + 1);
        for (int i = 0; i < dependencies.length; ++i) {
            Dependency dep = dependencies[i];
            if (dep.getType() != 1) continue;
            String name = (String)Util.parseCodeName(dep.getName())[0];
            Module parent = this.get(name);
            if (parent == null) {
                throw new IOException("Parent " + name + " not found!");
            }
            res.add(parent);
        }
        Collection<Module> fragments = this.getAttachedFragments(m);
        if (!fragments.isEmpty()) {
            for (Module frag : fragments) {
                if (!this.isOrWillEnable(frag)) continue;
                Set<Module> mods = this.calculateParents(frag);
                res.addAll(mods);
            }
            res.remove((Object)m);
            res.removeAll(fragments);
        }
        return res;
    }

    public List<Module> simulateEnable(Set<Module> modules) throws IllegalArgumentException {
        return this.simulateEnable(modules, true);
    }

    final List<Module> simulateEnable(Set<Module> modules, boolean honorAutoloadEager) throws IllegalArgumentException {
        List<String> cnbs = this.mdc.simulateEnable(modules);
        if (cnbs != null) {
            ArrayList<Module> arr = new ArrayList<Module>(cnbs.size());
            for (String cnb : cnbs) {
                arr.add(this.get(cnb));
            }
            assert (!arr.contains(null)) : arr;
            return arr;
        }
        TreeSet<Module> willEnable = new TreeSet<Module>(new CodeNameBaseComparator());
        for (Module m : modules) {
            if (honorAutoloadEager) {
                if (m.isAutoload()) {
                    throw new IllegalModuleException(IllegalModuleException.Reason.SIMULATE_ENABLE_AUTOLOAD, m);
                }
                if (m.isEager()) {
                    throw new IllegalModuleException(IllegalModuleException.Reason.SIMULATE_ENABLE_EAGER, m);
                }
            }
            if (m.isEnabled()) {
                throw new IllegalModuleException(IllegalModuleException.Reason.SIMULATE_ENABLE_ALREADY, m);
            }
            if (!m.isValid()) {
                throw new IllegalModuleException(IllegalModuleException.Reason.SIMULATE_ENABLE_INVALID, m);
            }
            this.addedBecauseOfDependent = null;
            this.maybeAddToEnableList(willEnable, modules, m, true, null);
        }
        HashSet<Module> stillDisabled = new HashSet<Module>(this.modules);
        Iterator it = stillDisabled.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (!m.isEnabled() && !willEnable.contains((Object)m)) continue;
            it.remove();
        }
        while (this.searchForPossibleEager(willEnable, stillDisabled, modules)) {
        }
        Map<Module, List<Module>> deps = Util.moduleDependencies(willEnable, this.modulesByName, this.getProvidersOf(), this.fragmentModules);
        try {
            List l = Utilities.topologicalSort(willEnable, deps);
            Collections.reverse(l);
            this.mdc.registerEnable(modules, l);
            return l;
        }
        catch (TopologicalSortException ex) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.log(Level.WARNING, null, ex);
            }
            Util.err.warning("Cyclic module dependencies, will refuse to enable: " + String.valueOf(deps));
            return Collections.emptyList();
        }
    }

    public boolean hasToEnableCompatModules(Set<Module> modules) throws IllegalArgumentException {
        List<Module> toEnable = this.simulateEnable(modules);
        for (Module m : toEnable) {
            Module fragHost;
            String fragmentHostCodeName = m.getFragmentHostCodeName();
            if (fragmentHostCodeName == null || fragmentHostCodeName.isEmpty() || (fragHost = this.get(fragmentHostCodeName)) == null || !fragHost.isEnabled()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddToEnableList(Set<Module> willEnable, Set<Module> mightEnable, Module m, boolean okToFail, String reason) {
        if (!this.missingDependencies(m).isEmpty()) {
            if (!okToFail) {
                Util.err.warning("Module " + String.valueOf((Object)m) + " had unexpected problems: " + String.valueOf(this.missingDependencies(m)));
                Util.err.fine(" (willEnable: " + String.valueOf(willEnable) + " mightEnable: " + String.valueOf(mightEnable) + ")");
            }
            return;
        }
        if (this.reported.add(m)) {
            if (this.addedBecauseOfDependent == null) {
                DEPLOG.log(Level.FINE, "DEP: \"" + m.getCodeNameBase() + "\"" + (this.eagerActivation ? "[color=cornsilk]" : ""));
            } else if (!this.addedBecauseOfDependent.getCodeNameBase().equals(m.getCodeNameBase())) {
                DEPLOG.log(Level.FINE, "DEP: \"" + this.addedBecauseOfDependent.getCodeNameBase() + "\" ->\"" + (String)(reason != null ? "[label=\"" + reason + "\"]" : "") + " " + m.getCodeNameBase() + "\"");
            }
        }
        if (!willEnable.add(m)) {
            return;
        }
        Module outer = this.addedBecauseOfDependent;
        boolean outerEagerActivatioon = this.eagerActivation;
        Set<Module> outerReported = this.reported;
        try {
            this.reported = new HashSet<Module>();
            this.addedBecauseOfDependent = m;
            Module host = this.findHostModule(m, false);
            if (host != null && !host.isEnabled()) {
                this.maybeAddToEnableList(willEnable, mightEnable, host, okToFail, "Fragment host");
            }
            for (Dependency dep : m.getDependenciesArray()) {
                if (dep.getType() == 1) {
                    String codeNameBase = (String)Util.parseCodeName(dep.getName())[0];
                    Module other = this.get(codeNameBase);
                    if (other == null) {
                        throw new IllegalStateException("Should have found module: " + codeNameBase);
                    }
                    if (other.isEnabled()) continue;
                    this.maybeAddToEnableList(willEnable, mightEnable, other, false, null);
                    continue;
                }
                if (dep.getType() == 5 || dep.getType() == 6 || dep.getType() == 7) {
                    Set<Module> providers = this.getProvidersOf().get(dep.getName());
                    if (providers == null) {
                        assert (dep.getType() == 7) : "Should have found a provider of " + String.valueOf(dep);
                        continue;
                    }
                    boolean foundOne = false;
                    for (Module other : providers) {
                        if (!other.isEnabled() && (!other.getProblems().isEmpty() || !mightEnable.contains((Object)other))) continue;
                        foundOne = true;
                        break;
                    }
                    if (foundOne) continue;
                    for (Module other : providers) {
                        if (!other.getProblems().isEmpty() && other.isAutoload()) {
                            if (!this.reportedProblems.add(other)) continue;
                            Util.err.log(Level.FINE, "Not enabling {0} providing {2} because of unsatisfied requirement: {1}", new Object[]{other.getCodeNameBase(), other.getProblems(), dep.getName()});
                            continue;
                        }
                        this.maybeAddToEnableList(willEnable, mightEnable, other, true, dep.getName().startsWith("cnb.") ? null : "Provides " + dep.getName());
                        if (foundOne || !willEnable.contains((Object)other)) continue;
                        foundOne = true;
                    }
                    assert (foundOne || dep.getType() == 7) : "Should have found a nonproblematic provider of " + String.valueOf(dep) + " among " + String.valueOf(providers) + " with willEnable=" + String.valueOf(willEnable) + " mightEnable=" + String.valueOf(mightEnable);
                    continue;
                }
                if (!(dep.getType() == 3 ? okToFail && !Util.checkJavaDependency(dep) : dep.getType() == 2 && okToFail && !Util.checkPackageDependency(dep, this.classLoader))) continue;
                return;
            }
            Collection<Module> frags = this.getAttachedFragments(m);
            for (Module fragMod : frags) {
                if (!fragMod.isEager()) continue;
                this.maybeAddToEnableList(willEnable, mightEnable, fragMod, fragMod.isAutoload() || fragMod.isEager(), "Fragment");
            }
        }
        finally {
            this.reported = outerReported;
            this.addedBecauseOfDependent = outer;
            this.eagerActivation = outerEagerActivatioon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean searchForPossibleEager(Set<Module> willEnable, Set<Module> stillDisabled, Set<Module> mightEnable) {
        boolean found = false;
        Iterator<Module> it = stillDisabled.iterator();
        while (it.hasNext()) {
            Module host;
            Module m = it.next();
            if (willEnable.contains((Object)m)) {
                it.remove();
                continue;
            }
            if (!m.isEager() || m.getFragmentHostCodeName() != null && ((host = this.modulesByName.get(m.getFragmentHostCodeName())) == null || !m.isEnabled() && !willEnable.contains((Object)m)) || !this.couldBeEnabledWithEagers(m, willEnable, new HashSet<Module>())) continue;
            found = true;
            it.remove();
            this.eagerActivation = true;
            try {
                this.maybeAddToEnableList(willEnable, mightEnable, m, false, "Eager");
            }
            finally {
                this.eagerActivation = false;
            }
        }
        return found;
    }

    private boolean couldBeEnabledWithEagers(Module m, Set<Module> willEnable, Set<Module> recursion) {
        if (m.isEnabled() || willEnable.contains((Object)m)) {
            return true;
        }
        if (!m.isAutoload() && !m.isEager()) {
            return false;
        }
        if (!m.getProblems().isEmpty()) {
            return false;
        }
        if (!recursion.add(m)) {
            return true;
        }
        Dependency[] dependencies = m.getDependenciesArray();
        for (int i = 0; i < dependencies.length; ++i) {
            Dependency dep = dependencies[i];
            if (dep.getType() == 1) {
                String codeNameBase = (String)Util.parseCodeName(dep.getName())[0];
                Module other = this.get(codeNameBase);
                if (other == null) {
                    throw new IllegalStateException("Should have found module: " + codeNameBase);
                }
                if (this.couldBeEnabledWithEagers(other, willEnable, recursion)) continue;
                return false;
            }
            if (dep.getType() == 5 || dep.getType() == 6) {
                Set<Module> providers = this.getProvidersOf().get(dep.getName());
                if (providers == null) {
                    throw new IllegalStateException("Should have found a provider of: " + dep.getName());
                }
                boolean foundOne = false;
                for (Module other : providers) {
                    if (!this.couldBeEnabledWithEagers(other, willEnable, recursion)) continue;
                    foundOne = true;
                    break;
                }
                if (foundOne) continue;
                return false;
            }
            if (!(dep.getType() == 3 ? !Util.checkJavaDependency(dep) : dep.getType() == 2 && !Util.checkPackageDependency(dep, this.classLoader))) continue;
            return false;
        }
        return true;
    }

    public List<Module> simulateDisable(Set<Module> modules) throws IllegalArgumentException {
        if (modules.isEmpty()) {
            return Collections.emptyList();
        }
        TreeSet<Module> willDisable = new TreeSet<Module>(new CodeNameBaseComparator());
        for (Module m : modules) {
            if (m.isAutoload()) {
                throw new IllegalModuleException(IllegalModuleException.Reason.SIMULATE_DISABLE_AUTOLOAD, m);
            }
            if (m.isEager()) {
                throw new IllegalModuleException(IllegalModuleException.Reason.SIMULATE_DISABLE_EAGER, m);
            }
            if (m.isFixed()) {
                throw new IllegalModuleException(IllegalModuleException.Reason.SIMULATE_DISABLE_FIXED, m);
            }
            if (!m.isEnabled()) {
                throw new IllegalModuleException(IllegalModuleException.Reason.SIMULATE_DISABLE_ALREADY, m);
            }
            this.addToDisableList(willDisable, m);
        }
        HashSet<Module> stillEnabled = new HashSet<Module>(this.getEnabledModules());
        stillEnabled.removeAll(willDisable);
        while (this.searchForUnusedAutoloads(willDisable, stillEnabled)) {
        }
        Map<Module, List<Module>> deps = Util.moduleDependencies(willDisable, this.modulesByName, this.getProvidersOf());
        try {
            return Utilities.topologicalSort(willDisable, deps);
        }
        catch (TopologicalSortException ex) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.log(Level.WARNING, null, ex);
            }
            Util.err.warning("Cyclic module dependencies, will turn them off in a random order: " + String.valueOf(deps));
            return new ArrayList<Module>(willDisable);
        }
    }

    private void addToDisableList(Set<Module> willDisable, Module m) {
        if (willDisable.contains((Object)m)) {
            return;
        }
        willDisable.add(m);
        block0: for (Module other : this.modules) {
            if (other.isFixed() || !other.isEnabled() || willDisable.contains((Object)other)) continue;
            Dependency[] depenencies = other.getDependenciesArray();
            for (int i = 0; i < depenencies.length; ++i) {
                Dependency dep = depenencies[i];
                if (dep.getType() == 1) {
                    if (!Util.parseCodeName(dep.getName())[0].equals(m.getCodeNameBase())) continue;
                    this.addToDisableList(willDisable, other);
                    continue block0;
                }
                if (dep.getType() != 5 && dep.getType() != 6 || !m.provides(dep.getName())) continue;
                boolean foundOne = false;
                for (Module third : this.getEnabledModules()) {
                    if (!third.isEnabled() || willDisable.contains((Object)third) || !third.provides(dep.getName())) continue;
                    foundOne = true;
                    break;
                }
                if (foundOne) continue;
                this.addToDisableList(willDisable, other);
                continue block0;
            }
        }
    }

    private boolean searchForUnusedAutoloads(Set<Module> willDisable, Set<Module> stillEnabled) {
        boolean found = false;
        Iterator<Module> it = stillEnabled.iterator();
        block0: while (it.hasNext()) {
            Module theHost;
            Module m = it.next();
            String host = m.getFragmentHostCodeName();
            if (host != null && (theHost = this.modulesByName.get(host)) != null && theHost.isEnabled() || !m.isAutoload()) continue;
            for (Module other : stillEnabled) {
                Dependency[] dependencies = other.getDependenciesArray();
                for (int i = 0; i < dependencies.length; ++i) {
                    Dependency dep = dependencies[i];
                    if (dep.getType() == 1 ? Util.parseCodeName(dep.getName())[0].equals(m.getCodeNameBase()) : (dep.getType() == 5 || dep.getType() == 6 || dep.getType() == 7) && m.provides(dep.getName())) continue block0;
                }
            }
            found = true;
            it.remove();
            willDisable.add(m);
        }
        return found;
    }

    Set<Union2<Dependency, InvalidException>> missingDependencies(Module probed) {
        return this.missingDependencies(probed, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Union2<Dependency, InvalidException>> missingDependencies(Module probed, boolean withNeeds) {
        Object object = this.MODULE_PROBLEMS_LOCK;
        synchronized (object) {
            Map<Module, Set<Union2<Dependency, InvalidException>>> mP = withNeeds ? this.moduleProblemsWithNeeds : this.moduleProblemsWithoutNeeds;
            Set<Union2<Dependency, InvalidException>> probs = mP.get((Object)probed);
            if (probs == null) {
                probs = new HashSet<Union2<Dependency, InvalidException>>(8);
                if (withNeeds) {
                    probs.addAll(this.missingDependencies(probed, false));
                }
                probs.add(PROBING_IN_PROCESS);
                mP.put(probed, probs);
                for (Dependency dep : probed.getDependenciesArray()) {
                    if (!(dep.getType() != 2 && dep.getType() != 3 || withNeeds)) {
                        String[] p;
                        boolean optional = probed.isEager();
                        if (!optional && probed.isAutoload() && (p = probed.getProvides()) != null) {
                            String cnbToken = "cnb." + probed.getCodeNameBase();
                            boolean bl = optional = p.length > (Arrays.asList(p).indexOf(cnbToken) != -1 ? 1 : 0);
                        }
                        if (!optional || (dep.getType() != 2 ? Util.checkJavaDependency(dep) : Util.checkPackageDependency(dep, this.classLoader))) continue;
                        probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                        continue;
                    }
                    if (dep.getType() == 1) {
                        Object[] depParse = Util.parseCodeName(dep.getName());
                        String codeNameBase = (String)depParse[0];
                        int relVersionMin = depParse[1] != null ? (Integer)depParse[1] : -1;
                        int relVersionMax = depParse[2] != null ? (Integer)depParse[2] : relVersionMin;
                        Module other = this.get(codeNameBase);
                        if (other == null) {
                            probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                            continue;
                        }
                        SpecificationVersion otherSpec = other.getSpecificationVersion();
                        if (otherSpec == null) {
                            otherSpec = new SpecificationVersion("0");
                        }
                        if (relVersionMin == relVersionMax) {
                            if (relVersionMin != other.getCodeNameRelease()) {
                                probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                                continue;
                            }
                            if (dep.getComparison() == 2 && !Utilities.compareObjects((Object)dep.getVersion(), (Object)other.getImplementationVersion())) {
                                probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                                continue;
                            }
                            if (dep.getComparison() == 1 && new SpecificationVersion(dep.getVersion()).compareTo(otherSpec) > 0) {
                                probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                                continue;
                            }
                        } else if (relVersionMin < relVersionMax) {
                            int otherRel = other.getCodeNameRelease();
                            if (otherRel < relVersionMin || otherRel > relVersionMax) {
                                probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                                continue;
                            }
                            if (dep.getComparison() == 2) {
                                throw new IllegalStateException("No such thing as ranged impl dep");
                            }
                            if (dep.getComparison() == 1 && otherRel == relVersionMin && new SpecificationVersion(dep.getVersion()).compareTo(otherSpec) > 0) {
                                probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                                continue;
                            }
                        } else {
                            throw new IllegalStateException("Upside-down rel vers range");
                        }
                        if (other.isEnabled() || (withNeeds || this.missingDependencies(other, false).isEmpty()) && (!withNeeds || ModuleManager.isAlmostEmpty(this.missingDependencies(other, true)))) continue;
                        probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                        continue;
                    }
                    if (dep.getType() == 5 || withNeeds && dep.getType() == 6) {
                        String token = dep.getName();
                        Set<Module> providers = this.getProvidersOf().get(token);
                        if (providers == null) {
                            probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                            continue;
                        }
                        boolean foundOne = false;
                        for (Module other : providers) {
                            if (foundOne) break;
                            if (other.isEnabled()) {
                                foundOne = true;
                                continue;
                            }
                            if ((withNeeds || !this.missingDependencies(other, false).isEmpty()) && (!withNeeds || !ModuleManager.isAlmostEmpty(this.missingDependencies(other, true)))) continue;
                            foundOne = true;
                        }
                        if (foundOne) continue;
                        probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                        continue;
                    }
                    if (dep.getType() != 3 || Util.checkJavaDependency(dep)) continue;
                    probs.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dep));
                }
                probs.remove(PROBING_IN_PROCESS);
                if (probs.isEmpty()) {
                    mP.put(probed, EMPTY_COLLECTION);
                }
            }
            return probs;
        }
    }

    private static boolean isAlmostEmpty(Set<Union2<Dependency, InvalidException>> probs) {
        return probs.isEmpty() || probs.equals(Collections.singleton(PROBING_IN_PROCESS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProblemCache() {
        Object object = this.MODULE_PROBLEMS_LOCK;
        synchronized (object) {
            this.clearProblemCache(this.moduleProblemsWithoutNeeds);
            this.clearProblemCache(this.moduleProblemsWithNeeds);
        }
    }

    private void clearProblemCache(Map<Module, Set<Union2<Dependency, InvalidException>>> mP) {
        Iterator<Map.Entry<Module, Set<Union2<Dependency, InvalidException>>>> it = mP.entrySet().iterator();
        while (it.hasNext()) {
            Set<Union2<Dependency, InvalidException>> s;
            Map.Entry<Module, Set<Union2<Dependency, InvalidException>>> entry = it.next();
            Module m = entry.getKey();
            if (m.isEnabled() || (s = entry.getValue()) == null) continue;
            boolean clear = false;
            for (Union2<Dependency, InvalidException> problem : s) {
                Dependency dep;
                if (problem.hasSecond() || (dep = (Dependency)problem.first()).getType() != 1 && dep.getType() != 5 && dep.getType() != 6 && dep.getType() != 7) continue;
                clear = true;
                break;
            }
            if (!clear && !s.isEmpty()) continue;
            it.remove();
            this.firer.change(new ChangeFirer.Change((Object)m, "problems", null, null));
        }
    }

    public boolean shutDown() {
        return this.shutDown(null);
    }

    public boolean shutDown(Runnable midHook) {
        try {
            return this.shutDownAsync(midHook).get();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    public Future<Boolean> shutDownAsync(Runnable midHook) {
        List sortedModules;
        this.assertWritable();
        Set<Module> unorderedModules = this.getEnabledModules();
        HashMap<String, Set<Module>> providersMap = new HashMap<String, Set<Module>>();
        for (Module m : unorderedModules) {
            ModuleManager.registerProviders(m, providersMap);
        }
        Map<Module, List<Module>> deps = Util.moduleDependencies(unorderedModules, this.modulesByName, providersMap);
        try {
            sortedModules = Utilities.topologicalSort(unorderedModules, deps);
        }
        catch (TopologicalSortException ex) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.log(Level.WARNING, null, ex);
            }
            Util.err.warning("Cyclic module dependencies, will not shut down cleanly: " + String.valueOf(deps));
            return new TaskFuture(true, Task.EMPTY);
        }
        if (!NbExit.isExiting() && !this.installer.closing(sortedModules)) {
            return new TaskFuture(false, Task.EMPTY);
        }
        if (midHook != null) {
            try {
                midHook.run();
            }
            catch (RuntimeException e) {
                Util.err.log(Level.WARNING, null, e);
            }
            catch (LinkageError e) {
                Util.err.log(Level.WARNING, null, e);
            }
        }
        this.netigso.shutdownFramework();
        Task task = this.installer.closeAsync(sortedModules);
        return new TaskFuture(true, task);
    }

    private class ProvidersOf {
        private Map<String, Set<Module>> providersOf;

        final synchronized Map<String, Set<Module>> getProvidersOf() {
            if (this.providersOf == null) {
                this.providersOf = new HashMap<String, Set<Module>>();
                for (Module m : ModuleManager.this.modules) {
                    this.possibleProviderAdded(m);
                }
            }
            return this.providersOf;
        }

        final synchronized void possibleProviderAdded(Module m) {
            if (this.providersOf == null) {
                return;
            }
            ModuleManager.registerProviders(m, this.providersOf);
        }

        final synchronized void possibleProviderRemoved(Module m) {
            if (this.providersOf == null) {
                return;
            }
            for (String token : m.getProvides()) {
                Set<Module> providing = this.providersOf.get(token);
                if (providing == null) continue;
                providing.remove((Object)m);
                if (!providing.isEmpty()) continue;
                this.providersOf.remove(token);
            }
        }
    }

    private class ModuleDataCache
    implements Stamps.Updater {
        private static final String CACHE = "all-manifests.dat";
        private final Map<String, byte[]> path2Data;
        private final Map<String, Boolean> path2OSGi;
        private final Map<String, String> path2Cnb;
        private final Map<String, String> path2Fragment;
        private final int moduleCount;
        private Set<String> toEnable;
        private List<String> willEnable;

        public ModuleDataCache() {
            char otherChar;
            InputStream is = Stamps.getModulesJARs().asStream(CACHE);
            HashMap<String, byte[]> map = null;
            HashMap<String, Boolean> osgi = null;
            HashMap<String, String> cnbs = null;
            HashMap<String, String> frags = null;
            Set toEn = null;
            List toWi = null;
            int cnt = -1;
            char c = otherChar = File.separatorChar == '/' ? (char)'\\' : '/';
            if (is != null) {
                try {
                    String path;
                    DataInputStream dis = new DataInputStream(is);
                    String locale = dis.readUTF();
                    String branding = dis.readUTF();
                    if (!Locale.getDefault().toString().equals(locale)) {
                        throw new IOException();
                    }
                    if (!branding.equals(this.nonNullBranding())) {
                        throw new IOException();
                    }
                    map = new HashMap<String, byte[]>();
                    osgi = new HashMap<String, Boolean>();
                    cnbs = new HashMap<String, String>();
                    frags = new HashMap<String, String>();
                    cnt = dis.readInt();
                    while (!(path = Stamps.readRelativePath(dis).replace(otherChar, File.separatorChar)).isEmpty()) {
                        boolean isOSGi = dis.readBoolean();
                        osgi.put(path, isOSGi);
                        cnbs.put(path, dis.readUTF());
                        int len = dis.readInt();
                        byte[] data = new byte[len];
                        dis.readFully(data);
                        map.put(path, data);
                        String fhost = dis.readUTF();
                        if (fhost == null) continue;
                        frags.put(path, fhost);
                    }
                    toEn = this.readCnbs(dis, new HashSet());
                    toWi = this.readCnbs(dis, new ArrayList());
                    dis.close();
                }
                catch (IOException ex) {
                    Util.err.log(Level.FINE, "Cannot read " + String.valueOf(Places.getCacheSubfile((String)CACHE)), ex);
                    map = null;
                    osgi = null;
                    cnbs = null;
                    toEn = null;
                    toWi = null;
                    frags = null;
                }
            }
            this.path2Data = map;
            this.path2OSGi = osgi;
            this.path2Cnb = cnbs;
            this.path2Fragment = frags;
            this.toEnable = toEn;
            this.willEnable = toWi;
            this.moduleCount = cnt;
            if (map == null) {
                this.reset();
            }
        }

        public Boolean isOSGi(String path) {
            if (this.path2OSGi == null) {
                return null;
            }
            return this.path2OSGi.get(path);
        }

        public synchronized byte[] getModuleState(String path) {
            byte[] res = null;
            if (this.path2Data != null) {
                res = this.path2Data.remove(path);
            }
            if (res == null) {
                this.reset();
            }
            return res;
        }

        final String getCnb(String path) {
            return this.path2Cnb == null ? null : this.path2Cnb.get(path);
        }

        final String getFragment(String path) {
            return this.path2Fragment == null ? null : this.path2Fragment.get(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flushCaches(DataOutputStream os) throws IOException {
            os.writeUTF(Locale.getDefault().toString());
            os.writeUTF(this.nonNullBranding());
            Set<Module> store = ModuleManager.this.getModules();
            os.writeInt(store.size());
            for (Module m : store) {
                File path = m.getJarFile();
                if (path == null) {
                    assert (m instanceof FixedModule) : "Only fixed modules are excluded from caches " + String.valueOf((Object)m);
                    continue;
                }
                Stamps.writeRelativePath(path.getPath(), os);
                os.writeBoolean(m.isNetigso());
                os.writeUTF(m.getCodeNameBase());
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                ObjectOutputStream dos = new ObjectOutputStream(data);
                m.writeData(dos);
                dos.close();
                byte[] arr = data.toByteArray();
                os.writeInt(arr.length);
                os.write(arr);
                String s = m.getFragmentHostCodeName();
                os.writeUTF(s == null ? "" : s);
            }
            Stamps.writeRelativePath("", os);
            ModuleDataCache moduleDataCache = this;
            synchronized (moduleDataCache) {
                this.writeCnbs(os, this.toEnable);
                this.writeCnbs(os, this.willEnable);
            }
        }

        @Override
        public void cacheReady() {
        }

        private synchronized void reset() {
            this.toEnable = null;
            this.willEnable = null;
        }

        final synchronized void registerEnable(Set<Module> modules, List<Module> l) {
            this.toEnable = new HashSet<String>();
            for (Module m : modules) {
                this.toEnable.add(m.getCodeNameBase());
            }
            ArrayList<String> arr = new ArrayList<String>(l.size());
            for (Module m : l) {
                arr.add(m.getCodeNameBase());
            }
            this.willEnable = Collections.unmodifiableList(arr);
            Stamps.getModulesJARs().scheduleSave(this, CACHE, false);
        }

        final synchronized List<String> simulateEnable(Set<Module> modules) {
            if (this.toEnable != null && modules.size() == this.toEnable.size() && this.moduleCount == ModuleManager.this.getModuleCount()) {
                HashSet<String> clone = new HashSet<String>(this.toEnable);
                for (Module m : modules) {
                    if (clone.remove(m.getCodeNameBase())) continue;
                    return null;
                }
                if (clone.isEmpty()) {
                    return this.willEnable;
                }
            }
            return null;
        }

        private <T extends Collection<String>> T readCnbs(DataInputStream dis, T fill) throws IOException {
            int size = dis.readInt();
            if (size == -1) {
                return null;
            }
            while (size-- > 0) {
                fill.add((String)dis.readUTF());
            }
            return fill;
        }

        private void writeCnbs(DataOutputStream os, Collection<String> cnbs) throws IOException {
            if (cnbs == null) {
                os.writeInt(-1);
                return;
            }
            os.writeInt(cnbs.size());
            for (String s : cnbs) {
                os.writeUTF(s);
            }
        }

        private String nonNullBranding() {
            String s = NbBundle.getBranding();
            return s == null ? "" : s;
        }
    }

    private final class SystemClassLoader
    extends JarClassLoader {
        private final PermissionCollection allPermissions;
        int size;
        private final Set<String> JRE_PROVIDED_FACTORIES;

        public SystemClassLoader(List<File> files, ClassLoader[] parents, Set<Module> modules) throws IllegalArgumentException {
            super(files, parents, false);
            this.JRE_PROVIDED_FACTORIES = new HashSet<String>(Arrays.asList("META-INF/services/javax.xml.parsers.SAXParserFactory", "META-INF/services/javax.xml.parsers.DocumentBuilderFactory", "META-INF/services/javax.xml.transform.TransformerFactory", "META-INF/services/javax.xml.validation.SchemaFactory"));
            this.allPermissions = new Permissions();
            this.allPermissions.add(new AllPermission());
            this.allPermissions.setReadOnly();
            this.size = modules.size();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.fine("Collected system class loader");
        }

        public String toString() {
            return "SystemClassLoader[" + this.size + " modules]";
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource cs) {
            return this.allPermissions;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            ClassLoader l;
            if (this.JRE_PROVIDED_FACTORIES.contains(name)) {
                return new ByteArrayInputStream(new byte[0]);
            }
            InputStream is = super.getResourceAsStream(name);
            if (is == null && (l = ModuleManager.this.netigso.findFallbackLoader()) != null && l != this) {
                is = l.getResourceAsStream(name);
            }
            return is;
        }

        @Override
        final URL getResourceImpl(String name) {
            ClassLoader l;
            URL u = super.getResourceImpl(name);
            if (u == null && (l = ModuleManager.this.netigso.findFallbackLoader()) != null && l != this) {
                u = l.getResource(name);
            }
            return u;
        }

        @Override
        synchronized Enumeration<URL> getResourcesImpl(String name) throws IOException {
            if (this.JRE_PROVIDED_FACTORIES.contains(name)) {
                return this.parents.systemCL().getResources(name);
            }
            Enumeration<URL> first = super.getResourcesImpl(name);
            ClassLoader l = ModuleManager.this.netigso.findFallbackLoader();
            if (l != null && l != this) {
                return Enumerations.removeDuplicates((Enumeration)Enumerations.concat(first, l.getResources(name)));
            }
            return first;
        }

        @Override
        protected boolean shouldDelegateResource(String pkg, ClassLoader parent) {
            ClassLoader trueParent = this.getParent();
            boolean parentIsJRE = trueParent != null && trueParent.getClass().getName().equals("com.sun.jnlp.JNLPClassLoader") ? false : (parent == null ? true : parent instanceof MainImpl.BootClassLoader);
            if (parentIsJRE && !ModuleManager.this.installer.shouldDelegateClasspathResource(pkg)) {
                return false;
            }
            return super.shouldDelegateResource(pkg, parent);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            ProxyClassLoader priviledged = null;
            NetigsoLoader osgi = null;
            if (!name.startsWith("java.")) {
                List<Class<?>> stack = Util.getStack();
                for (Class<?> c : stack) {
                    ClassLoader l = c.getClassLoader();
                    if (l == this || l == this.getClass().getClassLoader()) continue;
                    if (l instanceof ProxyClassLoader) {
                        priviledged = (ProxyClassLoader)l;
                        break;
                    }
                    if (!(l instanceof NetigsoLoader)) continue;
                    osgi = (NetigsoLoader)l;
                    break;
                }
            }
            ClassNotFoundException prev = null;
            try {
                if (priviledged != null) {
                    try {
                        return priviledged.loadClass(name, resolve);
                    }
                    catch (ClassNotFoundException inner) {
                        prev = inner;
                    }
                }
                if (osgi != null) {
                    try {
                        return osgi.loadClass(name, resolve);
                    }
                    catch (ClassNotFoundException inner) {
                        prev = inner;
                    }
                }
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException ex) {
                ClassLoader l = ModuleManager.this.netigso.findFallbackLoader();
                if (l == null || l == this) {
                    if (prev != null) {
                        try {
                            ex.initCause(prev);
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    throw ex;
                }
                return Class.forName(name, resolve, l);
            }
        }
    }

    static class EnableContext {
        final List<Module> willEnable;

        public EnableContext(List<Module> willEnable) {
            this.willEnable = willEnable;
        }
    }

    private static class CodeNameBaseComparator
    implements Comparator<Module> {
        private CodeNameBaseComparator() {
        }

        @Override
        public int compare(Module m1, Module m2) {
            return m1.getCodeNameBase().compareTo(m2.getCodeNameBase());
        }
    }
}

