/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.commands;

import com.google.gson.JsonPrimitive;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.BuildPropertiesSupport;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.project.dependency.ProjectReload;
import org.netbeans.spi.lsp.CommandProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class MicronautGetBuildPropertiesCommand
implements CommandProvider {
    private static final String GET_BUILD_PROPERTIES = "nbls.micronaut.get.build.properties";

    public Set<String> getCommands() {
        return Set.of(GET_BUILD_PROPERTIES);
    }

    public CompletableFuture<Object> runCommand(String command, List<Object> arguments) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        if (arguments.size() < 2) {
            future.completeExceptionally(new IllegalStateException("Expecting project URL and property name as arguments to " + command));
        } else {
            try {
                Project prj;
                String uri = ((JsonPrimitive)arguments.get(0)).getAsString();
                String propertyName = ((JsonPrimitive)arguments.get(1)).getAsString();
                String taskName = arguments.size() > 2 ? ((JsonPrimitive)arguments.get(2)).getAsString() : null;
                FileObject fo = URLMapper.findFileObject((URL)URI.create(uri).toURL());
                Project project = prj = fo != null ? FileOwnerQuery.getOwner((FileObject)fo) : null;
                if (prj != null) {
                    ((CompletableFuture)ProjectReload.withProjectState((Project)prj, (ProjectReload.StateRequest)ProjectReload.StateRequest.refresh()).thenRun(() -> {
                        NbMavenProject p = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
                        MavenProject mvnp = p != null ? p.getMavenProject() : null;
                        String value = null;
                        if (mvnp != null) {
                            value = (String)mvnp.getProperties().get(propertyName);
                        } else {
                            BuildPropertiesSupport bps = BuildPropertiesSupport.get((Project)prj);
                            if (bps != null) {
                                BuildPropertiesSupport.Property prop;
                                BuildPropertiesSupport.Property property = prop = taskName != null ? bps.findTaskProperty(taskName, propertyName) : bps.findExtensionProperty(null, propertyName);
                                if (prop != null) {
                                    value = prop.getStringValue();
                                }
                            }
                        }
                        future.complete(value);
                    })).exceptionally(ex -> {
                        future.completeExceptionally((Throwable)ex);
                        return null;
                    });
                } else {
                    future.complete(null);
                }
            }
            catch (MalformedURLException ex2) {
                future.completeExceptionally(ex2);
            }
        }
        return future;
    }
}

