/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.ui.JFXDeploymentPanel;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class JFXDeploymentCategoryProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String CAT_DEPLOYMENT = "Deployment";
    private static final Map<String, JFXProjectProperties> projectProperties = new HashMap<String, JFXProjectProperties>();

    public ProjectCustomizer.Category createCategory(Lookup context) {
        boolean deploymentEnabled = true;
        final Project project = (Project)context.lookup(Project.class);
        if (project != null) {
            J2SEPropertyEvaluator j2sepe = (J2SEPropertyEvaluator)project.getLookup().lookup(J2SEPropertyEvaluator.class);
            String fxEnabled = j2sepe.evaluator().getProperty("javafx.enabled");
            String fxPreloader = j2sepe.evaluator().getProperty("javafx.preloader");
            boolean bl = deploymentEnabled = JFXProjectProperties.isTrue(fxEnabled) && !JFXProjectProperties.isTrue(fxPreloader);
        }
        if (deploymentEnabled) {
            ProjectCustomizer.Category c = ProjectCustomizer.Category.create((String)CAT_DEPLOYMENT, (String)NbBundle.getMessage(JFXDeploymentCategoryProvider.class, (String)"LBL_Category_Deployment"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            c.setOkButtonListener(new ActionListener(){
                final /* synthetic */ JFXDeploymentCategoryProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFXProjectProperties prop;
                    if (project != null && (prop = JFXProjectProperties.getInstanceIfExists(project.getLookup())) != null) {
                        projectProperties.put(project.getProjectDirectory().getPath(), prop);
                    }
                }
            });
            c.setStoreListener(new ActionListener(){
                final /* synthetic */ JFXDeploymentCategoryProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (project != null) {
                        JFXProjectProperties prop = (JFXProjectProperties)projectProperties.get(project.getProjectDirectory().getPath());
                        if (prop != null) {
                            try {
                                prop.store();
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        projectProperties.remove(project.getProjectDirectory().getPath());
                    }
                }
            });
            c.setCloseListener(new ActionListener(){
                final /* synthetic */ JFXDeploymentCategoryProvider this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (project != null) {
                        JFXProjectProperties.cleanup(project.getLookup());
                    }
                }
            });
            return c;
        }
        return null;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        return new JFXDeploymentPanel(JFXProjectProperties.getInstance(context));
    }
}

