/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.fxml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.javafx2.project.fxml.FXMLTemplateWizardIterator;
import org.netbeans.modules.javafx2.project.fxml.SourceGroupSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConfigureFXMLCSSPanelVisual
extends JPanel
implements ActionListener,
DocumentListener {
    private Panel observer;
    private final boolean isMaven;
    private boolean ignoreRootCombo;
    private RequestProcessor.Task updatePackagesTask;
    private static final ComboBoxModel WAIT_MODEL = SourceGroupSupport.getWaitModel();
    SourceGroupSupport support;
    private String previousCssName;
    private ButtonGroup buttonGroup1;
    private JButton chooseButton;
    private JRadioButton createNewRadioButton;
    private JComboBox createdLocationComboBox;
    private JLabel createdLocationLabel;
    private JLabel createdNameLabel;
    private JTextField createdNameTextField;
    private JComboBox createdPackageComboBox;
    private JLabel createdPackageLabel;
    private JCheckBox cssCheckBox;
    private JLabel existingNameLabel;
    private JTextField existingNameTextField;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private Box.Filler filler1;
    private JRadioButton useExistingRadioButton;

    ConfigureFXMLCSSPanelVisual(Panel observer, SourceGroupSupport support, boolean isMaven) {
        this.support = support;
        this.observer = observer;
        this.isMaven = isMaven;
        this.setName(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"TXT_CSSNameAndLoc"));
        this.initComponents();
        this.initComponents2();
    }

    private void fireChange() {
        this.observer.fireChangeEvent();
    }

    private void initComponents2() {
        this.createdNameTextField.getDocument().addDocumentListener(this);
        this.existingNameTextField.getDocument().addDocumentListener(this);
        this.createdPackageComboBox.getEditor().addActionListener(this);
        Component packageEditor = this.createdPackageComboBox.getEditor().getEditorComponent();
        if (packageEditor instanceof JTextField) {
            ((JTextField)packageEditor).getDocument().addDocumentListener(this);
        }
        this.createdLocationComboBox.setRenderer(new SourceGroupSupport.GroupListCellRenderer());
        this.createdPackageComboBox.setRenderer(PackageView.listRenderer());
        this.createdLocationComboBox.addActionListener(this);
    }

    public void initValues(FileObject template, FileObject preselectedFolder) {
        String displayName;
        if (template == null) {
            throw new IllegalArgumentException(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"MSG_ConfigureFXMLPanel_Template_Error"));
        }
        try {
            DataObject templateDo = DataObject.find((FileObject)template);
            displayName = templateDo.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        this.createdLocationComboBox.setModel(new DefaultComboBoxModel<Object>(this.support.getSourceGroups().toArray()));
        SourceGroupSupport.SourceGroupProxy preselectedGroup = this.isMaven ? SourceGroupSupport.getContainingSourceGroup(this.support, preselectedFolder) : this.support.getParent().getCurrentSourceGroup();
        this.ignoreRootCombo = true;
        this.createdLocationComboBox.setSelectedItem(preselectedGroup);
        this.ignoreRootCombo = false;
        if (this.isMaven && this.support.getType().equals("resources")) {
            this.createdPackageComboBox.getEditor().setItem("styles");
        } else {
            this.createdPackageComboBox.getEditor().setItem(this.support.getParent().getCurrentPackageName());
        }
        this.updatePackages();
        this.updateText();
        this.updateResult();
    }

    boolean isCSSEnabled() {
        return this.cssCheckBox.isSelected();
    }

    public FileObject getLocationFolder() {
        Object selectedItem = this.createdLocationComboBox.getSelectedItem();
        return selectedItem instanceof SourceGroupSupport.SourceGroupProxy ? ((SourceGroupSupport.SourceGroupProxy)selectedItem).getRootFolder() : null;
    }

    public String getPackageFileName() {
        String packageName = this.createdPackageComboBox.getEditor().getItem().toString();
        return packageName.replace('.', '/');
    }

    String getPackageName() {
        return this.createdPackageComboBox.getEditor().getItem().toString();
    }

    String getNewCSSName() {
        String text = this.createdNameTextField.getText().trim();
        return text.length() == 0 ? null : text;
    }

    String getExistingCSSName() {
        String text = this.existingNameTextField.getText().trim();
        return text.length() == 0 ? null : text;
    }

    private void radioButtonsStateChanged() {
        if (!this.cssCheckBox.isSelected()) {
            return;
        }
        this.createdNameLabel.setEnabled(this.createNewRadioButton.isSelected());
        this.createdNameTextField.setEnabled(this.createNewRadioButton.isSelected());
        this.existingNameLabel.setEnabled(!this.createNewRadioButton.isSelected());
        this.existingNameTextField.setEnabled(!this.createNewRadioButton.isSelected());
        this.chooseButton.setEnabled(!this.createNewRadioButton.isSelected());
        this.createdLocationLabel.setEnabled(this.createNewRadioButton.isSelected());
        this.createdLocationComboBox.setEnabled(this.createNewRadioButton.isSelected());
        this.createdPackageLabel.setEnabled(this.createNewRadioButton.isSelected());
        this.createdPackageComboBox.setEnabled(this.createNewRadioButton.isSelected());
        this.updateResult();
        this.fireChange();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.createNewRadioButton = new JRadioButton();
        this.cssCheckBox = new JCheckBox();
        this.createdNameLabel = new JLabel();
        this.createdNameTextField = new JTextField();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.createdLocationLabel = new JLabel();
        this.createdLocationComboBox = new JComboBox();
        this.createdPackageLabel = new JLabel();
        this.createdPackageComboBox = new JComboBox();
        this.useExistingRadioButton = new JRadioButton();
        this.existingNameLabel = new JLabel();
        this.existingNameTextField = new JTextField();
        this.chooseButton = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setPreferredSize(new Dimension(500, 340));
        this.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.createNewRadioButton);
        this.createNewRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createNewRadioButton, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.createNewRadioButton.text"));
        this.createNewRadioButton.setEnabled(false);
        this.createNewRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureFXMLCSSPanelVisual.this.createNewRadioButtonItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        this.add((Component)this.createNewRadioButton, gridBagConstraints);
        this.createNewRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.createNewRadioButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.cssCheckBox, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.cssCheckBox.text"));
        this.cssCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureFXMLCSSPanelVisual.this.cssCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 1280;
        this.add((Component)this.cssCheckBox, gridBagConstraints);
        this.cssCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.cssCheckBox.AccessibleContext.accessibleDescription"));
        this.createdNameLabel.setLabelFor(this.createdNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdNameLabel, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.createdNameLabel.text"));
        this.createdNameLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this.createdNameLabel, gridBagConstraints);
        this.createdNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.createdNameLabel.AccessibleContext.accessibleDescription"));
        this.createdNameTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.createdNameTextField, gridBagConstraints);
        this.fileLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.fileLabel.text"));
        this.fileLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(25, 15, 0, 0);
        this.add((Component)this.fileLabel, gridBagConstraints);
        this.fileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.fileLabel.AccessibleContext.accessibleDescription"));
        this.fileTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.createdLocationLabel.setLabelFor(this.createdLocationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.createdLocationLabel, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.createdLocationLabel.text"));
        this.createdLocationLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 40, 0, 0);
        this.add((Component)this.createdLocationLabel, gridBagConstraints);
        this.createdLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.createdLocationLabel.AccessibleContext.accessibleDescription"));
        this.createdLocationComboBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.createdLocationComboBox, gridBagConstraints);
        this.createdPackageLabel.setLabelFor(this.createdPackageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.createdPackageLabel, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.createdPackageLabel.text"));
        this.createdPackageLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 40, 0, 0);
        this.add((Component)this.createdPackageLabel, gridBagConstraints);
        this.createdPackageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.createdPackageLabel.AccessibleContext.accessibleDescription"));
        this.createdPackageComboBox.setEditable(true);
        this.createdPackageComboBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.createdPackageComboBox, gridBagConstraints);
        this.buttonGroup1.add(this.useExistingRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.useExistingRadioButton, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.useExistingRadioButton.text"));
        this.useExistingRadioButton.setEnabled(false);
        this.useExistingRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureFXMLCSSPanelVisual.this.useExistingRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this.add((Component)this.useExistingRadioButton, gridBagConstraints);
        this.useExistingRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.useExistingRadioButton.AccessibleContext.accessibleDescription"));
        this.existingNameLabel.setLabelFor(this.existingNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.existingNameLabel, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.existingNameLabel.text"));
        this.existingNameLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this.existingNameLabel, gridBagConstraints);
        this.existingNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.existingNameLabel.AccessibleContext.accessibleDescription"));
        this.existingNameTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.existingNameTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chooseButton, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.chooseButton.text"));
        this.chooseButton.setEnabled(false);
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureFXMLCSSPanelVisual.this.chooseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.chooseButton, gridBagConstraints);
        this.chooseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.chooseButton.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.filler1, gridBagConstraints);
    }

    private void cssCheckBoxItemStateChanged(ItemEvent evt) {
        this.createNewRadioButton.setEnabled(this.cssCheckBox.isSelected());
        if (this.createNewRadioButton.isSelected()) {
            this.createdNameLabel.setEnabled(this.cssCheckBox.isSelected());
            this.createdNameTextField.setEnabled(this.cssCheckBox.isSelected());
            this.createdLocationLabel.setEnabled(this.cssCheckBox.isSelected());
            this.createdLocationComboBox.setEnabled(this.cssCheckBox.isSelected());
            this.createdPackageLabel.setEnabled(this.cssCheckBox.isSelected());
            this.createdPackageComboBox.setEnabled(this.cssCheckBox.isSelected());
        }
        this.useExistingRadioButton.setEnabled(this.cssCheckBox.isSelected());
        if (this.useExistingRadioButton.isSelected()) {
            this.existingNameLabel.setEnabled(this.cssCheckBox.isSelected());
            this.existingNameTextField.setEnabled(this.cssCheckBox.isSelected());
            this.chooseButton.setEnabled(this.cssCheckBox.isSelected());
        }
        this.fileLabel.setEnabled(this.cssCheckBox.isSelected());
        this.updateResult();
        this.fireChange();
    }

    private void chooseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(new FXMLTemplateWizardIterator.SrcFileSystemView(this.support.getSourceGroupsAsFiles()));
        chooser.setDialogTitle(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"LBL_ConfigureFXMLPanel_FileChooser_Select_CSS"));
        chooser.setFileFilter(FXMLTemplateWizardIterator.FXMLTemplateFileFilter.createCSSFilter());
        String existingPath = this.existingNameTextField.getText();
        if (existingPath.length() > 0) {
            File f = new File(this.support.getCurrentChooserFolder().getPath() + File.pathSeparator + existingPath);
            if (f.exists()) {
                chooser.setSelectedFile(f);
            } else {
                chooser.setCurrentDirectory(FileUtil.toFile((FileObject)this.support.getCurrentChooserFolder()));
            }
        } else {
            chooser.setCurrentDirectory(FileUtil.toFile((FileObject)this.support.getCurrentChooserFolder()));
        }
        if (0 == chooser.showOpenDialog(this)) {
            String cssFile = FileUtil.normalizeFile((File)chooser.getSelectedFile()).getPath();
            String srcPath = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)this.support.getCurrentSourceGroupFolder())).getPath();
            String relativePath = cssFile.substring(srcPath.length() + 1);
            this.existingNameTextField.setText(relativePath);
        }
    }

    private void createNewRadioButtonItemStateChanged(ItemEvent evt) {
        this.radioButtonsStateChanged();
    }

    private void useExistingRadioButtonItemStateChanged(ItemEvent evt) {
        this.radioButtonsStateChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.createdLocationComboBox == e.getSource()) {
            if (!this.ignoreRootCombo) {
                this.updatePackages();
            }
            this.updateText();
            this.updateResult();
            this.fireChange();
        } else if (this.createdPackageComboBox == e.getSource()) {
            this.updateText();
            this.updateResult();
            this.fireChange();
        } else if (this.createdPackageComboBox.getEditor() == e.getSource()) {
            this.updateText();
            this.updateResult();
            this.fireChange();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateResult();
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private void updatePackages() {
        final Object item = this.createdLocationComboBox.getSelectedItem();
        if (!(item instanceof SourceGroupSupport.SourceGroupProxy)) {
            return;
        }
        WAIT_MODEL.setSelectedItem(this.createdPackageComboBox.getEditor().getItem());
        this.createdPackageComboBox.setModel(WAIT_MODEL);
        if (this.updatePackagesTask != null) {
            this.updatePackagesTask.cancel();
        }
        this.updatePackagesTask = new RequestProcessor("ComboUpdatePackages").post(new Runnable(){
            final /* synthetic */ ConfigureFXMLCSSPanelVisual this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                final ComboBoxModel model = ((SourceGroupSupport.SourceGroupProxy)item).getPackagesComboBoxModel();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        model.setSelectedItem(this.this$1.this$0.createdPackageComboBox.getEditor().getItem());
                        this.this$1.this$0.createdPackageComboBox.setModel(model);
                    }
                });
            }
        });
    }

    private void updateText() {
        String cssName = this.getNewCSSName();
        if (cssName == null || cssName.equals(this.previousCssName)) {
            cssName = this.support.getParent().getCurrentFileName().toLowerCase() + ".css";
            this.createdNameTextField.setText(cssName);
            this.previousCssName = cssName;
        }
    }

    private void updateResult() {
        String cssName;
        String string = cssName = this.shouldCreateCSS() ? this.getNewCSSName() : this.getExistingCSSName();
        if (cssName == null) {
            this.fileTextField.setText(null);
            return;
        }
        if (this.shouldCreateCSS()) {
            String createdFileName;
            Object selectedItem = this.createdLocationComboBox.getSelectedItem();
            if (selectedItem instanceof SourceGroupSupport.SourceGroupProxy) {
                SourceGroupSupport.SourceGroupProxy g = (SourceGroupSupport.SourceGroupProxy)selectedItem;
                String packageName = this.getPackageName();
                this.support.setCurrentSourceGroup(g);
                this.support.setCurrentPackageName(packageName);
                this.support.setCurrentFileName(cssName);
                String path = this.support.getCurrentPackagePath();
                createdFileName = path == null ? "" : path.replace(".", "/") + cssName;
            } else {
                createdFileName = "";
            }
            this.fileTextField.setText(createdFileName.replace('/', File.separatorChar));
        } else {
            this.fileTextField.setText(this.getPathForExistingCSS(cssName));
        }
    }

    private String getPathForExistingCSS(String cssName) {
        assert (cssName != null);
        if (cssName.toLowerCase().endsWith(".css")) {
            String stripped = cssName.substring(0, cssName.length() - ".css".length());
            cssName = stripped.replace('.', File.separatorChar) + ".css";
        }
        return FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)this.support.getCurrentSourceGroupFolder())).getPath() + File.separatorChar + cssName;
    }

    String isCSSValid() {
        if (!this.isCSSEnabled()) {
            return null;
        }
        if (this.createNewRadioButton.isSelected()) {
            return FXMLTemplateWizardIterator.canUseFileName(FileUtil.toFile((FileObject)this.support.getCurrentChooserFolder()), this.getNewCSSName());
        }
        if (this.existingNameTextField.getText().isEmpty()) {
            return NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"WARN_ConfigureFXMLPanel_Provide_CSS_Name");
        }
        return FXMLTemplateWizardIterator.fileExist(this.getPathForExistingCSS(this.getExistingCSSName()));
    }

    boolean shouldCreateCSS() {
        return this.cssCheckBox.isSelected() && this.createNewRadioButton.isSelected();
    }

    static class Panel
    implements WizardDescriptor.Panel<WizardDescriptor>,
    WizardDescriptor.FinishablePanel<WizardDescriptor> {
        private ConfigureFXMLCSSPanelVisual component;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private WizardDescriptor settings;
        SourceGroupSupport support;

        public Panel(SourceGroupSupport support, boolean isMaven) {
            this.support = support;
            this.component = new ConfigureFXMLCSSPanelVisual(this, support, isMaven);
        }

        public Component getComponent() {
            return this.component;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public void readSettings(WizardDescriptor settings) {
            this.settings = settings;
            FileObject preselectedFolder = Templates.getTargetFolder((WizardDescriptor)settings);
            this.component.initValues(Templates.getTemplate((WizardDescriptor)settings), preselectedFolder);
            Object substitute = this.component.getClientProperty("NewFileWizard_Title");
            if (substitute != null) {
                settings.putProperty("NewFileWizard_Title", substitute);
            }
        }

        public void storeSettings(WizardDescriptor settings) {
            Object value = settings.getValue();
            if (WizardDescriptor.PREVIOUS_OPTION.equals(value) || WizardDescriptor.CANCEL_OPTION.equals(value) || WizardDescriptor.CLOSED_OPTION.equals(value)) {
                return;
            }
            if (this.isValid()) {
                settings.putProperty("cssEnabled", (Object)this.component.isCSSEnabled());
                settings.putProperty("CSS", this.component.shouldCreateCSS() ? this.component.getNewCSSName() : null);
                settings.putProperty("CSSExisting", (Object)this.component.getExistingCSSName());
            }
            settings.putProperty("NewFileWizard_Title", null);
        }

        public boolean isValid() {
            if (this.component.isCSSEnabled()) {
                if (!FXMLTemplateWizardIterator.isValidPackageName(this.component.getPackageName())) {
                    FXMLTemplateWizardIterator.setErrorMessage("WARN_ConfigureFXMLPanel_Provide_Package_Name", this.settings);
                    return false;
                }
                if (!FXMLTemplateWizardIterator.isValidPackage(this.component.getLocationFolder(), this.component.getPackageName())) {
                    FXMLTemplateWizardIterator.setErrorMessage("WARN_ConfigureFXMLPanel_Package_Invalid", this.settings);
                    return false;
                }
                String errorMessage = this.component.isCSSValid();
                this.settings.getNotificationLineSupport().setErrorMessage(errorMessage);
                return errorMessage == null;
            }
            this.settings.getNotificationLineSupport().setErrorMessage(null);
            return true;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        private void fireChangeEvent() {
            this.changeSupport.fireChange();
        }

        public boolean isFinishPanel() {
            return true;
        }
    }
}

