/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.cos;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.DirectoryScanner;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.spi.cos.CompileOnSaveSkipper;
import org.openide.filesystems.FileUtil;

public class FilteredResourcesCoSSkipper
implements CompileOnSaveSkipper {
    public static final String[] DEFAULT_INCLUDES = new String[]{"**"};

    @Override
    public boolean skip(RunConfig config, boolean includingTests, long timeStamp) {
        List res = config.getMavenProject().getResources();
        for (Resource r : res) {
            if (!r.isFiltering() || !this.hasChangedResources(r, timeStamp)) continue;
            return true;
        }
        if (includingTests) {
            res = config.getMavenProject().getTestResources();
            for (Resource r : res) {
                if (!r.isFiltering() || !this.hasChangedResources(r, timeStamp)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasChangedResources(Resource r, long stamp) {
        String dir = r.getDirectory();
        File dirFile = FileUtil.normalizeFile((File)new File(dir));
        if (dirFile.exists()) {
            String[] inclds;
            ArrayList<File> toCopy = new ArrayList<File>();
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(dirFile);
            String[] incls = r.getIncludes().toArray(new String[0]);
            if (incls.length > 0) {
                ds.setIncludes(incls);
            } else {
                ds.setIncludes(DEFAULT_INCLUDES);
            }
            String[] excls = r.getExcludes().toArray(new String[0]);
            if (excls.length > 0) {
                ds.setExcludes(excls);
            }
            ds.addDefaultExcludes();
            ds.scan();
            for (String inc : inclds = ds.getIncludedFiles()) {
                File f = new File(dirFile, inc);
                if (f.lastModified() < stamp) continue;
                toCopy.add(FileUtil.normalizeFile((File)f));
            }
            if (toCopy.size() > 0) {
                return true;
            }
        }
        return false;
    }
}

