/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.javahint;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.WizardUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.javahint.Bundle;
import org.netbeans.modules.apisupport.project.ui.wizard.javahint.NewJavaHintIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class JavaHintLocationPanel
extends BasicWizardIterator.Panel {
    private final NewJavaHintIterator.DataModel data;
    private JTextField className;
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JScrollPane createdFilesValueS;
    private JLabel jLabel1;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JScrollPane modifiedFilesValueS;
    private JComboBox packageName;
    private JLabel packageNameTxt;

    JavaHintLocationPanel(WizardDescriptor wiz, NewJavaHintIterator.DataModel data) {
        super(wiz);
        this.data = data;
        this.initComponents();
        this.readFromDataModel();
        this.packageName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaHintLocationPanel.this.updateData();
            }
        });
        this.className.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JavaHintLocationPanel.this.updateData();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JavaHintLocationPanel.this.updateData();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.className = new JTextField();
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.createdFilesValueS = new JScrollPane();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValueS = new JScrollPane();
        this.modifiedFilesValue = new JTextArea();
        this.packageName = WizardUtils.createPackageComboBox(this.data.getSourceRootGroup());
        this.packageNameTxt = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.className);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(JavaHintLocationPanel.class, (String)"JavaHintLocationPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add(this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add(this.className, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/javahint/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)bundle.getString("JavaHintLocationPanel.createdFiles.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add(this.createdFiles, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)bundle.getString("JavaHintLocationPanel.modifiedFiles.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.modifiedFiles, gridBagConstraints);
        this.createdFilesValueS.setBorder(null);
        this.createdFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setEditable(false);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setBorder(null);
        this.createdFilesValueS.setViewportView(this.createdFilesValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.add(this.createdFilesValueS, gridBagConstraints);
        this.modifiedFilesValueS.setBorder(null);
        this.modifiedFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setEditable(false);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText(NbBundle.getMessage(JavaHintLocationPanel.class, (String)"JavaHintLocationPanel.modifiedFilesValue.toolTipText"));
        this.modifiedFilesValue.setBorder(null);
        this.modifiedFilesValueS.setViewportView(this.modifiedFilesValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add(this.modifiedFilesValueS, gridBagConstraints);
        this.packageName.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.packageName, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.packageNameTxt, (String)NbBundle.getMessage(JavaHintLocationPanel.class, (String)"JavaHintLocationPanel.packageNameTxt.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.packageNameTxt, gridBagConstraints);
    }

    @Override
    protected String getPanelName() {
        return Bundle.LBL_NewJavaHintLocation();
    }

    private void updateData() {
        this.storeToDataModel();
        this.createdFilesValue.setText(WizardUtils.generateTextAreaContent(this.data.getCreatedModifiedFiles().getCreatedPaths()));
        this.modifiedFilesValue.setText(WizardUtils.generateTextAreaContent(this.data.getCreatedModifiedFiles().getModifiedPaths()));
        if (this.data.getClassName().isEmpty()) {
            this.setError(Bundle.ERR_NoClassName());
        } else {
            this.markValid();
        }
    }

    @Override
    protected void storeToDataModel() {
        this.data.setPackageName(this.packageName.getEditor().getItem().toString());
        this.data.setClassName(this.className.getText());
        NewJavaHintIterator.generateFileChanges(this.data);
    }

    @Override
    protected void readFromDataModel() {
        this.packageName.setSelectedItem(this.data.getPackageName());
        this.className.setText(this.data.getClassName());
    }

    @Override
    protected HelpCtx getHelp() {
        return null;
    }
}

