/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.navigator.base;

import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.text.navigator.base.AbstractXMLNavigatorContent;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class AbstractXMLNavigatorPanel
implements NavigatorPanel {
    protected AbstractXMLNavigatorContent navigator;
    protected Lookup.Result selection;
    protected final LookupListener selectionListener = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AbstractXMLNavigatorPanel.this.selection == null) {
                        return;
                    }
                    AbstractXMLNavigatorPanel.this.navigate(AbstractXMLNavigatorPanel.this.selection.allInstances());
                }
            });
        }
    };

    public abstract String getDisplayHint();

    public abstract String getDisplayName();

    protected abstract AbstractXMLNavigatorContent getNavigatorUI();

    public JComponent getComponent() {
        return this.getNavigatorUI();
    }

    public Lookup getLookup() {
        return null;
    }

    public void panelActivated(Lookup context) {
        this.getNavigatorUI().showWaitNode();
        this.selection = context.lookup(new Lookup.Template(DataObject.class));
        this.selection.addLookupListener(this.selectionListener);
        this.selectionListener.resultChanged(null);
    }

    public void panelDeactivated() {
        this.getNavigatorUI().showWaitNode();
        if (this.selection != null) {
            this.selection.removeLookupListener(this.selectionListener);
            this.selection = null;
        }
        if (this.navigator != null) {
            this.navigator.release();
        }
    }

    public void navigate(Collection selectedFiles) {
        if (selectedFiles.size() == 1) {
            DataObject d = (DataObject)selectedFiles.iterator().next();
            this.navigator.navigate(d);
        }
    }
}

