/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.breadcrumbs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.xml.text.breadcrumbs.BreadcrumbProvider;
import org.openide.util.Exceptions;

public final class EditorRegistryMonitor
implements PropertyChangeListener,
Runnable {
    private Reference<BreadcrumbProvider> currentProvider;

    @Override
    public void run() {
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "focusGained": {
                this.componentActivated((JTextComponent)evt.getNewValue());
                break;
            }
            case "focusedDocument": {
                this.updateBreadcrumbs();
            }
        }
    }

    private void updateBreadcrumbs() {
        BreadcrumbProvider p = this.currentProvider();
        if (p == null) {
            return;
        }
        p.update();
    }

    private DocumentModel findTextModel(JTextComponent comp) {
        String mime = DocumentUtilities.getMimeType((JTextComponent)comp);
        MimePath mp = MimePath.parse((String)mime);
        if (!"text/xml".equals(mp.getInheritedType())) {
            return null;
        }
        try {
            DocumentModel mod = DocumentModel.getDocumentModel((Document)comp.getDocument());
            return mod;
        }
        catch (DocumentModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private BreadcrumbProvider currentProvider() {
        Reference<BreadcrumbProvider> c = this.currentProvider;
        if (c == null) {
            return null;
        }
        return c.get();
    }

    private void componentActivated(JTextComponent comp) {
        BreadcrumbProvider c = this.currentProvider();
        if (c != null) {
            c.release();
        }
        this.currentProvider = null;
        if (this.findTextModel(comp) == null) {
            return;
        }
        BreadcrumbProvider p = new BreadcrumbProvider(comp);
        this.currentProvider = new WeakReference<BreadcrumbProvider>(p);
        p.update();
    }
}

