/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.breadcrumbs;

import java.awt.Image;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsController;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsElement;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentElementEvent;
import org.netbeans.modules.editor.structure.api.DocumentElementListener;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.xml.text.breadcrumbs.Bundle;
import org.openide.cookies.OpenCookie;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

final class BreadcrumbProvider
implements CaretListener {
    private final JTextComponent pane;
    private Map<DocumentElement, Reference<XE>> nodes = new WeakHashMap<DocumentElement, Reference<XE>>();
    private static final String TAG_16 = "org/netbeans/modules/xml/text/navigator/resources/tag.png";
    private static final String PI_16 = "org/netbeans/modules/xml/text/navigator/resources/xml_declaration.png";
    private static final String DOCTYPE_16 = "org/netbeans/modules/xml/text/navigator/resources/doc_type.png";
    private static final String CDATA_16 = "org/netbeans/modules/xml/text/navigator/resources/cdata.png";

    public BreadcrumbProvider(JTextComponent pane) {
        this.pane = pane;
        pane.addCaretListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        this.pane.removeCaretListener(this);
        BreadcrumbProvider breadcrumbProvider = this;
        synchronized (breadcrumbProvider) {
            this.nodes.clear();
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.update();
    }

    private synchronized XE createElement(DocumentElement el, XE parent) {
        XE node;
        Reference<XE> e = this.nodes.get(el);
        if (e != null && (node = e.get()) != null) {
            return node;
        }
        node = new XE(el, parent);
        this.nodes.put(el, new WeakReference<XE>(node));
        return node;
    }

    void update() {
        DocumentElement el;
        if (!this.pane.isVisible()) {
            return;
        }
        int pos = this.pane.getCaret().getDot();
        Document doc = this.pane.getDocument();
        try {
            DocumentModel mdl = DocumentModel.getDocumentModel((Document)doc);
        }
        catch (DocumentModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        block12: for (el = mdl.getLeafElementForOffset(pos); el != null; el = el.getParentElement()) {
            switch (el.getType()) {
                case "tag": 
                case "empty_tag": 
                case "pi": 
                case "cdata": 
                case "doctype": {
                    break block12;
                }
                default: {
                    continue block12;
                }
            }
        }
        if (el == null) {
            return;
        }
        LinkedList<DocumentElement> path = new LinkedList<DocumentElement>();
        while (el != null) {
            path.addFirst(el);
            el = el.getParentElement();
        }
        XE node = null;
        for (DocumentElement x : path) {
            node = this.createElement(x, node);
        }
        BreadcrumbsController.setBreadcrumbs((Document)doc, node);
    }

    private class XE
    implements BreadcrumbsElement,
    DocumentElementListener,
    OpenCookie {
        private final DocumentElement docEl;
        private final XE parent;
        private volatile List<BreadcrumbsElement> children;

        public XE(DocumentElement docEl, XE parent) {
            this.docEl = docEl;
            this.parent = parent;
            docEl.addDocumentElementListener((DocumentElementListener)WeakListeners.create(DocumentElementListener.class, (EventListener)((Object)this), (Object)docEl));
        }

        public void elementAdded(DocumentElementEvent e) {
            this.invalidate();
        }

        public void elementRemoved(DocumentElementEvent e) {
            this.invalidate();
        }

        public void childrenReordered(DocumentElementEvent e) {
            this.invalidate();
        }

        public void contentChanged(DocumentElementEvent e) {
            this.invalidate();
        }

        public void attributesChanged(DocumentElementEvent e) {
            this.invalidate();
        }

        public String getHtmlDisplayName() {
            switch (this.docEl.getType()) {
                case "tag": 
                case "empty_tag": {
                    return this.docEl.getName();
                }
                case "pi": {
                    return this.docEl.getName();
                }
                case "cdata": {
                    return Bundle.LABEL_CDATA();
                }
                case "doctype": {
                    return Bundle.LABEL_DOCTYPE();
                }
            }
            throw new IllegalArgumentException();
        }

        public Image getIcon(int type) {
            String resource;
            if (type != 1) {
                return null;
            }
            switch (this.docEl.getType()) {
                case "tag": 
                case "empty_tag": {
                    resource = BreadcrumbProvider.TAG_16;
                    break;
                }
                case "pi": {
                    resource = BreadcrumbProvider.PI_16;
                    break;
                }
                case "cdata": {
                    resource = BreadcrumbProvider.CDATA_16;
                    break;
                }
                case "doctype": {
                    resource = BreadcrumbProvider.DOCTYPE_16;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return ImageUtilities.loadImage((String)resource, (boolean)true);
        }

        public Image getOpenedIcon(int type) {
            if (type != 1) {
                return null;
            }
            return this.getIcon(type);
        }

        private void invalidate() {
            this.children = null;
        }

        public void open() {
            int offset = this.docEl.getStartOffset();
            if (BreadcrumbProvider.this.pane.getDocument().getLength() >= offset) {
                BreadcrumbProvider.this.pane.getCaret().setDot(offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<BreadcrumbsElement> getChildren() {
            if (this.children != null) {
                return this.children;
            }
            ArrayList<BreadcrumbsElement> children = new ArrayList<BreadcrumbsElement>();
            block13: for (DocumentElement ch : this.docEl.getChildren()) {
                switch (ch.getType()) {
                    case "tag": 
                    case "empty_tag": 
                    case "pi": 
                    case "cdata": 
                    case "doctype": {
                        children.add(BreadcrumbProvider.this.createElement(ch, this));
                        continue block13;
                    }
                }
            }
            XE xE = this;
            synchronized (xE) {
                if (this.children == null) {
                    this.children = children;
                }
            }
            return children;
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public BreadcrumbsElement getParent() {
            return this.parent;
        }
    }
}

