/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.packets.BrkpntSetCommand;

public class FunctionBreakpoint
extends AbstractBreakpoint {
    private final Type myType;
    private final String myFunctionName;

    public FunctionBreakpoint(Type type, String functionName) {
        this.myType = type;
        this.myFunctionName = functionName;
    }

    public Type getType() {
        return this.myType;
    }

    public String getFunction() {
        return this.myFunctionName;
    }

    @Override
    public boolean isSessionRelated(DebugSession session) {
        return true;
    }

    public static enum Type {
        CALL(BrkpntSetCommand.Types.CALL),
        RETURN(BrkpntSetCommand.Types.RETURN);

        private final BrkpntSetCommand.Types myType;

        private Type(BrkpntSetCommand.Types type) {
            this.myType = type;
        }

        public BrkpntSetCommand.Types getType() {
            return this.myType;
        }

        public static Type forType(BrkpntSetCommand.Types type) {
            Type[] types;
            for (Type typ : types = Type.values()) {
                if (type != typ.getType()) continue;
                return typ;
            }
            return null;
        }

        public static Type forString(String str) {
            for (Type type : Type.values()) {
                if (!type.toString().equals(str)) continue;
                return type;
            }
            return null;
        }
    }
}

