/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.amazon.ui.serverplugin;

import java.awt.Component;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cloud.amazon.AmazonInstance;
import org.netbeans.modules.cloud.amazon.serverplugin.AmazonJ2EEInstance;
import org.netbeans.modules.cloud.amazon.serverplugin.AmazonJ2EEServerInstanceProvider;
import org.netbeans.modules.cloud.amazon.ui.serverplugin.AmazonJ2EEServerWizardComponent;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AmazonJ2EEServerWizardPanel
implements WizardDescriptor.AsynchronousValidatingPanel<WizardDescriptor> {
    public static final String KEY_ID = "access-key-id";
    public static final String KEY = "secret-access-key";
    private AmazonJ2EEServerWizardComponent component;
    private WizardDescriptor wd;
    private ChangeSupport listeners = new ChangeSupport((Object)this);

    public Component getComponent() {
        return this.getComponentImpl();
    }

    AmazonJ2EEServerWizardComponent getComponentImpl() {
        if (this.component == null) {
            this.component = new AmazonJ2EEServerWizardComponent(this, (String)this.wd.getProperty("suggested-name"), null);
            this.component.putClientProperty("WizardPanel_contentData", AmazonJ2EEServerWizardPanel.getPanelContentData());
            this.component.init();
        }
        return this.component;
    }

    private static String[] getPanelContentData() {
        return new String[]{NbBundle.getMessage(AmazonJ2EEServerWizardPanel.class, (String)"AmazonJ2EEServerWizardDescriptor.name")};
    }

    public HelpCtx getHelp() {
        return new HelpCtx(AmazonJ2EEServerWizardPanel.class.getName());
    }

    public void readSettings(WizardDescriptor settings) {
        this.wd = settings;
    }

    public void storeSettings(WizardDescriptor settings) {
    }

    public void setErrorMessage(String message) {
        this.wd.putProperty("WizardPanel_errorMessage", (Object)message);
    }

    public boolean isValid() {
        if (!this.getComponentImpl().hasAccount()) {
            this.setErrorMessage(NbBundle.getMessage(AmazonJ2EEServerWizardPanel.class, (String)"AmazonJ2EEServerWizardPanel.missingAccount"));
            return false;
        }
        if (this.getComponentImpl().getApplicationName().length() == 0) {
            this.setErrorMessage(NbBundle.getMessage(AmazonJ2EEServerWizardPanel.class, (String)"AmazonJ2EEServerWizardPanel.missingAppName"));
            return false;
        }
        if (this.getComponentImpl().getEnvironmentName().length() == 0) {
            this.setErrorMessage(NbBundle.getMessage(AmazonJ2EEServerWizardPanel.class, (String)"AmazonJ2EEServerWizardPanel.missingEnvName"));
            return false;
        }
        if (this.getComponentImpl().getURL().length() == 0) {
            this.setErrorMessage(NbBundle.getMessage(AmazonJ2EEServerWizardPanel.class, (String)"AmazonJ2EEServerWizardPanel.missingUrl"));
            return false;
        }
        if (this.getComponentImpl().getEnvironmentName().length() < 4 || this.getComponentImpl().getEnvironmentName().length() > 23) {
            this.setErrorMessage(NbBundle.getMessage(AmazonJ2EEServerWizardPanel.class, (String)"AmazonJ2EEServerWizardPanel.envNameLength"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.removeChangeListener(l);
    }

    void fireChange() {
        this.listeners.fireChange();
    }

    public void prepareValidation() {
    }

    public void validate() throws WizardValidationException {
        String appName = this.getComponentImpl().getApplicationName();
        String envName = this.getComponentImpl().getEnvironmentName();
        String url = this.getComponentImpl().getURL();
        List<AmazonJ2EEInstance> list = this.getComponentImpl().getAmazonInstance().readJ2EEServerInstances();
        for (AmazonJ2EEInstance ins : list) {
            if (!ins.getApplicationName().equals(appName) || !ins.getEnvironmentName().equals(envName)) continue;
            throw new WizardValidationException((JComponent)this.getComponentImpl(), "app/env already exist", NbBundle.getMessage(AmazonJ2EEServerWizardPanel.class, (String)"AmazonJ2EEServerWizardPanel.validation1", (Object)appName, (Object)envName));
        }
        if (!this.getComponentImpl().getAmazonInstance().checkURLValidity(url)) {
            throw new WizardValidationException((JComponent)this.getComponentImpl(), "url already exist", NbBundle.getMessage(AmazonJ2EEServerWizardPanel.class, (String)"AmazonJ2EEServerWizardPanel.validation2", (Object)url));
        }
    }

    private boolean isNewApp(AmazonInstance ai, String appName) {
        return !ai.readApplicationNames().contains(appName);
    }

    public InstanceProperties createServer() {
        String envID = this.createAppEnv();
        try {
            AmazonJ2EEServerInstanceProvider.getProvider().refreshServers().get();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return this.findServer(envID);
    }

    private String createAppEnv() {
        String appName = this.getComponentImpl().getApplicationName();
        String envName = this.getComponentImpl().getEnvironmentName();
        String url = this.getComponentImpl().getURL();
        String containerType = this.getComponentImpl().getContainerType();
        String template = this.getComponentImpl().getTemplateName();
        AmazonInstance ai = this.getComponentImpl().getAmazonInstance();
        boolean newApp = this.isNewApp(ai, appName);
        if (newApp) {
            ai.createApplication(appName);
            ai.createInitialEmptyApplication(appName);
        }
        return ai.createEnvironment(appName, envName, url, containerType, template);
    }

    private InstanceProperties findServer(String envID) {
        String appName = this.getComponentImpl().getApplicationName();
        String containerType = this.getComponentImpl().getContainerType();
        String uri = AmazonJ2EEInstance.createURL(appName, envID, containerType);
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)uri);
        assert (ip != null) : "cannot find instance for " + uri;
        return ip;
    }
}

