/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.jsch.agentproxy;

import com.jcraft.jsch.AgentConnector;
import com.jcraft.jsch.PageantConnector;
import com.jcraft.jsch.SSHAgentConnector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectorFactory {
    private static ConnectorFactory instance;
    private static final Logger LOG;

    private ConnectorFactory() {
    }

    public static synchronized ConnectorFactory getInstance() {
        if (instance == null) {
            instance = new ConnectorFactory();
        }
        return instance;
    }

    public AgentConnector createConnector(ConnectorKind preferredKind) {
        SSHAgentConnector agentConnector = null;
        if (agentConnector == null) {
            try {
                if (!(preferredKind != ConnectorKind.ANY && preferredKind != ConnectorKind.SSH_AGENT || (agentConnector = new SSHAgentConnector()).isAvailable())) {
                    agentConnector = null;
                }
            }
            catch (Throwable ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        if (agentConnector == null) {
            try {
                if (!(preferredKind != ConnectorKind.ANY && preferredKind != ConnectorKind.PAGEANT || (agentConnector = new PageantConnector()).isAvailable())) {
                    agentConnector = null;
                }
            }
            catch (Throwable ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        if (agentConnector != null) {
            LOG.log(Level.FINE, "AgentConnector: {0} / {1}", new Object[]{agentConnector.getName(), agentConnector.getClass().getName()});
        } else {
            LOG.log(Level.FINE, "AgentConnector: none found");
        }
        return agentConnector;
    }

    static {
        LOG = Logger.getLogger(ConnectorFactory.class.getName());
    }

    public static enum ConnectorKind {
        ANY,
        PAGEANT,
        SSH_AGENT;

    }
}

