/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.modules.java.openjdk.project.JDKProject;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;

public class BinaryForSourceQueryImpl
implements BinaryForSourceQueryImplementation {
    private static final Logger LOG = Logger.getLogger(BinaryForSourceQueryImpl.class.getName());
    private final BinaryForSourceQuery.Result result;
    private final ClassPath sourceCP;

    public BinaryForSourceQueryImpl(JDKProject project, ClassPath sourceCP) {
        this.result = new ResultImpl("${outputRoot}/jdk/modules/${module}", project.evaluator());
        this.sourceCP = sourceCP;
    }

    public BinaryForSourceQuery.Result findBinaryRoots(URL sourceRoot) {
        FileObject r = URLMapper.findFileObject((URL)sourceRoot);
        if (Arrays.asList(this.sourceCP.getRoots()).contains(r)) {
            return this.result;
        }
        return null;
    }

    private static final class ResultImpl
    implements BinaryForSourceQuery.Result,
    PropertyChangeListener {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private final String template;
        private final PropertyEvaluator evaluator;

        public ResultImpl(String template, PropertyEvaluator evaluator) {
            this.template = template;
            this.evaluator = evaluator;
            this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        public URL[] getRoots() {
            try {
                return new URL[]{new URL(this.evaluator.evaluate(this.template))};
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.FINE, null, ex);
                return new URL[0];
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            this.cs.fireChange();
        }
    }
}

