/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.api.common.project.ui.RemoveClassPathRootAction;
import org.netbeans.modules.java.api.common.project.ui.ShowJavadocAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

final class ModuleNode
extends AbstractNode
implements ChangeListener {
    private static final String MODULE_ICON = "org/netbeans/modules/java/api/common/project/ui/resources/module.png";
    private static final RequestProcessor RP = new RequestProcessor(ModuleNode.class);
    private final URI uri;
    private final AtomicReference<SourceForBinaryQuery.Result2> resCache;
    private final AtomicReference<String> descCache;

    ModuleNode(@NonNull String moduleName, @NonNull URI uri, @NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction) {
        super(Children.LEAF, ModuleNode.createLookup(moduleName, uri, preRemoveAction, postRemoveAction));
        this.uri = uri;
        this.resCache = new AtomicReference();
        this.descCache = new AtomicReference();
        this.setName(moduleName);
        this.setIconBaseWithExtension(MODULE_ICON);
    }

    public String getShortDescription() {
        String res = this.descCache.get();
        if (res == null) {
            RP.execute(() -> {
                try {
                    SourceForBinaryQuery.Result2 sfbq = this.resCache.get();
                    if (sfbq == null) {
                        sfbq = SourceForBinaryQuery.findSourceRoots2((URL)this.uri.toURL());
                        if (this.resCache.compareAndSet(null, sfbq)) {
                            sfbq.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)sfbq));
                        } else {
                            sfbq = this.resCache.get();
                        }
                    }
                    this.descCache.set(Arrays.stream(sfbq.getRoots()).map(ModuleNode::getModuleFolder).map(FileUtil::getFileDisplayName).collect(Collectors.joining(File.pathSeparator)));
                    this.fireShortDescriptionChange(null, null);
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
        }
        return res;
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return super.getActions(context);
        }
        return new Action[]{SystemAction.get(ShowJavadocAction.class), SystemAction.get(RemoveClassPathRootAction.class)};
    }

    public Action getPreferredAction() {
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.descCache.set(null);
    }

    private static Lookup createLookup(@NonNull String moduleName, @NonNull URI binUri, @NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction) {
        return Lookups.fixed((Object[])new Object[]{new JavadocProvider(moduleName, binUri), new Remove(preRemoveAction, postRemoveAction)});
    }

    @NonNull
    private static FileObject getModuleFolder(@NonNull FileObject srcRoot) {
        ClassPath msp = ClassPath.getClassPath((FileObject)srcRoot, (String)"modules/source");
        if (msp == null) {
            return srcRoot;
        }
        FileObject owner = msp.findOwnerRoot(srcRoot);
        if (owner == null) {
            return srcRoot;
        }
        FileObject prev = srcRoot;
        while (!srcRoot.equals(owner)) {
            prev = srcRoot;
            srcRoot = srcRoot.getParent();
        }
        return prev;
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider,
    ChangeListener {
        private final String moduleName;
        private final URI uri;
        private final AtomicReference<JavadocForBinaryQuery.Result> resCache;
        private final AtomicReference<URL[]> rootsCache;

        JavadocProvider(@NonNull String moduleName, @NonNull URI binUri) {
            this.moduleName = moduleName;
            this.uri = binUri;
            this.resCache = new AtomicReference();
            this.rootsCache = new AtomicReference();
        }

        @Override
        public boolean hasJavadoc() {
            return this.findJavadoc().length > 0;
        }

        @Override
        public void showJavadoc() {
            URL[] urls = this.findJavadoc();
            URL pageURL = ShowJavadocAction.findJavadoc("overview-summary.html", urls);
            if (pageURL == null) {
                pageURL = ShowJavadocAction.findJavadoc("index.html", urls);
            }
            String message = Optional.ofNullable(FileOwnerQuery.getOwner((URI)this.uri)).map(ProjectUtils::getInformation).map(ProjectInformation::getDisplayName).map(pn -> NbBundle.getMessage(ModuleNode.class, (String)"TXT_ModuleInProject", (Object)this.moduleName, (Object)pn)).orElse(NbBundle.getMessage(ModuleNode.class, (String)"TXT_Module", (Object)this.moduleName));
            ShowJavadocAction.showJavaDoc(pageURL, message);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.rootsCache.set(null);
        }

        private URL[] findJavadoc() {
            URL[] roots = this.rootsCache.get();
            if (roots == null) {
                JavadocForBinaryQuery.Result res = this.resCache.get();
                if (res == null) {
                    try {
                        res = JavadocForBinaryQuery.findJavadoc((URL)this.uri.toURL());
                        if (this.resCache.compareAndSet(null, res)) {
                            res.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)res));
                        } else {
                            res = this.resCache.get();
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                roots = res == null ? new URL[]{} : res.getRoots();
                this.rootsCache.set(roots);
            }
            return roots;
        }
    }

    private static final class Remove
    implements RemoveClassPathRootAction.Removable {
        private final Consumer<Pair<String, String>> preRemoveAction;
        private final Consumer<Pair<String, String>> postRemoveAction;

        Remove(@NullAllowed Consumer<Pair<String, String>> preRemoveAction, @NullAllowed Consumer<Pair<String, String>> postRemoveAction) {
            this.preRemoveAction = preRemoveAction;
            this.postRemoveAction = postRemoveAction;
        }

        @Override
        public boolean canRemove() {
            return this.preRemoveAction != null || this.postRemoveAction != null;
        }

        @Override
        public Project remove() {
            return null;
        }

        @Override
        public void beforeRemove() {
            if (this.preRemoveAction != null) {
                this.preRemoveAction.accept(null);
            }
        }

        @Override
        public void afterRemove() {
            if (this.postRemoveAction != null) {
                this.postRemoveAction.accept(null);
            }
        }
    }
}

