/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.responses;

import com.oracle.bmc.database.model.ResourcePoolShapeCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResourcePoolShapesResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private String opcNextPage;
    private ResourcePoolShapeCollection resourcePoolShapeCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public ResourcePoolShapeCollection getResourcePoolShapeCollection() {
        return this.resourcePoolShapeCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "opcNextPage", "resourcePoolShapeCollection"})
    private ResourcePoolShapesResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, String opcNextPage, ResourcePoolShapeCollection resourcePoolShapeCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.opcNextPage = opcNextPage;
        this.resourcePoolShapeCollection = resourcePoolShapeCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",resourcePoolShapeCollection=").append(String.valueOf((Object)this.resourcePoolShapeCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourcePoolShapesResponse)) {
            return false;
        }
        ResourcePoolShapesResponse other = (ResourcePoolShapesResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals((Object)this.resourcePoolShapeCollection, (Object)other.resourcePoolShapeCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.resourcePoolShapeCollection == null ? 43 : this.resourcePoolShapeCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ResourcePoolShapesResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private String opcNextPage;
        private ResourcePoolShapeCollection resourcePoolShapeCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder resourcePoolShapeCollection(ResourcePoolShapeCollection resourcePoolShapeCollection) {
            this.resourcePoolShapeCollection = resourcePoolShapeCollection;
            return this;
        }

        public Builder copy(ResourcePoolShapesResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.opcNextPage(o.getOpcNextPage());
            this.resourcePoolShapeCollection(o.getResourcePoolShapeCollection());
            return this;
        }

        public ResourcePoolShapesResponse build() {
            return new ResourcePoolShapesResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.opcNextPage, this.resourcePoolShapeCollection);
        }
    }
}

