/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetVmClusterUpdateRequest
extends BmcRequest<Void> {
    private String vmClusterId;
    private String updateId;
    private String opcRequestId;

    public String getVmClusterId() {
        return this.vmClusterId;
    }

    public String getUpdateId() {
        return this.updateId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().vmClusterId(this.vmClusterId).updateId(this.updateId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vmClusterId=").append(String.valueOf(this.vmClusterId));
        sb.append(",updateId=").append(String.valueOf(this.updateId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVmClusterUpdateRequest)) {
            return false;
        }
        GetVmClusterUpdateRequest other = (GetVmClusterUpdateRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.vmClusterId, other.vmClusterId) && Objects.equals(this.updateId, other.updateId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vmClusterId == null ? 43 : this.vmClusterId.hashCode());
        result = result * 59 + (this.updateId == null ? 43 : this.updateId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVmClusterUpdateRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String vmClusterId = null;
        private String updateId = null;
        private String opcRequestId = null;

        public Builder vmClusterId(String vmClusterId) {
            this.vmClusterId = vmClusterId;
            return this;
        }

        public Builder updateId(String updateId) {
            this.updateId = updateId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVmClusterUpdateRequest o) {
            this.vmClusterId(o.getVmClusterId());
            this.updateId(o.getUpdateId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVmClusterUpdateRequest build() {
            GetVmClusterUpdateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVmClusterUpdateRequest buildWithoutInvocationCallback() {
            GetVmClusterUpdateRequest request = new GetVmClusterUpdateRequest();
            request.vmClusterId = this.vmClusterId;
            request.updateId = this.updateId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

