/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetConsoleConnectionRequest
extends BmcRequest<Void> {
    private String dbNodeId;
    private String consoleConnectionId;

    public String getDbNodeId() {
        return this.dbNodeId;
    }

    public String getConsoleConnectionId() {
        return this.consoleConnectionId;
    }

    public Builder toBuilder() {
        return new Builder().dbNodeId(this.dbNodeId).consoleConnectionId(this.consoleConnectionId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbNodeId=").append(String.valueOf(this.dbNodeId));
        sb.append(",consoleConnectionId=").append(String.valueOf(this.consoleConnectionId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetConsoleConnectionRequest)) {
            return false;
        }
        GetConsoleConnectionRequest other = (GetConsoleConnectionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbNodeId, other.dbNodeId) && Objects.equals(this.consoleConnectionId, other.consoleConnectionId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbNodeId == null ? 43 : this.dbNodeId.hashCode());
        result = result * 59 + (this.consoleConnectionId == null ? 43 : this.consoleConnectionId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConsoleConnectionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbNodeId = null;
        private String consoleConnectionId = null;

        public Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        public Builder consoleConnectionId(String consoleConnectionId) {
            this.consoleConnectionId = consoleConnectionId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConsoleConnectionRequest o) {
            this.dbNodeId(o.getDbNodeId());
            this.consoleConnectionId(o.getConsoleConnectionId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConsoleConnectionRequest build() {
            GetConsoleConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetConsoleConnectionRequest buildWithoutInvocationCallback() {
            GetConsoleConnectionRequest request = new GetConsoleConnectionRequest();
            request.dbNodeId = this.dbNodeId;
            request.consoleConnectionId = this.consoleConnectionId;
            return request;
        }
    }
}

