/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateMaintenanceRunDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="timeScheduled")
    private final Date timeScheduled;
    @JsonProperty(value="isPatchNowEnabled")
    private final Boolean isPatchNowEnabled;
    @JsonProperty(value="patchId")
    private final String patchId;
    @JsonProperty(value="patchingMode")
    private final PatchingMode patchingMode;
    @JsonProperty(value="isCustomActionTimeoutEnabled")
    private final Boolean isCustomActionTimeoutEnabled;
    @JsonProperty(value="customActionTimeoutInMins")
    private final Integer customActionTimeoutInMins;
    @JsonProperty(value="currentCustomActionTimeoutInMins")
    private final Integer currentCustomActionTimeoutInMins;
    @JsonProperty(value="isResumePatching")
    private final Boolean isResumePatching;
    @JsonProperty(value="targetDbServerVersion")
    private final String targetDbServerVersion;
    @JsonProperty(value="targetStorageServerVersion")
    private final String targetStorageServerVersion;

    @Deprecated
    @ConstructorProperties(value={"isEnabled", "timeScheduled", "isPatchNowEnabled", "patchId", "patchingMode", "isCustomActionTimeoutEnabled", "customActionTimeoutInMins", "currentCustomActionTimeoutInMins", "isResumePatching", "targetDbServerVersion", "targetStorageServerVersion"})
    public UpdateMaintenanceRunDetails(Boolean isEnabled, Date timeScheduled, Boolean isPatchNowEnabled, String patchId, PatchingMode patchingMode, Boolean isCustomActionTimeoutEnabled, Integer customActionTimeoutInMins, Integer currentCustomActionTimeoutInMins, Boolean isResumePatching, String targetDbServerVersion, String targetStorageServerVersion) {
        this.isEnabled = isEnabled;
        this.timeScheduled = timeScheduled;
        this.isPatchNowEnabled = isPatchNowEnabled;
        this.patchId = patchId;
        this.patchingMode = patchingMode;
        this.isCustomActionTimeoutEnabled = isCustomActionTimeoutEnabled;
        this.customActionTimeoutInMins = customActionTimeoutInMins;
        this.currentCustomActionTimeoutInMins = currentCustomActionTimeoutInMins;
        this.isResumePatching = isResumePatching;
        this.targetDbServerVersion = targetDbServerVersion;
        this.targetStorageServerVersion = targetStorageServerVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Date getTimeScheduled() {
        return this.timeScheduled;
    }

    public Boolean getIsPatchNowEnabled() {
        return this.isPatchNowEnabled;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public PatchingMode getPatchingMode() {
        return this.patchingMode;
    }

    public Boolean getIsCustomActionTimeoutEnabled() {
        return this.isCustomActionTimeoutEnabled;
    }

    public Integer getCustomActionTimeoutInMins() {
        return this.customActionTimeoutInMins;
    }

    public Integer getCurrentCustomActionTimeoutInMins() {
        return this.currentCustomActionTimeoutInMins;
    }

    public Boolean getIsResumePatching() {
        return this.isResumePatching;
    }

    public String getTargetDbServerVersion() {
        return this.targetDbServerVersion;
    }

    public String getTargetStorageServerVersion() {
        return this.targetStorageServerVersion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateMaintenanceRunDetails(");
        sb.append("super=").append(super.toString());
        sb.append("isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", timeScheduled=").append(String.valueOf(this.timeScheduled));
        sb.append(", isPatchNowEnabled=").append(String.valueOf(this.isPatchNowEnabled));
        sb.append(", patchId=").append(String.valueOf(this.patchId));
        sb.append(", patchingMode=").append(String.valueOf((Object)this.patchingMode));
        sb.append(", isCustomActionTimeoutEnabled=").append(String.valueOf(this.isCustomActionTimeoutEnabled));
        sb.append(", customActionTimeoutInMins=").append(String.valueOf(this.customActionTimeoutInMins));
        sb.append(", currentCustomActionTimeoutInMins=").append(String.valueOf(this.currentCustomActionTimeoutInMins));
        sb.append(", isResumePatching=").append(String.valueOf(this.isResumePatching));
        sb.append(", targetDbServerVersion=").append(String.valueOf(this.targetDbServerVersion));
        sb.append(", targetStorageServerVersion=").append(String.valueOf(this.targetStorageServerVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateMaintenanceRunDetails)) {
            return false;
        }
        UpdateMaintenanceRunDetails other = (UpdateMaintenanceRunDetails)((Object)o);
        return Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.timeScheduled, other.timeScheduled) && Objects.equals(this.isPatchNowEnabled, other.isPatchNowEnabled) && Objects.equals(this.patchId, other.patchId) && Objects.equals((Object)this.patchingMode, (Object)other.patchingMode) && Objects.equals(this.isCustomActionTimeoutEnabled, other.isCustomActionTimeoutEnabled) && Objects.equals(this.customActionTimeoutInMins, other.customActionTimeoutInMins) && Objects.equals(this.currentCustomActionTimeoutInMins, other.currentCustomActionTimeoutInMins) && Objects.equals(this.isResumePatching, other.isResumePatching) && Objects.equals(this.targetDbServerVersion, other.targetDbServerVersion) && Objects.equals(this.targetStorageServerVersion, other.targetStorageServerVersion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.timeScheduled == null ? 43 : this.timeScheduled.hashCode());
        result = result * 59 + (this.isPatchNowEnabled == null ? 43 : this.isPatchNowEnabled.hashCode());
        result = result * 59 + (this.patchId == null ? 43 : this.patchId.hashCode());
        result = result * 59 + (this.patchingMode == null ? 43 : this.patchingMode.hashCode());
        result = result * 59 + (this.isCustomActionTimeoutEnabled == null ? 43 : this.isCustomActionTimeoutEnabled.hashCode());
        result = result * 59 + (this.customActionTimeoutInMins == null ? 43 : this.customActionTimeoutInMins.hashCode());
        result = result * 59 + (this.currentCustomActionTimeoutInMins == null ? 43 : this.currentCustomActionTimeoutInMins.hashCode());
        result = result * 59 + (this.isResumePatching == null ? 43 : this.isResumePatching.hashCode());
        result = result * 59 + (this.targetDbServerVersion == null ? 43 : this.targetDbServerVersion.hashCode());
        result = result * 59 + (this.targetStorageServerVersion == null ? 43 : this.targetStorageServerVersion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PatchingMode implements BmcEnum
    {
        Rolling("ROLLING"),
        Nonrolling("NONROLLING");

        private final String value;
        private static Map<String, PatchingMode> map;

        private PatchingMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PatchingMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PatchingMode: " + key);
        }

        static {
            map = new HashMap<String, PatchingMode>();
            for (PatchingMode v : PatchingMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="timeScheduled")
        private Date timeScheduled;
        @JsonProperty(value="isPatchNowEnabled")
        private Boolean isPatchNowEnabled;
        @JsonProperty(value="patchId")
        private String patchId;
        @JsonProperty(value="patchingMode")
        private PatchingMode patchingMode;
        @JsonProperty(value="isCustomActionTimeoutEnabled")
        private Boolean isCustomActionTimeoutEnabled;
        @JsonProperty(value="customActionTimeoutInMins")
        private Integer customActionTimeoutInMins;
        @JsonProperty(value="currentCustomActionTimeoutInMins")
        private Integer currentCustomActionTimeoutInMins;
        @JsonProperty(value="isResumePatching")
        private Boolean isResumePatching;
        @JsonProperty(value="targetDbServerVersion")
        private String targetDbServerVersion;
        @JsonProperty(value="targetStorageServerVersion")
        private String targetStorageServerVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder timeScheduled(Date timeScheduled) {
            this.timeScheduled = timeScheduled;
            this.__explicitlySet__.add("timeScheduled");
            return this;
        }

        public Builder isPatchNowEnabled(Boolean isPatchNowEnabled) {
            this.isPatchNowEnabled = isPatchNowEnabled;
            this.__explicitlySet__.add("isPatchNowEnabled");
            return this;
        }

        public Builder patchId(String patchId) {
            this.patchId = patchId;
            this.__explicitlySet__.add("patchId");
            return this;
        }

        public Builder patchingMode(PatchingMode patchingMode) {
            this.patchingMode = patchingMode;
            this.__explicitlySet__.add("patchingMode");
            return this;
        }

        public Builder isCustomActionTimeoutEnabled(Boolean isCustomActionTimeoutEnabled) {
            this.isCustomActionTimeoutEnabled = isCustomActionTimeoutEnabled;
            this.__explicitlySet__.add("isCustomActionTimeoutEnabled");
            return this;
        }

        public Builder customActionTimeoutInMins(Integer customActionTimeoutInMins) {
            this.customActionTimeoutInMins = customActionTimeoutInMins;
            this.__explicitlySet__.add("customActionTimeoutInMins");
            return this;
        }

        public Builder currentCustomActionTimeoutInMins(Integer currentCustomActionTimeoutInMins) {
            this.currentCustomActionTimeoutInMins = currentCustomActionTimeoutInMins;
            this.__explicitlySet__.add("currentCustomActionTimeoutInMins");
            return this;
        }

        public Builder isResumePatching(Boolean isResumePatching) {
            this.isResumePatching = isResumePatching;
            this.__explicitlySet__.add("isResumePatching");
            return this;
        }

        public Builder targetDbServerVersion(String targetDbServerVersion) {
            this.targetDbServerVersion = targetDbServerVersion;
            this.__explicitlySet__.add("targetDbServerVersion");
            return this;
        }

        public Builder targetStorageServerVersion(String targetStorageServerVersion) {
            this.targetStorageServerVersion = targetStorageServerVersion;
            this.__explicitlySet__.add("targetStorageServerVersion");
            return this;
        }

        public UpdateMaintenanceRunDetails build() {
            UpdateMaintenanceRunDetails model = new UpdateMaintenanceRunDetails(this.isEnabled, this.timeScheduled, this.isPatchNowEnabled, this.patchId, this.patchingMode, this.isCustomActionTimeoutEnabled, this.customActionTimeoutInMins, this.currentCustomActionTimeoutInMins, this.isResumePatching, this.targetDbServerVersion, this.targetStorageServerVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateMaintenanceRunDetails model) {
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("timeScheduled")) {
                this.timeScheduled(model.getTimeScheduled());
            }
            if (model.wasPropertyExplicitlySet("isPatchNowEnabled")) {
                this.isPatchNowEnabled(model.getIsPatchNowEnabled());
            }
            if (model.wasPropertyExplicitlySet("patchId")) {
                this.patchId(model.getPatchId());
            }
            if (model.wasPropertyExplicitlySet("patchingMode")) {
                this.patchingMode(model.getPatchingMode());
            }
            if (model.wasPropertyExplicitlySet("isCustomActionTimeoutEnabled")) {
                this.isCustomActionTimeoutEnabled(model.getIsCustomActionTimeoutEnabled());
            }
            if (model.wasPropertyExplicitlySet("customActionTimeoutInMins")) {
                this.customActionTimeoutInMins(model.getCustomActionTimeoutInMins());
            }
            if (model.wasPropertyExplicitlySet("currentCustomActionTimeoutInMins")) {
                this.currentCustomActionTimeoutInMins(model.getCurrentCustomActionTimeoutInMins());
            }
            if (model.wasPropertyExplicitlySet("isResumePatching")) {
                this.isResumePatching(model.getIsResumePatching());
            }
            if (model.wasPropertyExplicitlySet("targetDbServerVersion")) {
                this.targetDbServerVersion(model.getTargetDbServerVersion());
            }
            if (model.wasPropertyExplicitlySet("targetStorageServerVersion")) {
                this.targetStorageServerVersion(model.getTargetStorageServerVersion());
            }
            return this;
        }
    }
}

