/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OneoffPatch
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="dbVersion")
    private final String dbVersion;
    @JsonProperty(value="releaseUpdate")
    private final String releaseUpdate;
    @JsonProperty(value="oneOffPatches")
    private final List<String> oneOffPatches;
    @JsonProperty(value="sizeInKBs")
    private final Float sizeInKBs;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="sha256Sum")
    private final String sha256Sum;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeOfExpiration")
    private final Date timeOfExpiration;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "dbVersion", "releaseUpdate", "oneOffPatches", "sizeInKBs", "lifecycleState", "lifecycleDetails", "sha256Sum", "timeUpdated", "timeCreated", "timeOfExpiration", "freeformTags", "definedTags"})
    public OneoffPatch(String id, String compartmentId, String displayName, String dbVersion, String releaseUpdate, List<String> oneOffPatches, Float sizeInKBs, LifecycleState lifecycleState, String lifecycleDetails, String sha256Sum, Date timeUpdated, Date timeCreated, Date timeOfExpiration, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.dbVersion = dbVersion;
        this.releaseUpdate = releaseUpdate;
        this.oneOffPatches = oneOffPatches;
        this.sizeInKBs = sizeInKBs;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.sha256Sum = sha256Sum;
        this.timeUpdated = timeUpdated;
        this.timeCreated = timeCreated;
        this.timeOfExpiration = timeOfExpiration;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public String getReleaseUpdate() {
        return this.releaseUpdate;
    }

    public List<String> getOneOffPatches() {
        return this.oneOffPatches;
    }

    public Float getSizeInKBs() {
        return this.sizeInKBs;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getSha256Sum() {
        return this.sha256Sum;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeOfExpiration() {
        return this.timeOfExpiration;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OneoffPatch(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", dbVersion=").append(String.valueOf(this.dbVersion));
        sb.append(", releaseUpdate=").append(String.valueOf(this.releaseUpdate));
        sb.append(", oneOffPatches=").append(String.valueOf(this.oneOffPatches));
        sb.append(", sizeInKBs=").append(String.valueOf(this.sizeInKBs));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", sha256Sum=").append(String.valueOf(this.sha256Sum));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeOfExpiration=").append(String.valueOf(this.timeOfExpiration));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OneoffPatch)) {
            return false;
        }
        OneoffPatch other = (OneoffPatch)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.dbVersion, other.dbVersion) && Objects.equals(this.releaseUpdate, other.releaseUpdate) && Objects.equals(this.oneOffPatches, other.oneOffPatches) && Objects.equals(this.sizeInKBs, other.sizeInKBs) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.sha256Sum, other.sha256Sum) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeOfExpiration, other.timeOfExpiration) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.dbVersion == null ? 43 : this.dbVersion.hashCode());
        result = result * 59 + (this.releaseUpdate == null ? 43 : this.releaseUpdate.hashCode());
        result = result * 59 + (this.oneOffPatches == null ? 43 : this.oneOffPatches.hashCode());
        result = result * 59 + (this.sizeInKBs == null ? 43 : this.sizeInKBs.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.sha256Sum == null ? 43 : this.sha256Sum.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeOfExpiration == null ? 43 : this.timeOfExpiration.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Available("AVAILABLE"),
        Updating("UPDATING"),
        Inactive("INACTIVE"),
        Failed("FAILED"),
        Expired("EXPIRED"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="dbVersion")
        private String dbVersion;
        @JsonProperty(value="releaseUpdate")
        private String releaseUpdate;
        @JsonProperty(value="oneOffPatches")
        private List<String> oneOffPatches;
        @JsonProperty(value="sizeInKBs")
        private Float sizeInKBs;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="sha256Sum")
        private String sha256Sum;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeOfExpiration")
        private Date timeOfExpiration;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder dbVersion(String dbVersion) {
            this.dbVersion = dbVersion;
            this.__explicitlySet__.add("dbVersion");
            return this;
        }

        public Builder releaseUpdate(String releaseUpdate) {
            this.releaseUpdate = releaseUpdate;
            this.__explicitlySet__.add("releaseUpdate");
            return this;
        }

        public Builder oneOffPatches(List<String> oneOffPatches) {
            this.oneOffPatches = oneOffPatches;
            this.__explicitlySet__.add("oneOffPatches");
            return this;
        }

        public Builder sizeInKBs(Float sizeInKBs) {
            this.sizeInKBs = sizeInKBs;
            this.__explicitlySet__.add("sizeInKBs");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder sha256Sum(String sha256Sum) {
            this.sha256Sum = sha256Sum;
            this.__explicitlySet__.add("sha256Sum");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeOfExpiration(Date timeOfExpiration) {
            this.timeOfExpiration = timeOfExpiration;
            this.__explicitlySet__.add("timeOfExpiration");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public OneoffPatch build() {
            OneoffPatch model = new OneoffPatch(this.id, this.compartmentId, this.displayName, this.dbVersion, this.releaseUpdate, this.oneOffPatches, this.sizeInKBs, this.lifecycleState, this.lifecycleDetails, this.sha256Sum, this.timeUpdated, this.timeCreated, this.timeOfExpiration, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OneoffPatch model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("dbVersion")) {
                this.dbVersion(model.getDbVersion());
            }
            if (model.wasPropertyExplicitlySet("releaseUpdate")) {
                this.releaseUpdate(model.getReleaseUpdate());
            }
            if (model.wasPropertyExplicitlySet("oneOffPatches")) {
                this.oneOffPatches(model.getOneOffPatches());
            }
            if (model.wasPropertyExplicitlySet("sizeInKBs")) {
                this.sizeInKBs(model.getSizeInKBs());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("sha256Sum")) {
                this.sha256Sum(model.getSha256Sum());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeOfExpiration")) {
                this.timeOfExpiration(model.getTimeOfExpiration());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

