/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TriggerSchedule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="scheduleType")
    private final ScheduleType scheduleType;
    @JsonProperty(value="customSchedule")
    private final String customSchedule;

    @Deprecated
    @ConstructorProperties(value={"scheduleType", "customSchedule"})
    public TriggerSchedule(ScheduleType scheduleType, String customSchedule) {
        this.scheduleType = scheduleType;
        this.customSchedule = customSchedule;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public String getCustomSchedule() {
        return this.customSchedule;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TriggerSchedule(");
        sb.append("super=").append(super.toString());
        sb.append("scheduleType=").append(String.valueOf((Object)this.scheduleType));
        sb.append(", customSchedule=").append(String.valueOf(this.customSchedule));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TriggerSchedule)) {
            return false;
        }
        TriggerSchedule other = (TriggerSchedule)((Object)o);
        return Objects.equals((Object)this.scheduleType, (Object)other.scheduleType) && Objects.equals(this.customSchedule, other.customSchedule) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.scheduleType == null ? 43 : this.scheduleType.hashCode());
        result = result * 59 + (this.customSchedule == null ? 43 : this.customSchedule.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ScheduleType implements BmcEnum
    {
        None("NONE"),
        Default("DEFAULT"),
        Custom("CUSTOM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ScheduleType> map;

        private ScheduleType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ScheduleType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ScheduleType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ScheduleType.class);
            map = new HashMap<String, ScheduleType>();
            for (ScheduleType v : ScheduleType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="scheduleType")
        private ScheduleType scheduleType;
        @JsonProperty(value="customSchedule")
        private String customSchedule;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder scheduleType(ScheduleType scheduleType) {
            this.scheduleType = scheduleType;
            this.__explicitlySet__.add("scheduleType");
            return this;
        }

        public Builder customSchedule(String customSchedule) {
            this.customSchedule = customSchedule;
            this.__explicitlySet__.add("customSchedule");
            return this;
        }

        public TriggerSchedule build() {
            TriggerSchedule model = new TriggerSchedule(this.scheduleType, this.customSchedule);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TriggerSchedule model) {
            if (model.wasPropertyExplicitlySet("scheduleType")) {
                this.scheduleType(model.getScheduleType());
            }
            if (model.wasPropertyExplicitlySet("customSchedule")) {
                this.customSchedule(model.getCustomSchedule());
            }
            return this;
        }
    }
}

