/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RepositoryMirrorRecordSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="mirrorStatus")
    private final MirrorStatus mirrorStatus;
    @JsonProperty(value="workRequestId")
    private final String workRequestId;
    @JsonProperty(value="timeEnqueued")
    private final Date timeEnqueued;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeCompleted")
    private final Date timeCompleted;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"mirrorStatus", "workRequestId", "timeEnqueued", "timeStarted", "timeCompleted", "freeformTags", "definedTags"})
    public RepositoryMirrorRecordSummary(MirrorStatus mirrorStatus, String workRequestId, Date timeEnqueued, Date timeStarted, Date timeCompleted, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.mirrorStatus = mirrorStatus;
        this.workRequestId = workRequestId;
        this.timeEnqueued = timeEnqueued;
        this.timeStarted = timeStarted;
        this.timeCompleted = timeCompleted;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MirrorStatus getMirrorStatus() {
        return this.mirrorStatus;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public Date getTimeEnqueued() {
        return this.timeEnqueued;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeCompleted() {
        return this.timeCompleted;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RepositoryMirrorRecordSummary(");
        sb.append("super=").append(super.toString());
        sb.append("mirrorStatus=").append(String.valueOf((Object)this.mirrorStatus));
        sb.append(", workRequestId=").append(String.valueOf(this.workRequestId));
        sb.append(", timeEnqueued=").append(String.valueOf(this.timeEnqueued));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeCompleted=").append(String.valueOf(this.timeCompleted));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepositoryMirrorRecordSummary)) {
            return false;
        }
        RepositoryMirrorRecordSummary other = (RepositoryMirrorRecordSummary)((Object)o);
        return Objects.equals((Object)this.mirrorStatus, (Object)other.mirrorStatus) && Objects.equals(this.workRequestId, other.workRequestId) && Objects.equals(this.timeEnqueued, other.timeEnqueued) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeCompleted, other.timeCompleted) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.mirrorStatus == null ? 43 : this.mirrorStatus.hashCode());
        result = result * 59 + (this.workRequestId == null ? 43 : this.workRequestId.hashCode());
        result = result * 59 + (this.timeEnqueued == null ? 43 : this.timeEnqueued.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeCompleted == null ? 43 : this.timeCompleted.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum MirrorStatus implements BmcEnum
    {
        None("NONE"),
        Queued("QUEUED"),
        Running("RUNNING"),
        Passed("PASSED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MirrorStatus> map;

        private MirrorStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MirrorStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MirrorStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MirrorStatus.class);
            map = new HashMap<String, MirrorStatus>();
            for (MirrorStatus v : MirrorStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="mirrorStatus")
        private MirrorStatus mirrorStatus;
        @JsonProperty(value="workRequestId")
        private String workRequestId;
        @JsonProperty(value="timeEnqueued")
        private Date timeEnqueued;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeCompleted")
        private Date timeCompleted;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder mirrorStatus(MirrorStatus mirrorStatus) {
            this.mirrorStatus = mirrorStatus;
            this.__explicitlySet__.add("mirrorStatus");
            return this;
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            this.__explicitlySet__.add("workRequestId");
            return this;
        }

        public Builder timeEnqueued(Date timeEnqueued) {
            this.timeEnqueued = timeEnqueued;
            this.__explicitlySet__.add("timeEnqueued");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeCompleted(Date timeCompleted) {
            this.timeCompleted = timeCompleted;
            this.__explicitlySet__.add("timeCompleted");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public RepositoryMirrorRecordSummary build() {
            RepositoryMirrorRecordSummary model = new RepositoryMirrorRecordSummary(this.mirrorStatus, this.workRequestId, this.timeEnqueued, this.timeStarted, this.timeCompleted, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RepositoryMirrorRecordSummary model) {
            if (model.wasPropertyExplicitlySet("mirrorStatus")) {
                this.mirrorStatus(model.getMirrorStatus());
            }
            if (model.wasPropertyExplicitlySet("workRequestId")) {
                this.workRequestId(model.getWorkRequestId());
            }
            if (model.wasPropertyExplicitlySet("timeEnqueued")) {
                this.timeEnqueued(model.getTimeEnqueued());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeCompleted")) {
                this.timeCompleted(model.getTimeCompleted());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

