/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.ContainerConfig;
import com.oracle.bmc.devops.model.CreateDeployStageDetails;
import com.oracle.bmc.devops.model.DeployStagePredecessorCollection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="deployStageType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateShellDeployStageDetails
extends CreateDeployStageDetails {
    @JsonProperty(value="containerConfig")
    private final ContainerConfig containerConfig;
    @JsonProperty(value="commandSpecDeployArtifactId")
    private final String commandSpecDeployArtifactId;
    @JsonProperty(value="timeoutInSeconds")
    private final Integer timeoutInSeconds;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateShellDeployStageDetails(String description, String displayName, String deployPipelineId, DeployStagePredecessorCollection deployStagePredecessorCollection, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, ContainerConfig containerConfig, String commandSpecDeployArtifactId, Integer timeoutInSeconds) {
        super(description, displayName, deployPipelineId, deployStagePredecessorCollection, freeformTags, definedTags);
        this.containerConfig = containerConfig;
        this.commandSpecDeployArtifactId = commandSpecDeployArtifactId;
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public ContainerConfig getContainerConfig() {
        return this.containerConfig;
    }

    public String getCommandSpecDeployArtifactId() {
        return this.commandSpecDeployArtifactId;
    }

    public Integer getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateShellDeployStageDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", containerConfig=").append(String.valueOf((Object)this.containerConfig));
        sb.append(", commandSpecDeployArtifactId=").append(String.valueOf(this.commandSpecDeployArtifactId));
        sb.append(", timeoutInSeconds=").append(String.valueOf(this.timeoutInSeconds));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateShellDeployStageDetails)) {
            return false;
        }
        CreateShellDeployStageDetails other = (CreateShellDeployStageDetails)((Object)o);
        return Objects.equals((Object)this.containerConfig, (Object)other.containerConfig) && Objects.equals(this.commandSpecDeployArtifactId, other.commandSpecDeployArtifactId) && Objects.equals(this.timeoutInSeconds, other.timeoutInSeconds) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.containerConfig == null ? 43 : this.containerConfig.hashCode());
        result = result * 59 + (this.commandSpecDeployArtifactId == null ? 43 : this.commandSpecDeployArtifactId.hashCode());
        result = result * 59 + (this.timeoutInSeconds == null ? 43 : this.timeoutInSeconds.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="deployPipelineId")
        private String deployPipelineId;
        @JsonProperty(value="deployStagePredecessorCollection")
        private DeployStagePredecessorCollection deployStagePredecessorCollection;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="containerConfig")
        private ContainerConfig containerConfig;
        @JsonProperty(value="commandSpecDeployArtifactId")
        private String commandSpecDeployArtifactId;
        @JsonProperty(value="timeoutInSeconds")
        private Integer timeoutInSeconds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder deployPipelineId(String deployPipelineId) {
            this.deployPipelineId = deployPipelineId;
            this.__explicitlySet__.add("deployPipelineId");
            return this;
        }

        public Builder deployStagePredecessorCollection(DeployStagePredecessorCollection deployStagePredecessorCollection) {
            this.deployStagePredecessorCollection = deployStagePredecessorCollection;
            this.__explicitlySet__.add("deployStagePredecessorCollection");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder containerConfig(ContainerConfig containerConfig) {
            this.containerConfig = containerConfig;
            this.__explicitlySet__.add("containerConfig");
            return this;
        }

        public Builder commandSpecDeployArtifactId(String commandSpecDeployArtifactId) {
            this.commandSpecDeployArtifactId = commandSpecDeployArtifactId;
            this.__explicitlySet__.add("commandSpecDeployArtifactId");
            return this;
        }

        public Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            this.__explicitlySet__.add("timeoutInSeconds");
            return this;
        }

        public CreateShellDeployStageDetails build() {
            CreateShellDeployStageDetails model = new CreateShellDeployStageDetails(this.description, this.displayName, this.deployPipelineId, this.deployStagePredecessorCollection, this.freeformTags, this.definedTags, this.containerConfig, this.commandSpecDeployArtifactId, this.timeoutInSeconds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateShellDeployStageDetails model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("deployPipelineId")) {
                this.deployPipelineId(model.getDeployPipelineId());
            }
            if (model.wasPropertyExplicitlySet("deployStagePredecessorCollection")) {
                this.deployStagePredecessorCollection(model.getDeployStagePredecessorCollection());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("containerConfig")) {
                this.containerConfig(model.getContainerConfig());
            }
            if (model.wasPropertyExplicitlySet("commandSpecDeployArtifactId")) {
                this.commandSpecDeployArtifactId(model.getCommandSpecDeployArtifactId());
            }
            if (model.wasPropertyExplicitlySet("timeoutInSeconds")) {
                this.timeoutInSeconds(model.getTimeoutInSeconds());
            }
            return this;
        }
    }
}

