/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class BugzillaAttachmentMapper
extends TaskAttachmentMapper {
    private String token;
    private Date deltaDate;

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void applyTo(TaskAttribute taskAttribute) {
        TaskAttributeMetaData defaults;
        TaskAttribute child;
        Assert.isNotNull((Object)taskAttribute);
        TaskData taskData = taskAttribute.getTaskData();
        TaskAttributeMapper mapper = taskData.getAttributeMapper();
        taskAttribute.getMetaData().defaults().setType("attachment");
        if (this.getAttachmentId() != null) {
            mapper.setValue(taskAttribute, this.getAttachmentId());
        }
        if (this.getAuthor() != null && this.getAuthor().getPersonId() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.author");
            defaults = child.getMetaData().defaults();
            defaults.setType("person");
            defaults.setLabel(Messages.BugzillaAttachmentMapper_Author);
            mapper.setRepositoryPerson(child, this.getAuthor());
        }
        if (this.getContentType() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.ctype");
            defaults = child.getMetaData().defaults();
            defaults.setType("shortText");
            defaults.setLabel(Messages.BugzillaAttachmentMapper_Content_Type);
            mapper.setValue(child, this.getContentType());
        }
        if (this.getCreationDate() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.date");
            defaults = child.getMetaData().defaults();
            defaults.setType("date");
            defaults.setLabel(Messages.BugzillaAttachmentMapper_Creation_Date);
            mapper.setDateValue(child, this.getCreationDate());
        }
        if (this.getDescription() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.description");
            defaults = child.getMetaData().defaults();
            defaults.setType("shortText");
            defaults.setLabel(Messages.BugzillaAttachmentMapper_Description);
            mapper.setValue(child, this.getDescription());
        }
        if (this.getFileName() != null) {
            child = taskAttribute.createMappedAttribute("filename");
            defaults = child.getMetaData().defaults();
            defaults.setType("shortText");
            defaults.setLabel(Messages.BugzillaAttachmentMapper_Filename);
            mapper.setValue(child, this.getFileName());
        }
        if (this.isDeprecated() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.deprecated");
            defaults = child.getMetaData().defaults();
            defaults.setType("boolean");
            defaults.setLabel(Messages.BugzillaAttachmentMapper_obsolete);
            mapper.setBooleanValue(child, this.isDeprecated());
        }
        if (this.isPatch() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.patch");
            defaults = child.getMetaData().defaults();
            defaults.setType("boolean");
            defaults.setLabel(Messages.BugzillaAttachmentMapper_patch);
            mapper.setBooleanValue(child, this.isPatch());
        }
        if (this.getLength() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.size");
            defaults = child.getMetaData().defaults();
            defaults.setType("shortText");
            defaults.setLabel(Messages.BugzillaAttachmentMapper_Size);
            mapper.setLongValue(child, this.getLength());
        }
        if (this.getUrl() != null) {
            child = taskAttribute.createMappedAttribute("task.common.attachment.url");
            defaults = child.getMetaData().defaults();
            defaults.setType("url");
            defaults.setLabel(Messages.BugzillaAttachmentMapper_URL);
            mapper.setValue(child, this.getUrl());
        }
        if (this.getToken() != null) {
            child = taskAttribute.createMappedAttribute(BugzillaAttribute.TOKEN.getKey());
            defaults = child.getMetaData().defaults();
            defaults.setType("shortText");
            defaults.setLabel(Messages.BugzillaAttachmentMapper_Token);
            mapper.setValue(child, this.getToken());
        }
        if (this.getDeltaDate() != null) {
            child = taskAttribute.createMappedAttribute(BugzillaAttribute.DELTA_TS.getKey());
            defaults = child.getMetaData().defaults();
            defaults.setType("date");
            defaults.setLabel(Messages.BugzillaAttachmentMapper_DELTA_TS);
            mapper.setDateValue(child, this.getDeltaDate());
        }
    }

    public static BugzillaAttachmentMapper createFrom(TaskAttribute taskAttribute) {
        Long value;
        Assert.isNotNull((Object)taskAttribute);
        TaskAttributeMapper mapper = taskAttribute.getTaskData().getAttributeMapper();
        BugzillaAttachmentMapper attachment = new BugzillaAttachmentMapper();
        attachment.setAttachmentId(mapper.getValue(taskAttribute));
        TaskAttribute child = taskAttribute.getMappedAttribute("task.common.attachment.author");
        if (child != null) {
            attachment.setAuthor(mapper.getRepositoryPerson(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.ctype")) != null) {
            attachment.setContentType(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.date")) != null) {
            attachment.setCreationDate(mapper.getDateValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.description")) != null) {
            attachment.setDescription(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("filename")) != null) {
            attachment.setFileName(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.deprecated")) != null) {
            attachment.setDeprecated(mapper.getBooleanValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.patch")) != null) {
            attachment.setPatch(mapper.getBooleanValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.size")) != null && (value = mapper.getLongValue(child)) != null) {
            attachment.setLength(value);
        }
        if ((child = taskAttribute.getMappedAttribute("task.common.attachment.url")) != null) {
            attachment.setUrl(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute(BugzillaAttribute.TOKEN.getKey())) != null) {
            attachment.setToken(mapper.getValue(child));
        }
        if ((child = taskAttribute.getMappedAttribute(BugzillaAttribute.DELTA_TS.getKey())) != null) {
            attachment.setDeltaDate(mapper.getDateValue(child));
        }
        return attachment;
    }

    public Date getDeltaDate() {
        return this.deltaDate;
    }

    public void setDeltaDate(Date deltaDate) {
        this.deltaDate = deltaDate;
    }

    public static /* bridge */ /* synthetic */ TaskAttachmentMapper createFrom(TaskAttribute taskAttribute) {
        return BugzillaAttachmentMapper.createFrom(taskAttribute);
    }
}

