/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mgbean;

import com.sun.faces.RIConstants;
import com.sun.faces.mgbean.BeanBuilder;
import com.sun.faces.mgbean.ManagedBeanCreationException;
import com.sun.faces.mgbean.ManagedBeanInfo;
import com.sun.faces.mgbean.ManagedBeanPreProcessingException;
import com.sun.faces.util.MessageUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ExpressionFactory;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class ManagedBeanBuilder
extends BeanBuilder {
    private List<BakedProperty> properties;

    public ManagedBeanBuilder(ManagedBeanInfo beanInfo) {
        super(beanInfo);
    }

    @Override
    void bake() {
        if (!this.isBaked()) {
            super.bake();
            if (this.beanInfo.hasManagedProperties()) {
                this.properties = new ArrayList<BakedProperty>(this.beanInfo.getManagedProperties().size());
                String propertyName = null;
                try {
                    block6: for (ManagedBeanInfo.ManagedProperty property : this.beanInfo.getManagedProperties()) {
                        propertyName = property.getPropertyName();
                        switch (this.getPropertyType(property)) {
                            case MAP: {
                                this.bakeMapProperty(property);
                                continue block6;
                            }
                            case LIST: {
                                this.bakeListProperty(property);
                                continue block6;
                            }
                        }
                        this.bakeBeanProperty(property);
                    }
                }
                catch (Exception e) {
                    if (e instanceof ManagedBeanPreProcessingException) {
                        throw (ManagedBeanPreProcessingException)e;
                    }
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROPERTY_UNKNOWN_PROCESSING_ERROR", propertyName);
                    throw new ManagedBeanPreProcessingException(message, e, ManagedBeanPreProcessingException.Type.UNCHECKED);
                }
            }
            this.baked();
            Introspector.flushFromCaches(this.getBeanClass());
        }
    }

    @Override
    protected void buildBean(Object bean, FacesContext context) {
        if (this.properties != null) {
            for (BakedProperty property : this.properties) {
                property.set(bean, context);
            }
        }
    }

    private PropertyType getPropertyType(ManagedBeanInfo.ManagedProperty property) {
        if (property.hasListEntry()) {
            if (property.hasMapEntry() || property.hasPropertyValue()) {
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_LIST_PROPERTY_CONFIG_ERROR", property.getPropertyName(), this.beanInfo.getName());
                throw new ManagedBeanPreProcessingException(message);
            }
            return PropertyType.LIST;
        }
        if (property.hasMapEntry()) {
            if (property.hasPropertyValue()) {
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_MAP_PROPERTY_CONFIG_ERROR", property.getPropertyName(), this.beanInfo.getName());
                throw new ManagedBeanPreProcessingException(message);
            }
            return PropertyType.MAP;
        }
        return PropertyType.BEAN;
    }

    private void bakeMapProperty(ManagedBeanInfo.ManagedProperty property) {
        String message;
        ManagedBeanInfo.MapEntry rawEntry = property.getMapEntry();
        Map<BeanBuilder.Expression, BeanBuilder.Expression> mapEntries = this.getBakedMap(rawEntry.getKeyClass(), rawEntry.getValueClass(), rawEntry.getEntries());
        PropertyDescriptor pd = this.getPropertyDescriptor(property.getPropertyName());
        if (pd == null) {
            message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROPERTY_DOES_NOT_EXIST_ERROR", property.getPropertyName(), this.beanInfo.getName());
            this.queueMessage(message);
        } else if (pd.getWriteMethod() != null) {
            Class<?>[] params = pd.getWriteMethod().getParameterTypes();
            if (!Map.class.isAssignableFrom(params[0])) {
                String message2 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_MAP_PROPERTY_INCORRECT_SETTER_ERROR", property.getPropertyName(), this.beanInfo.getName());
                this.queueMessage(message2);
            }
        } else if (pd.getReadMethod() == null) {
            message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROPERTY_DOES_NOT_EXIST_ERROR", property.getPropertyName(), this.beanInfo.getName());
            this.queueMessage(message);
        } else {
            Class<?> returnType = pd.getReadMethod().getReturnType();
            if (!Map.class.isAssignableFrom(returnType)) {
                String message3 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_MAP_PROPERTY_INCORRECT_GETTER_ERROR", property.getPropertyName(), this.beanInfo.getName());
                this.queueMessage(message3);
            }
        }
        if (!this.hasMessages()) {
            BakedMapProperty baked = new BakedMapProperty(mapEntries, pd);
            this.properties.add(baked);
        }
    }

    private void bakeListProperty(ManagedBeanInfo.ManagedProperty property) {
        String message;
        ManagedBeanInfo.ListEntry rawEntry = property.getListEntry();
        List<BeanBuilder.Expression> listEntry = this.getBakedList(rawEntry.getValueClass(), rawEntry.getValues());
        PropertyDescriptor pd = this.getPropertyDescriptor(property.getPropertyName());
        if (pd == null) {
            message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROPERTY_DOES_NOT_EXIST_ERROR", property.getPropertyName(), this.beanInfo.getName());
            this.queueMessage(message);
        } else if (pd.getReadMethod() == null) {
            if (pd.getWriteMethod() == null) {
                message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROPERTY_DOES_NOT_EXIST_ERROR", property.getPropertyName(), this.beanInfo.getName());
                this.queueMessage(message);
            } else {
                Class<?>[] params = pd.getWriteMethod().getParameterTypes();
                if (params.length != 1) {
                    String message2 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROPERTY_INCORRECT_ARGS_ERROR", property.getPropertyName(), this.beanInfo.getName());
                    this.queueMessage(message2);
                } else if (!params[0].isArray() && !List.class.isAssignableFrom(params[0])) {
                    String message3 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_LIST_SETTER_DOES_NOT_ACCEPT_LIST_OR_ARRAY_ERROR", property.getPropertyName(), this.beanInfo.getName());
                    this.queueMessage(message3);
                }
            }
        } else {
            Class<?> retType = pd.getReadMethod().getReturnType();
            if (retType.isArray()) {
                if (pd.getWriteMethod() == null) {
                    String message4 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_LIST_GETTER_ARRAY_NO_SETTER_ERROR", property.getPropertyName(), this.beanInfo.getName());
                    this.queueMessage(message4);
                }
            } else if (!List.class.isAssignableFrom(retType)) {
                String message5 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_LIST_SETTER_DOES_NOT_RETURN_LIST_OR_ARRAY_ERROR", property.getPropertyName(), this.beanInfo.getName());
                this.queueMessage(message5);
            }
        }
        if (!this.hasMessages()) {
            BakedListProperty baked = new BakedListProperty(listEntry, pd);
            this.properties.add(baked);
        }
    }

    private void bakeBeanProperty(ManagedBeanInfo.ManagedProperty property) {
        String message;
        String className = property.getPropertyClass();
        PropertyDescriptor pd = this.getPropertyDescriptor(property.getPropertyName());
        if (pd == null || pd.getWriteMethod() == null) {
            if (!UIComponent.class.isAssignableFrom(this.getBeanClass())) {
                String message2 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROPERTY_DOES_NOT_EXIST_ERROR", property.getPropertyName(), this.beanInfo.getName());
                this.queueMessage(message2);
            }
        } else {
            Method method = pd.getWriteMethod();
            Class<?>[] param = method.getParameterTypes();
            if (param.length != 1) {
                message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_PROPERTY_INCORRECT_ARGS_ERROR", property.getPropertyName(), this.beanInfo.getName());
                this.queueMessage(message);
            }
        }
        BeanBuilder.Expression value = null;
        if (pd != null) {
            String propertyValue;
            Class propertyClass = className != null ? this.loadClass(className) : pd.getPropertyType();
            if (className != null && !pd.getWriteMethod().getParameterTypes()[0].isAssignableFrom(propertyClass)) {
                message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_DEFINED_PROPERTY_CLASS_NOT_COMPATIBLE_ERROR", property.getPropertyName(), this.beanInfo.getName(), property.getPropertyClass());
                this.queueMessage(message);
            }
            if (!"null_value".equals(propertyValue = property.getPropertyValue())) {
                value = new BeanBuilder.Expression(propertyValue, propertyClass);
            }
        } else {
            String propertyValue = property.getPropertyValue();
            if (!"null_value".equals(propertyValue)) {
                value = new BeanBuilder.Expression(propertyValue, String.class);
            }
        }
        if (!this.hasMessages()) {
            BakedBeanProperty baked = new BakedBeanProperty(property.getPropertyName(), pd, value);
            this.properties.add(baked);
        }
    }

    private PropertyDescriptor getPropertyDescriptor(String propertyName) {
        try {
            PropertyDescriptor[] pds;
            BeanInfo beanInfo = Introspector.getBeanInfo(this.getBeanClass());
            for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
                if (!propertyName.equals(pd.getName())) continue;
                return pd;
            }
        }
        catch (IntrospectionException ie) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_INTROSPECTION_ERROR", this.beanInfo.getName());
            throw new ManagedBeanPreProcessingException(message);
        }
        return null;
    }

    private class BakedBeanProperty
    implements BakedProperty {
        private String propertyName;
        private PropertyDescriptor pd;
        private BeanBuilder.Expression value;

        BakedBeanProperty(String propertyName, PropertyDescriptor pd, BeanBuilder.Expression value) {
            this.propertyName = propertyName;
            this.pd = pd;
            this.value = value;
        }

        @Override
        public void set(Object bean, FacesContext context) {
            if (this.pd != null) {
                Method writeMethod = this.pd.getWriteMethod();
                try {
                    writeMethod.invoke(bean, this.value != null ? this.value.evaluate(context.getELContext()) : null);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_UNABLE_TO_SET_PROPERTY_ERROR", this.pd.getName(), ManagedBeanBuilder.this.beanInfo.getName());
                    throw new ManagedBeanCreationException(message, e);
                }
            } else {
                ((UIComponent)bean).getAttributes().put(this.propertyName, this.value != null ? this.value.evaluate(context.getELContext()) : "");
            }
        }
    }

    private class BakedListProperty
    implements BakedProperty {
        private List<BeanBuilder.Expression> listEntries;
        private PropertyDescriptor pd;

        BakedListProperty(List<BeanBuilder.Expression> listEntries, PropertyDescriptor pd) {
            this.listEntries = listEntries;
            this.pd = pd;
        }

        @Override
        public void set(Object bean, FacesContext context) {
            Method readMethod = this.pd.getReadMethod();
            Object temp = null;
            if (readMethod != null) {
                try {
                    temp = readMethod.invoke(bean, RIConstants.EMPTY_METH_ARGS);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            List<Object> target = null;
            if (temp != null) {
                if (temp.getClass().isArray()) {
                    int len = Array.getLength(temp);
                    for (int i = 0; i < len; ++i) {
                        if (target == null) {
                            target = new ArrayList(len);
                        }
                        target.add(Array.get(temp, i));
                    }
                } else {
                    target = (List)temp;
                }
            }
            if (target == null) {
                target = new ArrayList();
            }
            ExpressionFactory expFactory = context.getApplication().getExpressionFactory();
            ManagedBeanBuilder.this.initList(this.listEntries, target, context);
            if (temp != null && !temp.getClass().isArray()) {
                return;
            }
            if (temp != null) {
                Class<?> arrayType = temp.getClass().getComponentType();
                Object result = Array.newInstance(arrayType, target.size());
                int len = target.size();
                for (int i = 0; i < len; ++i) {
                    Array.set(result, i, expFactory.coerceToType(target.get(i), arrayType));
                }
                try {
                    this.pd.getWriteMethod().invoke(bean, result);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_UNABLE_TO_SET_PROPERTY_ERROR", this.pd.getName(), ManagedBeanBuilder.this.beanInfo.getName());
                    throw new ManagedBeanCreationException(message, e);
                }
            }
            Method writeMethod = this.pd.getWriteMethod();
            Class<?>[] param = writeMethod.getParameterTypes();
            if (param[0].isArray()) {
                Class<?> arrayType = param[0].getComponentType();
                Object result = Array.newInstance(arrayType, target.size());
                int len = target.size();
                for (int i = 0; i < len; ++i) {
                    Array.set(result, i, expFactory.coerceToType(target.get(i), arrayType));
                }
                try {
                    writeMethod.invoke(bean, result);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_UNABLE_TO_SET_PROPERTY_ERROR", this.pd.getName(), ManagedBeanBuilder.this.beanInfo.getName());
                    throw new ManagedBeanCreationException(message, e);
                }
            }
            try {
                writeMethod.invoke(bean, target);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_UNABLE_TO_SET_PROPERTY_ERROR", this.pd.getName(), ManagedBeanBuilder.this.beanInfo.getName());
                throw new ManagedBeanCreationException(message, e);
            }
        }
    }

    private class BakedMapProperty
    implements BakedProperty {
        Map<BeanBuilder.Expression, BeanBuilder.Expression> mapEntries;
        PropertyDescriptor pd;

        BakedMapProperty(Map<BeanBuilder.Expression, BeanBuilder.Expression> mapEntries, PropertyDescriptor pd) {
            this.mapEntries = mapEntries;
            this.pd = pd;
        }

        @Override
        public void set(Object bean, FacesContext context) {
            Method readMethod = this.pd.getReadMethod();
            Map target = null;
            boolean mapReturned = false;
            if (readMethod != null) {
                try {
                    target = (Map)readMethod.invoke(bean, RIConstants.EMPTY_METH_ARGS);
                    mapReturned = target != null;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            if (target == null) {
                target = new HashMap();
            }
            ManagedBeanBuilder.this.initMap(this.mapEntries, target, context);
            if (!mapReturned) {
                Method writeMethod = this.pd.getWriteMethod();
                try {
                    writeMethod.invoke(bean, target);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_UNABLE_TO_SET_PROPERTY_ERROR", this.pd.getName(), ManagedBeanBuilder.this.beanInfo.getName());
                    throw new ManagedBeanPreProcessingException(message, e);
                }
            }
        }
    }

    private static interface BakedProperty {
        public void set(Object var1, FacesContext var2);
    }

    private static enum PropertyType {
        MAP,
        LIST,
        BEAN;

    }
}

