/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.typinghooks;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;

public class CssTypedTextInterceptor
implements TypedTextInterceptor {
    static boolean inTest;
    private static final char[][] PAIRS;
    static char justAddedPair;
    static int justAddedPairOffset;

    private int pairIndex(char ch) {
        for (int i = 0; i < PAIRS.length; ++i) {
            char pair = PAIRS[i][0];
            if (pair != ch) continue;
            return i;
        }
        return -1;
    }

    public boolean beforeInsert(final TypedTextInterceptor.Context context) throws BadLocationException {
        final BaseDocument doc = (BaseDocument)context.getDocument();
        final AtomicBoolean result = new AtomicBoolean();
        final AtomicReference ble = new AtomicReference();
        doc.runAtomic(new Runnable(){
            final /* synthetic */ CssTypedTextInterceptor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    int pairIdx;
                    int offset = context.getOffset();
                    char ch = context.getText().charAt(0);
                    if (justAddedPair == ch && justAddedPairOffset == offset) {
                        justAddedPair = '\u0000';
                        justAddedPairOffset = -1;
                        context.getComponent().setCaretPosition(offset + 1);
                        result.set(true);
                        return;
                    }
                    justAddedPair = '\u0000';
                    justAddedPairOffset = -1;
                    TokenHierarchy hi = TokenHierarchy.get((Document)doc);
                    TokenSequence ts = LexerUtils.getTokenSequence((TokenHierarchy)hi, (int)context.getOffset(), (Language)CssTokenId.language(), (boolean)true);
                    if (ts == null) {
                        return;
                    }
                    if (ch == '}') {
                        ts.move(offset);
                        if (ts.moveNext() && ts.token().id() == CssTokenId.RBRACE) {
                            context.getComponent().setCaretPosition(offset + 1);
                            result.set(true);
                            return;
                        }
                    }
                    if ((pairIdx = this.this$0.pairIndex(ch)) == -1) {
                        return;
                    }
                    if (ch == '\'' || ch == '\"') {
                        if (CssTypedTextInterceptor.findHtmlValueToken(hi, offset)) {
                            return;
                        }
                        int diff = ts.move(offset);
                        if (ts.moveNext()) {
                            Token t = ts.token();
                            if (t.id() == CssTokenId.STRING) {
                                char front = t.text().charAt(diff);
                                if (front == ch) {
                                    context.getComponent().setCaretPosition(offset + 1);
                                    result.set(true);
                                    return;
                                }
                                return;
                            }
                            if (t.text().length() > 0 && Character.isJavaIdentifierPart(t.text().charAt(diff))) {
                                return;
                            }
                            diff = ts.move(offset);
                            if (ts.moveNext()) {
                                do {
                                    if ((t = ts.token()).text().charAt(0) == ch) {
                                        if (t.id() == CssTokenId.STRING) break;
                                        return;
                                    }
                                    if (CharSequenceUtilities.indexOf((CharSequence)t.text(), (int)ch) == -1) continue;
                                    return;
                                } while (t.id() != CssTokenId.LBRACE && t.id() != CssTokenId.RBRACE && t.id() != CssTokenId.SEMI && ts.movePrevious());
                            }
                        }
                    }
                    justAddedPair = PAIRS[pairIdx][1];
                    justAddedPairOffset = offset + 1;
                    context.getDocument().insertString(offset, String.valueOf(PAIRS[pairIdx][0]), null);
                    context.getDocument().insertString(offset + 1, String.valueOf(justAddedPair), null);
                    context.getComponent().setCaretPosition(offset + 1);
                    result.set(true);
                }
                catch (BadLocationException ex) {
                    ble.set(ex);
                }
            }
        });
        if (ble.get() != null) {
            throw (BadLocationException)ble.get();
        }
        return result.get();
    }

    private static boolean findHtmlValueToken(TokenHierarchy<?> hi, int offset) {
        boolean found = CssTypedTextInterceptor.findHtmlValueToken(hi, offset, true);
        return found ? true : CssTypedTextInterceptor.findHtmlValueToken(hi, offset, false);
    }

    private static boolean findHtmlValueToken(TokenHierarchy<?> hi, int offset, boolean backward) {
        List embeddedTokenSequences = hi.embeddedTokenSequences(offset, backward);
        for (TokenSequence htmlts : embeddedTokenSequences) {
            int ediff;
            if (!htmlts.language().mimeType().equals("text/html") || ((ediff = htmlts.move(offset)) != 0 || !backward || !htmlts.movePrevious()) && !htmlts.moveNext()) continue;
            TokenId id = htmlts.token().id();
            return id.name().equals("VALUE_CSS");
        }
        return false;
    }

    public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
    }

    public void afterInsert(TypedTextInterceptor.Context context) throws BadLocationException {
        int lineStart;
        char ch = context.getText().charAt(0);
        if ('}' == ch && (lineStart = Utilities.getRowFirstNonWhite((BaseDocument)((BaseDocument)context.getDocument()), (int)context.getOffset())) == context.getOffset()) {
            this.reindentLater((BaseDocument)context.getDocument(), context.getOffset(), context.getOffset());
        }
    }

    private void reindentLater(final BaseDocument doc, int start, int end) throws BadLocationException {
        final Position from = doc.createPosition(Utilities.getRowStart((BaseDocument)doc, (int)start));
        final Position to = doc.createPosition(Utilities.getRowEnd((BaseDocument)doc, (int)end));
        Runnable rn = new Runnable(){
            final /* synthetic */ CssTypedTextInterceptor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                final Indent indent = Indent.get((Document)doc);
                indent.lock();
                try {
                    doc.runAtomic(new Runnable(){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            try {
                                indent.reindent(from.getOffset(), to.getOffset());
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                }
                finally {
                    indent.unlock();
                }
            }
        };
        if (inTest) {
            rn.run();
        } else {
            SwingUtilities.invokeLater(rn);
        }
    }

    public void cancelled(TypedTextInterceptor.Context context) {
    }

    static {
        PAIRS = new char[][]{{'{', '}'}, {'\"', '\"'}, {'\'', '\''}, {'(', ')'}, {'[', ']'}};
        justAddedPairOffset = -1;
    }

    public static final class Factory
    implements TypedTextInterceptor.Factory {
        public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
            return new CssTypedTextInterceptor();
        }
    }
}

