/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.lib.editor.util.StringEscapeUtils;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.editor.module.main.Bundle;
import org.netbeans.modules.css.editor.module.spi.FeatureContext;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class TopLevelStructureItem
implements StructureItem {
    private final ElementHandle elementHandle;

    public TopLevelStructureItem(String name, FileObject fileObject) {
        this.elementHandle = new TopElementHandle(fileObject, name);
    }

    public String getName() {
        return this.elementHandle.getName();
    }

    public String getSortText() {
        return this.elementHandle.getName();
    }

    public String getHtml(HtmlFormatter formatter) {
        return StringEscapeUtils.escapeHtml((String)this.elementHandle.getName());
    }

    public ElementHandle getElementHandle() {
        return this.elementHandle;
    }

    public ElementKind getKind() {
        return this.elementHandle.getKind();
    }

    public Set<Modifier> getModifiers() {
        return this.elementHandle.getModifiers();
    }

    public boolean isLeaf() {
        return false;
    }

    public long getPosition() {
        return -1L;
    }

    public long getEndPosition() {
        return -1L;
    }

    public ImageIcon getCustomIcon() {
        return null;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    private static class TopElementHandle
    implements ElementHandle {
        private final FileObject fileObject;
        private final String name;

        public TopElementHandle(FileObject fileObject, String name) {
            this.fileObject = fileObject;
            this.name = name;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public String getMimeType() {
            return "text/css";
        }

        public String getName() {
            return this.name;
        }

        public String getIn() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.PACKAGE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return new OffsetRange(-1, -1);
        }
    }

    public static class Imports
    extends ChildrenSetStructureItem {
        public Imports(Collection<StructureItem> children) {
            super(Bundle.imports(), null, children);
        }
    }

    public static class AtRules
    extends ChildrenListStructureItem {
        public AtRules(List<StructureItem> children) {
            super(NbBundle.getMessage(TopLevelStructureItem.class, (String)"AtRules"), null, children);
        }
    }

    public static class Namespaces
    extends ChildrenListStructureItem {
        public Namespaces(List<StructureItem> children) {
            super(NbBundle.getMessage(TopLevelStructureItem.class, (String)"Namespaces"), null, children);
        }
    }

    public static class Ids
    extends ChildrenSetStructureItem {
        public Ids(Collection<StructureItem> children) {
            super(NbBundle.getMessage(TopLevelStructureItem.class, (String)"Ids"), null, children);
        }
    }

    public static class Classes
    extends ChildrenSetStructureItem {
        public Classes(Collection<StructureItem> children) {
            super(NbBundle.getMessage(TopLevelStructureItem.class, (String)"Classes"), null, children);
        }
    }

    public static class Elements
    extends ChildrenSetStructureItem {
        public Elements(Collection<StructureItem> items) {
            super(NbBundle.getMessage(TopLevelStructureItem.class, (String)"Elements"), null, items);
        }
    }

    public static class Rules
    extends ChildrenListStructureItem {
        private final Snapshot snapshot;

        public Rules(List<StructureItem> children, FeatureContext context) {
            super(NbBundle.getMessage(TopLevelStructureItem.class, (String)"Rules"), context.getSnapshot().getSource().getFileObject(), children);
            this.snapshot = context.getSnapshot();
        }

        @Override
        public long getPosition() {
            return 0L;
        }

        @Override
        public long getEndPosition() {
            return this.snapshot.getOriginalOffset(this.snapshot.getText().length());
        }
    }

    public static abstract class ChildrenListStructureItem
    extends TopLevelStructureItem {
        private final List<StructureItem> items;

        public ChildrenListStructureItem(String name, FileObject fileObject, List<StructureItem> items) {
            super(name, fileObject);
            this.items = items;
        }

        public List<? extends StructureItem> getNestedItems() {
            return new ArrayList<StructureItem>(this.items);
        }
    }

    public static abstract class ChildrenSetStructureItem
    extends TopLevelStructureItem {
        private final Collection<StructureItem> items;

        public ChildrenSetStructureItem(String name, FileObject fileObject, Collection<StructureItem> items) {
            super(name, fileObject);
            this.items = items;
        }

        public List<? extends StructureItem> getNestedItems() {
            return new ArrayList<StructureItem>(this.items);
        }
    }
}

