/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.csl;

import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.editor.csl.CssElement;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class CssNodeElement
extends CssElement {
    private int from;
    private int to;

    public static CssNodeElement createElement(FileObject file, Node node) {
        return new CssNodeElement(file, node);
    }

    CssNodeElement(FileObject file, Node node) {
        super(file, node.unescapedImage());
        this.from = node.from();
        this.to = node.to();
    }

    public int from() {
        return this.from;
    }

    public int to() {
        return this.to;
    }

    @Override
    public OffsetRange getOffsetRange(ParserResult result) {
        int origTo;
        Snapshot s = result.getSnapshot();
        if (s.getText().length() == 0) {
            return null;
        }
        int origFrom = this.from > s.getText().length() ? 0 : s.getOriginalOffset(this.from);
        int n = origTo = this.to > s.getText().length() ? 0 : s.getOriginalOffset(this.to);
        if (origFrom == -1 || origTo == -1 || origFrom == origTo || origTo == 0) {
            return null;
        }
        return new OffsetRange(origFrom, origTo);
    }
}

