/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.ui.PathUiSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerIgnorePath
extends JPanel
implements HelpCtx.Provider {
    private static final long serialVersionUID = 48657896579437L;
    private final ProjectCustomizer.Category category;
    private final PhpProject project;
    private JButton addCodeAnalysisExcludesButton;
    private JButton addIgnorePathButton;
    private JLabel codeAnalysisExcludesInfoLabel;
    private JLabel codeAnalysisExcludesLabel;
    private JList<BasePathSupport.Item> codeAnalysisExcludesList;
    private JScrollPane codeAnalysisExcludesScrollPane;
    private JLabel ignorePathLabel;
    private JList<BasePathSupport.Item> ignorePathList;
    private JScrollPane ignorePathScrollPane;
    private JButton removeCodeAnalysisExcludesButton;
    private JButton removeIgnorePathButton;

    public CustomizerIgnorePath(ProjectCustomizer.Category category, PhpProjectProperties uiProps) {
        this.category = category;
        this.project = uiProps.getProject();
        this.initComponents();
        PathUiSupport.EditMediator.FileChooserDirectoryHandler directoryHandler = new PathUiSupport.EditMediator.FileChooserDirectoryHandler(){

            @Override
            public String getDirKey() {
                return CustomizerIgnorePath.class.getName();
            }

            @Override
            public File getCurrentDirectory() {
                return FileUtil.toFile((FileObject)ProjectPropertiesSupport.getSourcesDirectory(CustomizerIgnorePath.this.project));
            }
        };
        this.ignorePathList.setModel(uiProps.getIgnorePathListModel());
        this.ignorePathList.setCellRenderer(uiProps.getIgnorePathListRenderer());
        PathUiSupport.EditMediator.register(uiProps.getProject(), this.ignorePathList, this.addIgnorePathButton.getModel(), this.removeIgnorePathButton.getModel(), directoryHandler);
        this.codeAnalysisExcludesList.setModel(uiProps.getCodeAnalysisExcludesListModel());
        this.codeAnalysisExcludesList.setCellRenderer(uiProps.getCodeAnalysisExcludesListModelListRenderer());
        PathUiSupport.EditMediator.register(uiProps.getProject(), this.codeAnalysisExcludesList, this.addCodeAnalysisExcludesButton.getModel(), this.removeCodeAnalysisExcludesButton.getModel(), directoryHandler);
        DefaultListDataListener listDataListener = new DefaultListDataListener();
        this.ignorePathList.getModel().addListDataListener(listDataListener);
        this.codeAnalysisExcludesList.getModel().addListDataListener(listDataListener);
    }

    void validateData() {
        if (!this.validateFolders(this.ignorePathList.getModel())) {
            return;
        }
        if (!this.validateFolders(this.codeAnalysisExcludesList.getModel())) {
            return;
        }
        this.category.setErrorMessage(null);
        this.category.setValid(true);
    }

    private boolean validateFolders(ListModel<BasePathSupport.Item> model) {
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            BasePathSupport.Item item = model.getElementAt(i);
            if (item.isBroken()) continue;
            FileObject fo = item.getFileObject(this.project.getProjectDirectory());
            if (fo == null) {
                this.category.setErrorMessage(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"MSG_NotFound", (Object)item.getFilePath()));
                this.category.setValid(false);
                return false;
            }
            if (CommandUtils.isUnderAnySourceGroup(this.project, fo, false)) continue;
            this.category.setErrorMessage(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"MSG_NotSourceGroupSubdirectory", (Object)fo.getNameExt()));
            this.category.setValid(false);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.ignorePathLabel = new JLabel();
        this.ignorePathScrollPane = new JScrollPane();
        this.ignorePathList = new JList();
        this.addIgnorePathButton = new JButton();
        this.removeIgnorePathButton = new JButton();
        this.codeAnalysisExcludesLabel = new JLabel();
        this.codeAnalysisExcludesScrollPane = new JScrollPane();
        this.codeAnalysisExcludesList = new JList();
        this.addCodeAnalysisExcludesButton = new JButton();
        this.removeCodeAnalysisExcludesButton = new JButton();
        this.codeAnalysisExcludesInfoLabel = new JLabel();
        this.ignorePathLabel.setLabelFor(this.ignorePathList);
        Mnemonics.setLocalizedText((JLabel)this.ignorePathLabel, (String)NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathLabel.text"));
        this.ignorePathScrollPane.setViewportView(this.ignorePathList);
        this.ignorePathList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathList.AccessibleContext.accessibleName"));
        this.ignorePathList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addIgnorePathButton, (String)NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.addIgnorePathButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeIgnorePathButton, (String)NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.removeIgnorePathButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.codeAnalysisExcludesLabel, (String)NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.codeAnalysisExcludesLabel.text"));
        this.codeAnalysisExcludesScrollPane.setViewportView(this.codeAnalysisExcludesList);
        Mnemonics.setLocalizedText((AbstractButton)this.addCodeAnalysisExcludesButton, (String)NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.addCodeAnalysisExcludesButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeCodeAnalysisExcludesButton, (String)NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.removeCodeAnalysisExcludesButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.codeAnalysisExcludesInfoLabel, (String)NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.codeAnalysisExcludesInfoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.ignorePathScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.removeIgnorePathButton).addComponent(this.addIgnorePathButton))).addGroup(layout.createSequentialGroup().addComponent(this.codeAnalysisExcludesScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addCodeAnalysisExcludesButton).addComponent(this.removeCodeAnalysisExcludesButton))))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ignorePathLabel).addComponent(this.codeAnalysisExcludesLabel).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.codeAnalysisExcludesInfoLabel, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)));
        layout.linkSize(0, this.addCodeAnalysisExcludesButton, this.addIgnorePathButton, this.removeCodeAnalysisExcludesButton, this.removeIgnorePathButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.ignorePathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addIgnorePathButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeIgnorePathButton)).addComponent(this.ignorePathScrollPane)).addGap(18, 18, 18).addComponent(this.codeAnalysisExcludesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addCodeAnalysisExcludesButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeCodeAnalysisExcludesButton)).addComponent(this.codeAnalysisExcludesScrollPane, -1, 106, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeAnalysisExcludesInfoLabel, -2, -1, -2).addGap(0, 0, 0)));
        this.ignorePathLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathLabel.AccessibleContext.accessibleName"));
        this.ignorePathLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathLabel.AccessibleContext.accessibleDescription"));
        this.ignorePathScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathScrollPane.AccessibleContext.accessibleName"));
        this.ignorePathScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.ignorePathScrollPane.AccessibleContext.accessibleDescription"));
        this.addIgnorePathButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.addIgnorePathButton.AccessibleContext.accessibleName"));
        this.addIgnorePathButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.addIgnorePathButton.AccessibleContext.accessibleDescription"));
        this.removeIgnorePathButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.removeIgnorePathButton.AccessibleContext.accessibleName"));
        this.removeIgnorePathButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.removeIgnorePathButton.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerIgnorePath.class, (String)"CustomizerIgnorePath.AccessibleContext.accessibleDescription"));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.project.ui.customizer.CustomizerIgnorePath");
    }

    private final class DefaultListDataListener
    implements ListDataListener {
        private DefaultListDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            CustomizerIgnorePath.this.validateData();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            CustomizerIgnorePath.this.validateData();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            CustomizerIgnorePath.this.validateData();
        }
    }
}

