/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.util.logging.Logger;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.sync.SyncController;
import org.netbeans.modules.php.project.runconfigs.RunConfigRemote;
import org.netbeans.modules.php.project.ui.actions.Bundle;
import org.netbeans.modules.php.project.ui.actions.RemoteCommand;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.Displayable;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.windows.InputOutput;

public class SyncCommand
extends RemoteCommand
implements Displayable {
    static final Logger LOGGER = Logger.getLogger(SyncCommand.class.getName());
    public static final String ID = "synchronize";
    public static final String DISPLAY_NAME = Bundle.SyncCommand_label();

    public SyncCommand(PhpProject project) {
        super(project);
    }

    @Override
    public String getCommandId() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public boolean isFileSensitive() {
        return true;
    }

    @Override
    protected Runnable getContextRunnable(Lookup context) {
        final FileObject[] files = CommandUtils.filesForContext(context, ProjectPropertiesSupport.getSourcesDirectory(this.getProject()));
        return new Runnable(){
            final /* synthetic */ SyncCommand this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.synchronize(files);
            }
        };
    }

    void synchronize(FileObject[] files) {
        RemoteConfiguration remoteConfiguration = RunConfigRemote.forProject(this.getProject()).getRemoteConfiguration();
        InputOutput remoteLog = SyncCommand.getRemoteLog(remoteConfiguration.getDisplayName());
        RemoteClient remoteClient = this.getRemoteClient(remoteLog);
        SyncController syncController = files == null ? SyncController.forProject(this.getProject(), remoteClient, remoteConfiguration) : SyncController.forFiles(files, this.getProject(), remoteClient, remoteConfiguration);
        syncController.synchronize(new PrintSyncResultProcessor(remoteLog));
    }

    private static final class PrintSyncResultProcessor
    implements SyncController.SyncResultProcessor {
        private final InputOutput remoteLog;

        public PrintSyncResultProcessor(InputOutput remoteLog) {
            this.remoteLog = remoteLog;
        }

        @Override
        public void process(SyncController.SyncResult result) {
            this.remoteLog.select();
            RemoteCommand.processTransferInfo(result.getDownloadTransferInfo(), this.remoteLog, Bundle.SyncCommand_download_title());
            RemoteCommand.processTransferInfo(result.getUploadTransferInfo(), this.remoteLog, Bundle.SyncCommand_upload_title());
            RemoteCommand.processTransferInfo(result.getLocalDeleteTransferInfo(), this.remoteLog, Bundle.SyncCommand_localDelete_title());
            RemoteCommand.processTransferInfo(result.getRemoteDeleteTransferInfo(), this.remoteLog, Bundle.SyncCommand_remoteDelete_title());
        }
    }
}

