/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ftp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.ftp.FtpConfiguration;
import org.netbeans.modules.php.project.connections.ftp.FtpConfigurationValidator;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class FtpConfigurationPanel
extends JPanel
implements RemoteConfigurationPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String error = null;
    private String warning = null;
    private boolean passwordRead = false;
    private JCheckBox anonymousCheckBox;
    private JComboBox<FtpConfiguration.Encryption> encryptionComboBox;
    private JLabel encryptionLabel;
    private JLabel externalIpLabel;
    private JTextField externalIpTextField;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JCheckBox ignoreDisconnectErrorsCheckBox;
    private JLabel initialDirectoryLabel;
    private JTextField initialDirectoryTextField;
    private JLabel keepAliveInfoLabel;
    private JLabel keepAliveLabel;
    private JTextField keepAliveTextField;
    private JTextField maxPortRangeTextField;
    private JTextField minPortRangeTextField;
    private JCheckBox onlyLoginSecuredCheckBox;
    private JCheckBox passiveModeCheckBox;
    private JLabel passwordLabel;
    private JLabel passwordLabelInfo;
    private JPasswordField passwordTextField;
    private JLabel portLabel;
    private JLabel portRangeLabel;
    private JTextField portTextField;
    private JLabel separatorLabel;
    private JLabel timeoutLabel;
    private JTextField timeoutTextField;
    private JLabel userLabel;
    private JTextField userTextField;

    public FtpConfigurationPanel() {
        this.initComponents();
        this.init();
        this.registerListeners();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean isValidConfiguration() {
        this.setError(null);
        this.setWarning(null);
        ValidationResult validationResult = new FtpConfigurationValidator().validate(this.getHostName(), this.getPort(), this.isAnonymousLogin(), this.getUserName(), this.getInitialDirectory(), this.getTimeout(), this.getKeepAliveInterval(), this.isPassiveMode(), this.getExternalIp(), this.getMinPortRange(), this.getMaxPortRange()).getResult();
        if (validationResult.hasErrors()) {
            this.setError(((ValidationResult.Message)validationResult.getErrors().get(0)).getMessage());
            return false;
        }
        if (validationResult.hasWarnings()) {
            this.setWarning(((ValidationResult.Message)validationResult.getWarnings().get(0)).getMessage());
        }
        return true;
    }

    @Override
    public String getError() {
        return this.error;
    }

    protected void setError(String error) {
        this.error = error;
    }

    @Override
    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    private void init() {
        this.populateEncryptionComboBox();
        this.setEnabledOnlyLoginSecured();
        this.setEnabledLoginCredentials();
    }

    void setEnabledLoginCredentials() {
        this.setEnabledLoginCredentials(!this.anonymousCheckBox.isSelected());
    }

    private void setEnabledLoginCredentials(boolean enabled) {
        this.userTextField.setEnabled(enabled);
        this.passwordTextField.setEnabled(enabled);
    }

    void setEnabledOnlyLoginSecured() {
        this.onlyLoginSecuredCheckBox.setEnabled(this.getEncryptionInternal() != FtpConfiguration.Encryption.NONE);
    }

    private void populateEncryptionComboBox() {
        for (FtpConfiguration.Encryption encryption : FtpConfiguration.Encryption.values()) {
            this.encryptionComboBox.addItem(encryption);
        }
        this.encryptionComboBox.setRenderer(new EncryptionRenderer());
    }

    private void registerListeners() {
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        DefaultActionListener actionListener = new DefaultActionListener();
        this.hostTextField.getDocument().addDocumentListener(documentListener);
        this.portTextField.getDocument().addDocumentListener(documentListener);
        this.encryptionComboBox.addActionListener(actionListener);
        this.onlyLoginSecuredCheckBox.addActionListener(actionListener);
        this.userTextField.getDocument().addDocumentListener(documentListener);
        this.passwordTextField.getDocument().addDocumentListener(documentListener);
        this.anonymousCheckBox.addActionListener(actionListener);
        this.initialDirectoryTextField.getDocument().addDocumentListener(documentListener);
        this.timeoutTextField.getDocument().addDocumentListener(documentListener);
        this.keepAliveTextField.getDocument().addDocumentListener(documentListener);
        this.passiveModeCheckBox.addActionListener(actionListener);
        this.externalIpTextField.getDocument().addDocumentListener(documentListener);
        this.minPortRangeTextField.getDocument().addDocumentListener(documentListener);
        this.maxPortRangeTextField.getDocument().addDocumentListener(documentListener);
        this.ignoreDisconnectErrorsCheckBox.addActionListener(actionListener);
        this.anonymousCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FtpConfigurationPanel.this.setEnabledLoginCredentials();
            }
        });
        this.encryptionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FtpConfigurationPanel.this.setEnabledOnlyLoginSecured();
            }
        });
        this.passiveModeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean enabled = e.getStateChange() == 2;
                FtpConfigurationPanel.this.externalIpLabel.setEnabled(enabled);
                FtpConfigurationPanel.this.externalIpTextField.setEnabled(enabled);
                FtpConfigurationPanel.this.portRangeLabel.setEnabled(enabled);
                FtpConfigurationPanel.this.minPortRangeTextField.setEnabled(enabled);
                FtpConfigurationPanel.this.separatorLabel.setEnabled(enabled);
                FtpConfigurationPanel.this.maxPortRangeTextField.setEnabled(enabled);
            }
        });
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private FtpConfiguration.Encryption getEncryptionInternal() {
        return (FtpConfiguration.Encryption)((Object)this.encryptionComboBox.getSelectedItem());
    }

    private void initComponents() {
        this.hostLabel = new JLabel();
        this.hostTextField = new JTextField();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.encryptionLabel = new JLabel();
        this.encryptionComboBox = new JComboBox();
        this.onlyLoginSecuredCheckBox = new JCheckBox();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.anonymousCheckBox = new JCheckBox();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JPasswordField();
        this.initialDirectoryLabel = new JLabel();
        this.initialDirectoryTextField = new JTextField();
        this.timeoutLabel = new JLabel();
        this.timeoutTextField = new JTextField();
        this.keepAliveLabel = new JLabel();
        this.keepAliveTextField = new JTextField();
        this.keepAliveInfoLabel = new JLabel();
        this.passiveModeCheckBox = new JCheckBox();
        this.passwordLabelInfo = new JLabel();
        this.externalIpLabel = new JLabel();
        this.externalIpTextField = new JTextField();
        this.portRangeLabel = new JLabel();
        this.minPortRangeTextField = new JTextField();
        this.separatorLabel = new JLabel();
        this.maxPortRangeTextField = new JTextField();
        this.ignoreDisconnectErrorsCheckBox = new JCheckBox();
        this.hostLabel.setLabelFor(this.hostTextField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostLabel.text_1"));
        this.hostTextField.setMinimumSize(new Dimension(150, 19));
        this.portLabel.setLabelFor(this.portTextField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portLabel.text_1"));
        this.portTextField.setMinimumSize(new Dimension(20, 19));
        this.encryptionLabel.setLabelFor(this.encryptionComboBox);
        Mnemonics.setLocalizedText((JLabel)this.encryptionLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.encryptionLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.onlyLoginSecuredCheckBox, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.onlyLoginSecuredCheckBox.text"));
        this.userLabel.setLabelFor(this.userTextField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userLabel.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.anonymousCheckBox, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.anonymousCheckBox.text_1"));
        this.passwordLabel.setLabelFor(this.passwordTextField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabel.text_1"));
        this.initialDirectoryLabel.setLabelFor(this.initialDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.initialDirectoryLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryLabel.text_1"));
        this.timeoutLabel.setLabelFor(this.timeoutTextField);
        Mnemonics.setLocalizedText((JLabel)this.timeoutLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutLabel.text_1"));
        this.timeoutTextField.setMinimumSize(new Dimension(20, 19));
        this.keepAliveLabel.setLabelFor(this.keepAliveTextField);
        Mnemonics.setLocalizedText((JLabel)this.keepAliveLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.keepAliveLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.keepAliveInfoLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.keepAliveInfoLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.passiveModeCheckBox, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passiveModeCheckBox.text_1"));
        this.passwordLabelInfo.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabelInfo, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabelInfo.text_1"));
        this.externalIpLabel.setLabelFor(this.externalIpTextField);
        Mnemonics.setLocalizedText((JLabel)this.externalIpLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.externalIpLabel.text"));
        this.externalIpTextField.setColumns(18);
        Mnemonics.setLocalizedText((JLabel)this.portRangeLabel, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portRangeLabel.text"));
        this.minPortRangeTextField.setColumns(6);
        Mnemonics.setLocalizedText((JLabel)this.separatorLabel, (String)"-");
        this.maxPortRangeTextField.setColumns(6);
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreDisconnectErrorsCheckBox, (String)NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.ignoreDisconnectErrorsCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLabel).addComponent(this.userLabel).addComponent(this.passwordLabel).addComponent(this.initialDirectoryLabel).addComponent(this.timeoutLabel).addComponent(this.keepAliveLabel).addComponent(this.encryptionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.userTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.anonymousCheckBox)).addComponent(this.passwordTextField).addComponent(this.initialDirectoryTextField).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.hostTextField, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portTextField, -2, 50, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.onlyLoginSecuredCheckBox).addComponent(this.passwordLabelInfo).addComponent(this.encryptionComboBox, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.keepAliveTextField, GroupLayout.Alignment.LEADING, -1, 41, Short.MAX_VALUE).addComponent(this.timeoutTextField, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keepAliveInfoLabel))).addContainerGap()))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passiveModeCheckBox).addComponent(this.ignoreDisconnectErrorsCheckBox)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.externalIpLabel).addComponent(this.portRangeLabel)).addGap(60, 60, 60).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.minPortRangeTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separatorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPortRangeTextField, -2, -1, -2)).addComponent(this.externalIpTextField, -2, -1, -2))));
        layout.linkSize(0, this.keepAliveTextField, this.portTextField, this.timeoutTextField);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostLabel).addComponent(this.portLabel).addComponent(this.portTextField, -2, -1, -2).addComponent(this.hostTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encryptionLabel).addComponent(this.encryptionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.onlyLoginSecuredCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userLabel).addComponent(this.anonymousCheckBox).addComponent(this.userTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordLabelInfo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.initialDirectoryLabel).addComponent(this.initialDirectoryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeoutTextField, -2, -1, -2).addComponent(this.timeoutLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keepAliveLabel).addComponent(this.keepAliveTextField, -2, -1, -2).addComponent(this.keepAliveInfoLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passiveModeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.externalIpLabel).addComponent(this.externalIpTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portRangeLabel).addComponent(this.minPortRangeTextField, -2, -1, -2).addComponent(this.separatorLabel).addComponent(this.maxPortRangeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ignoreDisconnectErrorsCheckBox)));
        this.hostLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostLabel.AccessibleContext.accessibleName"));
        this.hostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostLabel.AccessibleContext.accessibleDescription"));
        this.hostTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostTextField.AccessibleContext.accessibleName"));
        this.hostTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.hostTextField.AccessibleContext.accessibleDescription"));
        this.portLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portLabel.AccessibleContext.accessibleName"));
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portLabel.AccessibleContext.accessibleDescription"));
        this.portTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portTextField.AccessibleContext.accessibleName"));
        this.portTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.portTextField.AccessibleContext.accessibleDescription"));
        this.encryptionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.encryptionLabel.AccessibleContext.accessibleName"));
        this.encryptionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.encryptionLabel.AccessibleContext.accessibleDescription"));
        this.encryptionComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.encryptionComboBox.AccessibleContext.accessibleName"));
        this.encryptionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.encryptionComboBox.AccessibleContext.accessibleDescription"));
        this.onlyLoginSecuredCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.dataChannelSecuredCheckBox.AccessibleContext.accessibleName"));
        this.onlyLoginSecuredCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.dataChannelSecuredCheckBox.AccessibleContext.accessibleDescription"));
        this.userLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userLabel.AccessibleContext.accessibleName"));
        this.userLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userLabel.AccessibleContext.accessibleDescription"));
        this.userTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userTextField.AccessibleContext.accessibleName"));
        this.userTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.userTextField.AccessibleContext.accessibleDescription"));
        this.anonymousCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.anonymousCheckBox.AccessibleContext.accessibleName"));
        this.anonymousCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.anonymousCheckBox.AccessibleContext.accessibleDescription"));
        this.passwordLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabel.AccessibleContext.accessibleName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabel.AccessibleContext.accessibleDescription"));
        this.passwordTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordTextField.AccessibleContext.accessibleName"));
        this.passwordTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordTextField.AccessibleContext.accessibleDescription"));
        this.initialDirectoryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryLabel.AccessibleContext.accessibleName"));
        this.initialDirectoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryLabel.AccessibleContext.accessibleDescription"));
        this.initialDirectoryTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryTextField.AccessibleContext.accessibleName"));
        this.initialDirectoryTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.initialDirectoryTextField.AccessibleContext.accessibleDescription"));
        this.timeoutLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutLabel.AccessibleContext.accessibleName"));
        this.timeoutLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutLabel.AccessibleContext.accessibleDescription"));
        this.timeoutTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutTextField.AccessibleContext.accessibleName"));
        this.timeoutTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.timeoutTextField.AccessibleContext.accessibleDescription"));
        this.keepAliveLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.keepAliveLabel.AccessibleContext.accessibleName"));
        this.keepAliveLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.keepAliveLabel.AccessibleContext.accessibleDescription"));
        this.keepAliveTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.keepAliveTextField.AccessibleContext.accessibleName"));
        this.keepAliveTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.keepAliveTextField.AccessibleContext.accessibleDescription"));
        this.passiveModeCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passiveModeCheckBox.AccessibleContext.accessibleName"));
        this.passiveModeCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passiveModeCheckBox.AccessibleContext.accessibleDescription"));
        this.passwordLabelInfo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabelInfo.AccessibleContext.accessibleName"));
        this.passwordLabelInfo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.passwordLabelInfo.AccessibleContext.accessibleDescription"));
        this.ignoreDisconnectErrorsCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.ignoreDisconnectErrorsCheckBox.AccessibleContext.accessibleName"));
        this.ignoreDisconnectErrorsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.ignoreDisconnectErrorsCheckBox.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FtpConfigurationPanel.class, (String)"FtpConfigurationPanel.AccessibleContext.accessibleDescription"));
    }

    public String getHostName() {
        return this.hostTextField.getText();
    }

    public void setHostName(String hostName) {
        this.hostTextField.setText(hostName);
    }

    public String getPort() {
        return this.portTextField.getText();
    }

    public void setPort(String port) {
        this.portTextField.setText(port);
    }

    public String getEncryption() {
        return this.getEncryptionInternal().name();
    }

    public void setEncryption(String encryption) {
        this.encryptionComboBox.setSelectedItem((Object)FtpConfiguration.Encryption.valueOf(encryption));
        this.setEnabledOnlyLoginSecured();
    }

    public boolean isOnlyLoginSecured() {
        return this.onlyLoginSecuredCheckBox.isSelected();
    }

    public void setOnlyLoginSecured(boolean onlyLoginSecured) {
        this.onlyLoginSecuredCheckBox.setSelected(onlyLoginSecured);
    }

    public String getUserName() {
        return this.userTextField.getText();
    }

    public void setUserName(String userName) {
        this.userTextField.setText(userName);
    }

    public String getPassword() {
        return new String(this.passwordTextField.getPassword());
    }

    public void setPassword(String password) {
        this.passwordTextField.setText(password);
    }

    public boolean isAnonymousLogin() {
        return this.anonymousCheckBox.isSelected();
    }

    public void setAnonymousLogin(boolean anonymousLogin) {
        this.anonymousCheckBox.setSelected(anonymousLogin);
        this.setEnabledLoginCredentials();
    }

    public String getInitialDirectory() {
        return this.initialDirectoryTextField.getText();
    }

    public void setInitialDirectory(String initialDirectory) {
        this.initialDirectoryTextField.setText(initialDirectory);
    }

    public String getTimeout() {
        return this.timeoutTextField.getText();
    }

    public void setTimeout(String timeout) {
        this.timeoutTextField.setText(timeout);
    }

    public String getKeepAliveInterval() {
        return this.keepAliveTextField.getText();
    }

    public void setKeepAliveInterval(String keepAliveInterval) {
        this.keepAliveTextField.setText(keepAliveInterval);
    }

    public boolean isPassiveMode() {
        return this.passiveModeCheckBox.isSelected();
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveModeCheckBox.setSelected(passiveMode);
    }

    public String getExternalIp() {
        return this.externalIpTextField.getText().trim();
    }

    public void setExternalIp(String ip) {
        this.externalIpTextField.setText(ip);
    }

    public String getMinPortRange() {
        return this.minPortRangeTextField.getText();
    }

    public void setMinPortRange(String portRange) {
        this.minPortRangeTextField.setText(portRange);
    }

    public String getMaxPortRange() {
        return this.maxPortRangeTextField.getText();
    }

    public void setMaxPortRange(String portRange) {
        this.maxPortRangeTextField.setText(portRange);
    }

    public boolean getIgnoreDisconnectErrors() {
        return this.ignoreDisconnectErrorsCheckBox.isSelected();
    }

    public void setIgnoreDisconnectErrors(boolean ignoreDisconnectErrors) {
        this.ignoreDisconnectErrorsCheckBox.setSelected(ignoreDisconnectErrors);
    }

    @Override
    public void read(ConfigManager.Configuration cfg) {
        this.setHostName(cfg.getValue("host"));
        this.setPort(cfg.getValue("port"));
        this.setEncryption(cfg.getValue("encryption"));
        this.setOnlyLoginSecured(Boolean.valueOf(cfg.getValue("onlyLoginEncrypted")));
        this.setUserName(cfg.getValue("user"));
        this.setPassword(this.readPassword(cfg));
        this.setAnonymousLogin(Boolean.valueOf(cfg.getValue("anonymousLogin")));
        this.setInitialDirectory(cfg.getValue("initialDirectory"));
        this.setTimeout(cfg.getValue("timeout"));
        this.setKeepAliveInterval(cfg.getValue("keepAliveInterval"));
        this.setPassiveMode(Boolean.valueOf(cfg.getValue("passiveMode")));
        this.setExternalIp(cfg.getValue("activeExternalIp"));
        this.setMinPortRange(this.readOptionalNumber(cfg.getValue("activePortMin")));
        this.setMaxPortRange(this.readOptionalNumber(cfg.getValue("activePortMax")));
        this.setIgnoreDisconnectErrors(Boolean.valueOf(cfg.getValue("ignoreDisconnectErrors")));
    }

    @Override
    public void store(ConfigManager.Configuration cfg) {
        cfg.putValue("host", this.getHostName());
        cfg.putValue("port", this.getPort());
        cfg.putValue("encryption", this.getEncryption());
        cfg.putValue("onlyLoginEncrypted", String.valueOf(this.isOnlyLoginSecured()));
        cfg.putValue("user", this.getUserName());
        cfg.putValue("password", this.getPassword(), true);
        cfg.putValue("anonymousLogin", String.valueOf(this.isAnonymousLogin()));
        cfg.putValue("initialDirectory", RemoteUtils.sanitizeUploadDirectory(this.getInitialDirectory(), false));
        cfg.putValue("timeout", this.getTimeout());
        cfg.putValue("keepAliveInterval", this.getKeepAliveInterval());
        cfg.putValue("passiveMode", String.valueOf(this.isPassiveMode()));
        cfg.putValue("activeExternalIp", this.getExternalIp());
        cfg.putValue("activePortMin", this.storeOptionalNumber(this.getMinPortRange()));
        cfg.putValue("activePortMax", this.storeOptionalNumber(this.getMaxPortRange()));
        cfg.putValue("ignoreDisconnectErrors", String.valueOf(this.getIgnoreDisconnectErrors()));
    }

    private String readPassword(ConfigManager.Configuration cfg) {
        if (!this.passwordRead) {
            this.passwordRead = true;
            return new FtpConfiguration(cfg).getPassword();
        }
        return cfg.getValue("password", true);
    }

    private String readOptionalNumber(String number) {
        if ("-1".equals(number)) {
            return "";
        }
        return number;
    }

    private String storeOptionalNumber(String number) {
        if (StringUtils.hasText((String)number)) {
            return number;
        }
        return "-1";
    }

    public static class EncryptionRenderer
    extends JLabel
    implements ListCellRenderer<FtpConfiguration.Encryption>,
    UIResource {
        private static final long serialVersionUID = 567683279879854654L;

        public EncryptionRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends FtpConfiguration.Encryption> list, FtpConfiguration.Encryption value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                this.setText(value.getLabel());
            }
            this.setIcon(null);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            FtpConfigurationPanel.this.fireChange();
        }
    }

    private final class DefaultActionListener
    implements ActionListener {
        private DefaultActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FtpConfigurationPanel.this.fireChange();
        }
    }
}

