/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.toml.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.vieiro.toml.antlr4.TOMLAntlrParser;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.languages.toml.TomlParser;
import org.netbeans.modules.languages.toml.structure.TomlStructureItem;
import org.openide.filesystems.FileObject;

public final class TomlStructureScanner
implements StructureScanner {
    public List<? extends StructureItem> scan(ParserResult info) {
        if (info instanceof TomlParser.TomlParserResult) {
            TomlParser.TomlParserResult result = (TomlParser.TomlParserResult)info;
            TOMLAntlrParser.DocumentContext document = result.getDocument();
            FileObject fo = info.getSnapshot().getSource().getFileObject();
            if (document != null) {
                return this.createStructureFromDocumentContext(fo, document);
            }
        }
        return Collections.emptyList();
    }

    public Map<String, List<OffsetRange>> folds(ParserResult info) {
        return Collections.emptyMap();
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(true, false);
    }

    private List<? extends StructureItem> createStructureFromDocumentContext(FileObject fo, TOMLAntlrParser.DocumentContext document) {
        if (document == null) {
            return Collections.emptyList();
        }
        ArrayList<StructureItem> items = new ArrayList<StructureItem>();
        for (TOMLAntlrParser.ExpressionContext expression : document.expression()) {
            TOMLAntlrParser.TableContext table = expression.table();
            if (table == null) continue;
            if (table.array_table() != null) {
                items.add(this.createArrayTableItem(fo, table.array_table()));
                continue;
            }
            if (table.standard_table() == null) continue;
            items.add(this.createStandardTableItem(fo, table.standard_table()));
        }
        return items;
    }

    private StructureItem createArrayTableItem(FileObject fo, TOMLAntlrParser.Array_tableContext array_table) {
        return new TomlStructureItem(fo, array_table);
    }

    private StructureItem createStandardTableItem(FileObject fo, TOMLAntlrParser.Standard_tableContext standard_table) {
        return new TomlStructureItem(fo, standard_table);
    }
}

