/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APITypeMapper;
import java.awt.EventQueue;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Format;
import java.util.logging.Level;
import org.netbeans.modules.extbrowser.BrowserUtils;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.NbBrowserException;
import org.netbeans.modules.extbrowser.PrivateBrowserFamilyId;
import org.netbeans.modules.extbrowser.SimpleExtBrowser;
import org.netbeans.modules.extbrowser.URLUtil;
import org.netbeans.modules.extbrowser.impl.ShlwapiUtil;
import org.openide.execution.NbProcessDescriptor;

public class NbDdeBrowserImpl
extends ExtBrowserImpl {
    public NbDdeBrowserImpl(ExtWebBrowser extBrowserFactory) {
        this.extBrowserFactory = extBrowserFactory;
        NbDdeBrowserImpl.logFine("NbDdeBrowserImpl created with factory:", extBrowserFactory);
    }

    public static String getBrowserPath(String browser) throws NbBrowserException {
        String key = String.format("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\%s.exe", browser);
        try {
            return NbDdeBrowserImpl.getKeyValueExpanded(WinReg.HKEY_LOCAL_MACHINE, key, null);
        }
        catch (Win32Exception ex) {
            throw new NbBrowserException("Error when retrieving path to browser, failed to read registry entry for " + key, ex);
        }
    }

    public static String getDefaultOpenCommand() throws NbBrowserException {
        try {
            String path = ShlwapiUtil.AssocQueryString(0, 1, ".html", null);
            return path;
        }
        catch (Win32Exception ex) {
            throw new NbBrowserException("Failed to determine default open command", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getKeyValueExpanded(WinReg.HKEY root, String key, String value) throws Win32Exception, NbBrowserException {
        WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
        int rc = Advapi32.INSTANCE.RegOpenKeyEx(root, key, 0, 131097, phkKey);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            IntByReference data = new IntByReference();
            IntByReference type = new IntByReference();
            rc = Advapi32.INSTANCE.RegQueryValueEx(phkKey.getValue(), value, 0, type, (Pointer)null, data);
            if (rc != 0 && rc != 122) {
                throw new Win32Exception(rc);
            }
            if (type.getValue() != 1 && type.getValue() != 2) {
                throw new NbBrowserException("Unexpected registry type " + type.getValue() + "for: " + key);
            }
            if (data.getValue() == 0) {
                String string = "";
                return string;
            }
            assert (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE);
            Memory mem = new Memory((long)(data.getValue() + Native.WCHAR_SIZE));
            mem.clear();
            rc = Advapi32.INSTANCE.RegQueryValueEx(phkKey.getValue(), value, 0, type, (Pointer)mem, data);
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
            String result = mem.getWideString(0L);
            if (type.getValue() == 2) {
                String string = Kernel32Util.expandEnvironmentStrings((String)result);
                return string;
            }
            String string = result;
            return string;
        }
        finally {
            rc = Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
        }
    }

    @Override
    protected void loadURLInBrowserInternal(URL url) {
        assert (!EventQueue.isDispatchThread());
        NbDdeBrowserImpl.logFine("NbDdeBrowserImpl.setUrl:", url);
        if (url == null) {
            return;
        }
        NbProcessDescriptor np = this.extBrowserFactory.getBrowserExecutable();
        try {
            String urlTxt;
            url = URLUtil.createExternalURL(url, false);
            if (url == null) {
                urlTxt = "";
            } else {
                try {
                    urlTxt = url.toURI().toASCIIString();
                }
                catch (URISyntaxException ex) {
                    NbDdeBrowserImpl.logInfo(ex);
                    urlTxt = url.toString();
                }
            }
            if (np != null) {
                np.exec((Format)((Object)new SimpleExtBrowser.BrowserFormat(urlTxt)));
            }
        }
        catch (IOException ex) {
            NbDdeBrowserImpl.logInfo(ex);
            BrowserUtils.notifyMissingBrowser(np.getProcessName());
        }
    }

    private static void logInfo(Exception ex) {
        ExtWebBrowser.getEM().log(Level.INFO, null, ex);
    }

    private static void logFine(String message) {
        if (ExtWebBrowser.getEM().isLoggable(Level.FINE)) {
            ExtWebBrowser.getEM().log(Level.FINE, "{0} {1}", new Object[]{System.currentTimeMillis(), message});
        }
    }

    private static void logFine(String message, Object object) {
        if (ExtWebBrowser.getEM().isLoggable(Level.FINE)) {
            ExtWebBrowser.getEM().log(Level.FINE, "{0} {1} {2}", new Object[]{System.currentTimeMillis(), message, object});
        }
    }

    @Override
    protected PrivateBrowserFamilyId detectPrivateBrowserFamilyId() {
        PrivateBrowserFamilyId id = super.detectPrivateBrowserFamilyId();
        if (id == PrivateBrowserFamilyId.UNKNOWN) {
            switch (this.realDDEServer()) {
                case "FIREFOX": {
                    id = PrivateBrowserFamilyId.FIREFOX;
                    break;
                }
                case "CHROME": {
                    id = PrivateBrowserFamilyId.CHROME;
                    break;
                }
                default: {
                    id = PrivateBrowserFamilyId.UNKNOWN;
                }
            }
        }
        return id;
    }

    private String realDDEServer() {
        NbDdeBrowserImpl.logFine("NbDdeBrowserImpl.realDDEServer");
        try {
            String cmd = NbDdeBrowserImpl.getDefaultOpenCommand();
            if (cmd != null) {
                if ((cmd = cmd.toUpperCase()).contains("IEXPLORE")) {
                    return "IEXPLORE";
                }
                if (cmd.contains("CHROME")) {
                    return "CHROME";
                }
                if (cmd.contains("FIREFOX")) {
                    return "FIREFOX";
                }
                if (cmd.contains("MOZILLA")) {
                    return "MOZILLA";
                }
            }
        }
        catch (Exception ex) {
            NbDdeBrowserImpl.logInfo(ex);
        }
        return "IEXPLORE";
    }
}

