/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.actions;

import java.awt.event.ActionEvent;
import org.netbeans.modules.payara.common.PayaraState;
import org.netbeans.modules.payara.common.actions.AbstractOutputAction;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class RestartAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(RestartAction.class, (String)"CTL_RestartAction");
    }

    protected void performAction(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            PayaraModule commonSupport = (PayaraModule)node.getLookup().lookup(PayaraModule.class);
            if (commonSupport == null) continue;
            if (commonSupport.isRemote() && commonSupport.supportsRestartInDebug()) {
                commonSupport.setEnvironmentProperty("jvmMode", PayaraModule.NORMAL_MODE, true);
            }
            RestartAction.performActionImpl(commonSupport);
        }
    }

    private static void performActionImpl(PayaraModule commonSupport) {
        commonSupport.restartServer(null);
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean result = false;
        if (activatedNodes != null && activatedNodes.length > 0) {
            Node node;
            PayaraModule commonSupport;
            Node[] nodeArray = activatedNodes;
            int n = nodeArray.length;
            for (int i = 0; i < n && (result = (commonSupport = (PayaraModule)(node = nodeArray[i]).getLookup().lookup(PayaraModule.class)) != null ? RestartAction.enableImpl(commonSupport) : false); ++i) {
            }
        }
        return result;
    }

    private static boolean enableImpl(PayaraModule commonSupport) {
        return PayaraState.isOnline(commonSupport.getInstance());
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public static class OutputAction
    extends AbstractOutputAction {
        private static final String ICON = "org/netbeans/modules/payara/common/resources/restart.png";

        public OutputAction(PayaraModule commonSupport) {
            super(commonSupport, NbBundle.getMessage(RestartAction.class, (String)"LBL_RestartOutput"), NbBundle.getMessage(RestartAction.class, (String)"LBL_RestartOutputDesc"), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RestartAction.performActionImpl(this.commonSupport);
        }

        @Override
        public boolean isEnabled() {
            return RestartAction.enableImpl(this.commonSupport);
        }
    }
}

