/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.tasks.SortAttributePanel;
import org.netbeans.modules.bugtracking.tasks.TaskAttribute;
import org.netbeans.modules.bugtracking.tasks.TaskSorter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SortPanel
extends JPanel {
    private final TaskSorter sorter = TaskSorter.getInstance();
    private final Set<SortAttributePanel> panels = new HashSet<SortAttributePanel>(4);
    private static final int NUMBER_OF_COMBOS = 4;
    private List<TaskAttribute> attributes;
    private final SortingChangeListener listener = new SortingChangeListener();
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel pnlAttributes;

    public SortPanel() {
        this.initComponents();
        this.initCombos();
        this.pnlAttributes.add((Component)new JLabel(), new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 3, 0), 0, 0));
    }

    public void saveAttributes() {
        this.sorter.setAttributes(this.attributes);
    }

    private void initComponents() {
        this.pnlAttributes = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.pnlAttributes.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SortPanel.class, (String)"SortPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 10);
        this.pnlAttributes.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SortPanel.class, (String)"SortPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 10);
        this.pnlAttributes.add((Component)this.jLabel2, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pnlAttributes, -1, 600, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.pnlAttributes, -1, 127, Short.MAX_VALUE).addContainerGap()));
    }

    private void initCombos() {
        this.attributes = new ArrayList<TaskAttribute>(this.sorter.getAttributes());
        boolean previousHasRank = true;
        for (int i = 0; i < 4; ++i) {
            TaskAttribute att = this.attributes.get(i);
            boolean hasRank = att.getRank() != Integer.MAX_VALUE;
            SortAttributePanel panel = new SortAttributePanel(this.attributes, hasRank ? att : null, i + 1);
            if (!previousHasRank) {
                panel.setEnabled(false);
            }
            previousHasRank = hasRank;
            panel.addSortingChangeListener(this.listener);
            this.pnlAttributes.add((Component)panel, new GridBagConstraints(1, i, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
            this.panels.add(panel);
        }
    }

    private class SortingChangeListener
    implements ActionListener {
        private SortingChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Collections.sort(SortPanel.this.attributes);
            boolean previousHasRank = true;
            for (SortAttributePanel panel : SortPanel.this.panels) {
                panel.removeSortingChangeListener(SortPanel.this.listener);
                TaskAttribute selectCandidate = (TaskAttribute)SortPanel.this.attributes.get(panel.getIndex() - 1);
                previousHasRank = selectCandidate.getRank() != Integer.MAX_VALUE;
                panel.updateModel(previousHasRank ? selectCandidate : null);
                if (panel.getIndex() > 1) {
                    TaskAttribute previousAttr = (TaskAttribute)SortPanel.this.attributes.get(panel.getIndex() - 2);
                    panel.setComponentsEnabled(previousAttr.getRank() != Integer.MAX_VALUE);
                }
                panel.addSortingChangeListener(SortPanel.this.listener);
            }
        }
    }
}

